/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.render;

import com.adobe.icc.dbforms.util.DBUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"fd/cm/Render"})
public class Render
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Render.class);
    private String defaultCharacterEncoding = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileName = DBUtils.getParameter("fileName", request, null);
        ServletOutputStream out = response.getOutputStream();
        try {
            String characterEncoding;
            byte[] bytes = null;
            File cachedFile = new File(fileName);
            if (cachedFile.exists()) {
                try (FileInputStream fis = new FileInputStream(cachedFile);){
                    bytes = IOUtils.toByteArray((InputStream)fis);
                }
            }
            logger.debug("Done reading from file : " + fileName);
            if (bytes == null) {
                bytes = "There was a problem rendering the PDF. The PDF Result was null.".getBytes();
            }
            if ((characterEncoding = Render.getEncoding(bytes, this.defaultCharacterEncoding)) == null || "".equals(characterEncoding)) {
                characterEncoding = this.defaultCharacterEncoding;
            }
            response.setContentType("application/pdf;charset=" + this.defaultCharacterEncoding);
            try {
                out.write(bytes);
            }
            catch (Exception e) {
                logger.debug(" Unsupported encoding, using default UTF-8", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("There was a problem rendering the PDF. ", (Throwable)e);
        }
        finally {
            out.flush();
            out.close();
        }
    }

    protected static String getEncoding(byte[] data, String defaultEncoding) {
        String dataUtf8 = null;
        try {
            dataUtf8 = data != null ? new String(data, defaultEncoding) : new String(data, Charset.forName("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug(" Unsupported encoding Format", (Throwable)e);
            dataUtf8 = new String(data, Charset.forName("UTF-8"));
        }
        return Render.getEncoding(dataUtf8);
    }

    protected static String getEncoding(String sData) {
        String searchString = "<?xml version=\"1.0\" encoding=\"";
        int searchResult = sData.indexOf(searchString);
        int searchLength = searchString.length() + searchResult;
        if (searchResult > -1) {
            searchResult = sData.indexOf("\"", searchLength);
            String encoding = sData.substring(searchLength, searchResult);
            return encoding;
        }
        return null;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.defaultCharacterEncoding = defaultCharacterEncoding;
    }
}

