/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.obj.CDMAssignment;
import com.adobe.icc.dbforms.obj.ConditionalDataModule;
import com.adobe.icc.dbforms.obj.ContainerLayoutAssignment;
import com.adobe.icc.dbforms.obj.ContentDataModule;
import com.adobe.icc.dbforms.obj.DataModule;
import com.adobe.icc.dbforms.obj.Field;
import com.adobe.icc.dbforms.obj.FieldAssignment;
import com.adobe.icc.dbforms.obj.ImageModule;
import com.adobe.icc.dbforms.obj.LDMAssignment;
import com.adobe.icc.dbforms.obj.Letter;
import com.adobe.icc.dbforms.obj.ListDataModule;
import com.adobe.icc.dbforms.obj.ModuleAssignment;
import com.adobe.icc.dbforms.obj.TargetAreaAssignment;
import com.adobe.icc.dbforms.obj.Variable;
import com.adobe.icc.dbforms.obj.VariableAssignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleUtil {
    private static final Logger logger = LoggerFactory.getLogger(ModuleUtil.class);

    public static Set<Variable> getAllVariables(DataModule dataModule) {
        HashSet<Variable> variables;
        block6: {
            ListDataModule ldm;
            block5: {
                variables = new HashSet<Variable>();
                if (dataModule.getVariableList() != null) {
                    for (Variable var : dataModule.getVariableList()) {
                        var.setDataModuleName(dataModule.getName());
                        variables.add(var);
                    }
                }
                if (!(dataModule instanceof ConditionalDataModule)) break block5;
                ConditionalDataModule cdm = (ConditionalDataModule)dataModule;
                if (cdm.getAssignmentList() == null) break block6;
                for (CDMAssignment cdma : cdm.getAssignmentList()) {
                    variables.addAll(ModuleUtil.getAllVariables(cdma.getTarget()));
                }
                break block6;
            }
            if (dataModule instanceof ListDataModule && (ldm = (ListDataModule)dataModule).getAssignmentList() != null) {
                for (LDMAssignment ldma : ldm.getAssignmentList()) {
                    variables.addAll(ModuleUtil.getAllVariables(ldma.getTarget()));
                }
            }
        }
        return variables;
    }

    public static void findUsedModules(Map<String, DataModule> allDMmap, DataModule dm, boolean fetchIndirectReferences) {
        block4: {
            block3: {
                if (allDMmap == null) {
                    allDMmap = new HashMap<String, DataModule>();
                }
                if (!(dm instanceof ListDataModule)) break block3;
                ListDataModule ldm = (ListDataModule)dm;
                for (LDMAssignment ldma : ldm.getAssignmentList()) {
                    DataModule target = ldma.getTarget();
                    allDMmap.put(target.getId(), target);
                    if (!fetchIndirectReferences) continue;
                    ModuleUtil.findUsedModules(allDMmap, target, true);
                }
                break block4;
            }
            if (!(dm instanceof ConditionalDataModule)) break block4;
            ConditionalDataModule cdm = (ConditionalDataModule)dm;
            for (CDMAssignment cdma : cdm.getAssignmentList()) {
                DataModule target = cdma.getTarget();
                allDMmap.put(target.getId(), target);
                if (!fetchIndirectReferences) continue;
                ModuleUtil.findUsedModules(allDMmap, target, true);
            }
        }
    }

    public static String[] extractRepeatableItem(String content) {
        return com.adobe.fd.df.fdinternal.util.ModuleUtil.extractRepeatableItem((String)content);
    }

    public static String extractExpressionContent(String content) {
        return com.adobe.fd.df.fdinternal.util.ModuleUtil.extractExpressionContent((String)content);
    }

    public static void findVariablesInContent(List<String> vars, String content) {
        int ppre = content.indexOf("{^");
        int ppost = content.indexOf("^}");
        while (ppre != -1 && ppre < content.length()) {
            String varName = content.substring(ppre + "{^".length(), ppost);
            vars.add(varName);
            ppre = content.indexOf("{^", ppre + "{^".length());
            ppost = content.indexOf("^}", ppost + "^}".length());
        }
        int uppre = content.indexOf("{*");
        int uppost = content.indexOf("*}");
        while (uppre != -1 && uppre < content.length()) {
            String varName = content.substring(uppre + "{*".length(), uppost);
            vars.add(varName);
            uppre = content.indexOf("{*", uppre + "{*".length());
            uppost = content.indexOf("*}", uppost + "*}".length());
        }
    }

    public static void updateRefsForVariableRemoval(Set<UniqueVariable> varsToBeRemoved, Set<VariableAssignment> curLetterVarAssgnmnts) {
        Map<String, VariableAssignment> varNameToVASToRemove = ModuleUtil.buildVarNameToVASTobeRemovedMap(varsToBeRemoved, curLetterVarAssgnmnts);
        for (VariableAssignment curAssg : curLetterVarAssgnmnts) {
            VariableAssignment vasTobeRemoved;
            String sourceRef;
            if (!VariableAssignment.Source.VARIABLE.equals((Object)curAssg.getSource()) || !varNameToVASToRemove.containsKey(sourceRef = curAssg.getSourceReference()) || (vasTobeRemoved = varNameToVASToRemove.get(sourceRef)) == null) continue;
            ModuleUtil.updateReferredVASProperties(curAssg, vasTobeRemoved);
        }
    }

    private static Map<String, VariableAssignment> buildVarNameToVASTobeRemovedMap(Set<UniqueVariable> varsToBeRemoved, Set<VariableAssignment> curLetterVarAssgnmnts) {
        HashMap<String, VariableAssignment> varIdToVAS = new HashMap<String, VariableAssignment>();
        HashMap varNameToVASList = new HashMap();
        for (VariableAssignment vas1 : curLetterVarAssgnmnts) {
            if (vas1.getVariable() != null && vas1.getVariable().getId() != null) {
                varIdToVAS.put(vas1.getVariable().getId(), vas1);
            } else if (vas1.getVariableId() != null) {
                varIdToVAS.put(vas1.getVariableId(), vas1);
            }
            if (vas1.getVariableName() == null) continue;
            if (varNameToVASList.containsKey(vas1.getVariableName())) {
                ((List)varNameToVASList.get(vas1.getVariableName())).add(vas1);
                continue;
            }
            ArrayList<VariableAssignment> vasList = new ArrayList<VariableAssignment>();
            vasList.add(vas1);
            varNameToVASList.put(vas1.getVariableName(), vasList);
        }
        HashMap<String, VariableAssignment> varNameTobeRemovedToVASMap = new HashMap<String, VariableAssignment>();
        for (UniqueVariable uniqueVarToBeRemoved : varsToBeRemoved) {
            String varName = uniqueVarToBeRemoved.getVarName();
            if (varName == null || !varIdToVAS.containsKey(uniqueVarToBeRemoved.getVarId())) continue;
            VariableAssignment vas = (VariableAssignment)varIdToVAS.get(uniqueVarToBeRemoved.getVarId());
            if (varNameToVASList.containsKey(varName)) {
                List vasList = (List)varNameToVASList.get(varName);
                if (vasList.contains(vas)) {
                    vasList.remove(vas);
                }
                if (vasList.size() != 0) continue;
                varNameTobeRemovedToVASMap.put(varName, vas);
                varNameToVASList.remove(varName);
                continue;
            }
            varNameTobeRemovedToVASMap.put(varName, vas);
        }
        return varNameTobeRemovedToVASMap;
    }

    public static void updateReferredVASProperties(VariableAssignment referringVAS, VariableAssignment vasTobeRemoved) {
        logger.debug("Updating refered variable assignments to user" + referringVAS.toString());
        referringVAS.setSource(VariableAssignment.Source.USER);
        referringVAS.setSourceReference("");
        if (VariableAssignment.Source.USER.equals((Object)vasTobeRemoved.getSource()) || VariableAssignment.Source.CONST.equals((Object)vasTobeRemoved.getSource())) {
            referringVAS.setSourceReference(vasTobeRemoved.getSourceReference());
        }
        referringVAS.setOptional(vasTobeRemoved.isOptional());
        referringVAS.setEditable(vasTobeRemoved.isEditable());
        referringVAS.setMultiLine(vasTobeRemoved.isMultiLine());
    }

    public static void updateVASBindings(VariableAssignment variableAssignment) {
        logger.debug("Updating refered variable assignments to user " + variableAssignment.toString());
        if (variableAssignment != null) {
            variableAssignment.setSource(VariableAssignment.Source.USER);
            variableAssignment.setSourceReference("");
            variableAssignment.setEditable(true);
        }
    }

    public static void updateFASBindings(FieldAssignment fieldAssignment, FieldAssignment.Bind newFieldBindType) {
        logger.debug("Updating refered Field assignments " + fieldAssignment.toString());
        if (fieldAssignment != null) {
            Field field = fieldAssignment.getField();
            if (field.getType() == Field.FieldType.IMAGE && newFieldBindType != FieldAssignment.Bind.DATAMODULE && newFieldBindType != FieldAssignment.Bind.IGNORE && newFieldBindType != FieldAssignment.Bind.SYSTEM) {
                fieldAssignment.setBinding(FieldAssignment.Bind.IGNORE);
            } else {
                fieldAssignment.setBinding(newFieldBindType);
            }
            fieldAssignment.setBindingReference("");
            fieldAssignment.setEditable(true);
        }
    }

    public static void updateVariableAssignmentForVariableRemoval(Set<String> varTobeRemovedIDs, Set<VariableAssignment> varAssgnmnts) {
        Iterator<VariableAssignment> varAssgmtIter = varAssgnmnts.iterator();
        while (varAssgmtIter.hasNext()) {
            VariableAssignment varAsgmt = varAssgmtIter.next();
            logger.debug("processing variable assignment " + varAsgmt.toString());
            String variableID = null;
            if (varAsgmt.getVariable() != null) {
                if (varAsgmt.getVariable().getId() == null) continue;
                variableID = varAsgmt.getVariable().getId();
            } else if (varAsgmt.getVariableId() != null) {
                variableID = varAsgmt.getVariableId();
            }
            if (variableID == null || !varTobeRemovedIDs.contains(variableID)) continue;
            logger.debug("removing variable assignment " + varAsgmt.toString());
            varAssgmtIter.remove();
        }
    }

    public static void checkModuleReferences(Set<TargetAreaAssignment> tasSet, Set<FieldAssignment> faSet, Map<String, List<UniqueVariable>> removedModulesAndUniqueVars, String skipModuleName) {
        if (removedModulesAndUniqueVars.size() < 1) {
            return;
        }
        if (tasSet != null && tasSet.size() > 0) {
            for (TargetAreaAssignment tas : tasSet) {
                if (removedModulesAndUniqueVars.size() < 1) {
                    return;
                }
                if (tas.getModuleAssignmentList() != null) {
                    for (ModuleAssignment mos : tas.getModuleAssignmentList()) {
                        DataModule currentModule = mos.getDataModule();
                        ModuleUtil.checkModuleReferences(currentModule, removedModulesAndUniqueVars, skipModuleName);
                    }
                }
                if (tas.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : tas.getContainerLayoutAssignmentList()) {
                    if (removedModulesAndUniqueVars.size() < 1) {
                        return;
                    }
                    ModuleUtil.checkModuleReferences(cla.getTargetAreaAssignments(), cla.getFieldAssignments(), removedModulesAndUniqueVars, skipModuleName);
                }
            }
        }
        if (faSet != null && faSet.size() > 0) {
            for (FieldAssignment fa : faSet) {
                if (!FieldAssignment.Bind.DATAMODULE.equals((Object)fa.getBinding())) continue;
                DataModule currentModule = fa.getDataModule();
                ModuleUtil.checkModuleReferences(currentModule, removedModulesAndUniqueVars, skipModuleName);
            }
        }
    }

    public static boolean isUpdateDependenciesRequired(DataModule oldDM, DataModule newDM) throws ICCException {
        Variable oldVar;
        Variable newVar;
        if (newDM != null && (newDM instanceof ImageModule || newDM instanceof ContentDataModule)) {
            return false;
        }
        HashMap<UniqueVariable, Variable> addedUniqueVarToVariable = new HashMap<UniqueVariable, Variable>();
        HashMap<UniqueVariable, Variable> removedUniqueVarToVariable = new HashMap<UniqueVariable, Variable>();
        HashMap<UniqueVariable, Variable> oldUniqueVarToOldVariable = new HashMap<UniqueVariable, Variable>();
        HashMap<UniqueVariable, Variable> oldUniqueVarToNewVariable = new HashMap<UniqueVariable, Variable>();
        ModuleUtil.populateModuleVarDiffInfo(oldDM, newDM, addedUniqueVarToVariable, removedUniqueVarToVariable, oldUniqueVarToNewVariable, oldUniqueVarToOldVariable);
        if (!addedUniqueVarToVariable.isEmpty()) {
            logger.debug("there is some variable assignment added : " + addedUniqueVarToVariable.keySet());
            return true;
        }
        if (!removedUniqueVarToVariable.isEmpty()) {
            logger.debug("there is some variable assignment removed : " + removedUniqueVarToVariable.keySet());
            return true;
        }
        for (UniqueVariable uniqueVar : oldUniqueVarToNewVariable.keySet()) {
            newVar = (Variable)oldUniqueVarToNewVariable.get(uniqueVar);
            oldVar = (Variable)oldUniqueVarToOldVariable.get(uniqueVar);
            if (newVar == null || oldVar == null) continue;
            if (newVar.getType() != oldVar.getType()) {
                return true;
            }
            if (!(Variable.VariableType.DDE.equals((Object)newVar.getType()) ? oldVar.getProtect() != newVar.getProtect() : newVar.getDataType() != null && !newVar.getDataType().equals((Object)oldVar.getDataType()))) continue;
            return true;
        }
        for (UniqueVariable uniqueVar : oldUniqueVarToNewVariable.keySet()) {
            newVar = (Variable)oldUniqueVarToNewVariable.get(uniqueVar);
            oldVar = (Variable)oldUniqueVarToOldVariable.get(uniqueVar);
            if (newVar != null && oldVar != null && oldVar.getId() != null && newVar.getId() != null) {
                if (newVar.getId().equals(oldVar.getId())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static void populateModuleVarDiffInfo(DataModule oldDM, DataModule newDM, Map<UniqueVariable, Variable> addedUniqueVarToVariable, Map<UniqueVariable, Variable> removedUniqueVarToVariable, Map<UniqueVariable, Variable> oldUniqueVarToNewVariable, Map<UniqueVariable, Variable> oldUniqueVarToOldVariable) {
        Set<Variable> oldVariableList = ModuleUtil.getAllVariables(oldDM);
        Set<Variable> newVariableList = ModuleUtil.getAllVariables(newDM);
        if (oldVariableList != null) {
            for (Variable oldVar : oldVariableList) {
                oldUniqueVarToOldVariable.put(new UniqueVariable(oldVar), oldVar);
            }
        }
        if (newVariableList != null) {
            for (Variable newVar : newVariableList) {
                UniqueVariable newUniqueVar = new UniqueVariable(newVar);
                if (oldUniqueVarToOldVariable.containsKey(newUniqueVar)) {
                    Variable oldVar = oldUniqueVarToOldVariable.get(newUniqueVar);
                    if (newVar.getId() == null) {
                        newVar.setId(oldVar.getId());
                    }
                    oldUniqueVarToNewVariable.put(new UniqueVariable(oldVar), newVar);
                    continue;
                }
                addedUniqueVarToVariable.put(newUniqueVar, newVar);
            }
        }
        removedUniqueVarToVariable.putAll(oldUniqueVarToOldVariable);
        removedUniqueVarToVariable.keySet().removeAll(oldUniqueVarToNewVariable.keySet());
    }

    private static void checkNestedModuleReferences(DataModule containerModule, Map<String, List<UniqueVariable>> removedModulesAndUniqueVars, String skipModuleName) {
        DataModule currentModule;
        if (!(containerModule instanceof ListDataModule) && !(containerModule instanceof ConditionalDataModule)) {
            return;
        }
        if (containerModule instanceof ListDataModule && ((ListDataModule)containerModule).getAssignmentList() != null) {
            for (LDMAssignment ldma : ((ListDataModule)containerModule).getAssignmentList()) {
                currentModule = ldma.getTarget();
                ModuleUtil.checkModuleReferences(currentModule, removedModulesAndUniqueVars, skipModuleName);
            }
        }
        if (containerModule instanceof ConditionalDataModule && ((ConditionalDataModule)containerModule).getAssignmentList() != null) {
            for (CDMAssignment cdma : ((ConditionalDataModule)containerModule).getAssignmentList()) {
                currentModule = cdma.getTarget();
                ModuleUtil.checkModuleReferences(currentModule, removedModulesAndUniqueVars, skipModuleName);
            }
        }
    }

    private static void checkModuleReferences(DataModule currentModule, Map<String, List<UniqueVariable>> removedModulesAndUniqueVars, String skipModuleName) {
        if (removedModulesAndUniqueVars.size() < 1) {
            return;
        }
        if (skipModuleName != null && skipModuleName.equals(currentModule.getName())) {
            return;
        }
        if (removedModulesAndUniqueVars.containsKey(currentModule.getName())) {
            removedModulesAndUniqueVars.remove(currentModule.getName());
        }
        ModuleUtil.checkNestedModuleReferences(currentModule, removedModulesAndUniqueVars, skipModuleName);
    }

    public static void cleanupVariableAssignments(Set<VariableAssignment> variableAssignments) {
        if (variableAssignments == null) {
            return;
        }
        Iterator<VariableAssignment> vaIterator = variableAssignments.iterator();
        HashMap<String, VariableAssignment> processedVariableAssignmentMap = new HashMap<String, VariableAssignment>();
        while (vaIterator.hasNext()) {
            VariableAssignment variableAssignment = vaIterator.next();
            String variableId = null;
            variableId = variableAssignment.getVariable() != null ? variableAssignment.getVariable().getId() : variableAssignment.getVariableId();
            if (variableId == null || variableId.length() <= 0) continue;
            if (processedVariableAssignmentMap.keySet().contains(variableId)) {
                VariableAssignment processedVA = (VariableAssignment)processedVariableAssignmentMap.get(variableId);
                if (ModuleUtil.objEquals((Object)processedVA.getSource(), (Object)variableAssignment.getSource()) && ModuleUtil.objEquals(processedVA.getSourceReference(), variableAssignment.getSourceReference())) {
                    vaIterator.remove();
                    logger.info("VariableAssignment Cleanup:: Removing duplicate assignment for VID:" + variableId);
                    continue;
                }
                logger.warn("VariableAssignment Cleanup:: Unable to remove duplicate assignment for VID:" + variableId + ". Source or SourceReference properties of these assignments are different. " + (Object)((Object)variableAssignment.getSource()) + ":" + variableAssignment.getSourceReference() + " vs " + (Object)((Object)processedVA.getSource()) + ":" + processedVA.getSourceReference());
                continue;
            }
            processedVariableAssignmentMap.put(variableId, variableAssignment);
        }
    }

    private static boolean objEquals(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj2 == null;
    }

    public static Map<String, Variable> getVariablesInNonRHSDataModules(Letter letter) {
        HashMap<String, Variable> variablesMap = new HashMap<String, Variable>();
        ModuleUtil.populateAllVariablesInTAAs(letter.getTargetAreaAssignments(), variablesMap);
        return variablesMap;
    }

    public static void copyVariableIds(DataModule oldDM, DataModule newDM) {
        HashMap<String, String> oldVarMap = new HashMap<String, String>();
        if (oldDM.getVariableList() != null) {
            for (Variable var : oldDM.getVariableList()) {
                oldVarMap.put(var.getName(), var.getId());
            }
        }
        if (newDM.getVariableList() != null) {
            for (Variable var : newDM.getVariableList()) {
                if (oldVarMap.get(var.getName()) == null) continue;
                var.setId((String)oldVarMap.get(var.getName()));
            }
        }
    }

    public static void generateVariableMapWithName(Set<TargetAreaAssignment> taaSet, Map<String, Variable> variablesMap) {
        if (taaSet != null) {
            for (TargetAreaAssignment taa : taaSet) {
                List<ModuleAssignment> masList = taa.getModuleAssignmentList();
                if (masList != null) {
                    for (ModuleAssignment mas : masList) {
                        Set<Variable> variables;
                        if (mas.getDataModule() == null || (variables = ModuleUtil.getAllVariables(mas.getDataModule())) == null) continue;
                        for (Variable var : variables) {
                            variablesMap.put(var.getName(), var);
                        }
                    }
                }
                if (taa.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : taa.getContainerLayoutAssignmentList()) {
                    ModuleUtil.generateVariableMapWithName(cla.getTargetAreaAssignments(), variablesMap);
                }
            }
        }
    }

    private static void populateAllVariablesInTAAs(Set<TargetAreaAssignment> taaSet, Map<String, Variable> variablesMap) {
        if (taaSet != null) {
            for (TargetAreaAssignment taa : taaSet) {
                List<ModuleAssignment> masList = taa.getModuleAssignmentList();
                if (masList != null) {
                    for (ModuleAssignment mas : masList) {
                        Set<Variable> variables;
                        if (mas.getDataModule() == null || (variables = ModuleUtil.getAllVariables(mas.getDataModule())) == null) continue;
                        for (Variable var : variables) {
                            variablesMap.put(var.getId(), var);
                        }
                    }
                }
                if (taa.getContainerLayoutAssignmentList() == null) continue;
                for (ContainerLayoutAssignment cla : taa.getContainerLayoutAssignmentList()) {
                    ModuleUtil.populateAllVariablesInTAAs(cla.getTargetAreaAssignments(), variablesMap);
                }
            }
        }
    }

    public static boolean addDefaultVariableAssignment(Set<VariableAssignment> varAssgnmnts, Variable v, boolean autoCorrected) {
        VariableAssignment existingVA = null;
        for (VariableAssignment varAssignment : varAssgnmnts) {
            if (varAssignment.getVariable() != null && varAssignment.getVariable().getId() != null && varAssignment.getVariable().getId().equals(v.getId())) {
                return false;
            }
            if (varAssignment.getVariable() != null && varAssignment.getVariable().getName() != null && varAssignment.getVariable().getName().equals(v.getName())) {
                existingVA = varAssignment;
                continue;
            }
            if (varAssignment.getVariableName() == null || !varAssignment.getVariableName().equals(v.getName())) continue;
            existingVA = varAssignment;
        }
        VariableAssignment va = new VariableAssignment();
        va.setVariable(v);
        va.setEditable(true);
        va.setAutoCorrected(autoCorrected);
        if (existingVA != null) {
            va.setSource(existingVA.getSource());
            va.setSourceReference(existingVA.getSourceReference());
            va.setOptional(existingVA.isOptional());
            va.setEditable(existingVA.isEditable());
            va.setMultiLine(existingVA.isMultiLine());
            va.setDescription(existingVA.getDescription());
            va.setCaption(existingVA.getCaption());
            va.setToolTip(existingVA.getToolTip());
            va.setEquivalent(existingVA.isEquivalent());
            va.setVariableName(existingVA.getVariableName());
        } else {
            if (Variable.VariableType.PLACEHOLDER.equals((Object)v.getType())) {
                if (v.getProtect().booleanValue()) {
                    va.setSource(VariableAssignment.Source.CONST);
                    va.setSourceReference("");
                } else {
                    va.setSource(VariableAssignment.Source.USER);
                    va.setVariableName(v.getName());
                }
            } else if (Variable.VariableType.DDE.equals((Object)v.getType()) || Variable.VariableType.SCHEMA.equals((Object)v.getType())) {
                va.setSource(VariableAssignment.Source.DDE);
                va.setEquivalent(true);
                int dotIndex = v.getName().indexOf(".");
                String dde = null;
                if (dotIndex == -1) {
                    int ddeSeparatorIndex = v.getName().indexOf("_", 3);
                    dde = v.getName().substring(ddeSeparatorIndex + 1);
                } else {
                    dde = v.getName().substring(dotIndex + 1);
                }
                va.setVariableName(v.getName());
                va.setSourceReference(dde);
            }
            if (v.getProtect().booleanValue()) {
                va.setOptional(true);
                va.setEditable(false);
            } else {
                va.setOptional(false);
                va.setEditable(true);
            }
        }
        if (autoCorrected) {
            logger.info("Autocorrection:: Adding default assignment for VID:" + v.getId());
        }
        varAssgnmnts.add(va);
        return true;
    }

    private static VariableInfo getVariableInfo(String assetId) {
        String[] pathElements = assetId.split("/");
        VariableInfo cInfo = new VariableInfo();
        if (pathElements != null && pathElements.length > 8) {
            String pathElement = pathElements[4];
            String dataModuleName = null;
            if (pathElement.equals("modules")) {
                dataModuleName = pathElements[pathElements.length - 3];
                cInfo.setModuleName(dataModuleName);
                String variableName = pathElements[pathElements.length - 1];
                int idIdx = variableName.lastIndexOf("_");
                if (idIdx > 0 && idIdx + 1 < variableName.length()) {
                    variableName = variableName.substring(0, idIdx);
                }
                cInfo.setVariableName(variableName);
            }
        }
        return cInfo;
    }

    public static class VariableInfo {
        public String moduleName;
        public String variableName;

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public void setVariableName(String variableName) {
            this.variableName = variableName;
        }
    }

    public static class UniqueVariable {
        private String varName;
        private String moduleName;
        private String varId;

        public UniqueVariable(Variable var) {
            this.setVarName(var.getName());
            this.setModuleName(var.getDataModuleName());
            this.varId = var.getId();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UniqueVariable)) {
                return false;
            }
            UniqueVariable varWrapper = (UniqueVariable)obj;
            if (this.varId != null && this.varId.equals(varWrapper.varId)) {
                return true;
            }
            return this.getVarName() != null && this.getVarName().equals(varWrapper.getVarName()) && this.getModuleName() != null && this.getModuleName().equals(varWrapper.getModuleName());
        }

        public int hashCode() {
            int multiplier = 23;
            int code = 133;
            String varName = this.getVarName();
            String moduleName = this.getModuleName();
            if ((varName == null || moduleName == null) && this.getVarId() != null) {
                VariableInfo cInfo = ModuleUtil.getVariableInfo(this.getVarId());
                varName = cInfo.getVariableName();
                moduleName = cInfo.getModuleName();
            }
            if (varName != null) {
                code = 23 * code + varName.hashCode();
            }
            if (moduleName != null) {
                code = 23 * code + moduleName.hashCode();
            }
            return code;
        }

        public String getVarId() {
            return this.varId;
        }

        public void setVarId(String id) {
            this.varId = id;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }

        public String getVarName() {
            return this.varName;
        }
    }
}

