/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import com.adobe.forms.foundation.wsdl.WSDLInvokerParams;
import com.adobe.forms.foundation.wsdl.X509TokenSecurityProfileSettings;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509TokenSecurityProfileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(X509TokenSecurityProfileHandler.class);
    private static final String WSSE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSU_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final String XML_DSIG_URI = "http://www.w3.org/2000/09/xmldsig#";
    private static final String WSU_NS = "xmlns:wsu";
    private static final String ATTRIBUTE_NAME_VALUE_TYPE = "ValueType";
    private static final String ATTRIBUTE_NAME_ENCODING_TYPE = "EncodingType";
    private static final String ATTRIBUTE_VALUE_BASE64_BINARY_ENCODING_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static final String ATTRIBUTE_VALUE_VALUE_TYPE_X509V3 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private static final String ATTRIBUTE_NAME_ID = "Id";
    private static final String ATTRIBUTE_NAME_URI = "URI";
    private static final String ELEMENT_NAME_BINARY_SECURITY_TOKEN = "BinarySecurityToken";
    private static final String ELEMENT_NAME_SECURITY = "Security";
    private static final String ELEMENT_NAME_TIMESTAMP = "Timestamp";
    private static final String ELEMENT_NAME_SECURITY_TOKEN_REFERENCE = "SecurityTokenReference";
    private static final String ELEMENT_NAME_REFERENCE = "Reference";
    private static final String ELEMENT_PREFIX_WSU = "wsu";
    private static final String ELEMENT_PREFIX_WSSE = "wsse";
    private static final String ELEMENT_PREFIX_DS = "ds";
    private static final String ELEMENT_PREFIX_EC = "ec";
    private static final String ATTRIBUTE_ID_PREFIX_TIMESTAMP = "Ts";
    private static final String ATTRIBUTE_ID_PREFIX_BODY = "Body";
    private static final String ATTRIBUTE_ID_PREFIX_X509_TOKEN = "X509Token";
    private static final String ATTRIBUTE_ID_PREFIX_REFERENCE = "Ref";
    private static final String ATTRIBUTE_ID_PREFIX_KEYINFO = "Ki";
    private static final String ATTRIBUTE_ID_PREFIX_SIGNATURE = "Si";
    private static final String ATTRIBUTE_ID_PREFIX_SIGNATUREVALUE = "Sv";

    public static boolean isX509TokenSecurityProfileEnabled(WSDLInvokerParams wsdlInvokerParams) {
        return wsdlInvokerParams != null && wsdlInvokerParams.getX509TokenSecurityProfileSettings() != null && wsdlInvokerParams.getX509TokenSecurityProfileSettings().getCertificate() != null && wsdlInvokerParams.getX509TokenSecurityProfileSettings().getPrivateKey() != null;
    }

    private static void validateX509SecuritySettings(WSDLInvokerParams wsdlInvokerParams, SOAPMessage soapMessage) {
        if (X509TokenSecurityProfileHandler.isX509TokenSecurityProfileEnabled(wsdlInvokerParams)) {
            X509TokenSecurityProfileSettings securitySettings = wsdlInvokerParams.getX509TokenSecurityProfileSettings();
            if (securitySettings.getCertificate() == null || securitySettings.getPrivateKey() == null) {
                throw new IllegalArgumentException("Unable to get Certificate/Private key");
            }
            if (securitySettings.isSignSecurityTimestampHeader()) {
                try {
                    SOAPElement securityTTLHeaderElement = X509TokenSecurityProfileHandler.getSecurityTTLHeaderElement(soapMessage);
                    if (securityTTLHeaderElement == null) {
                        throw new IllegalArgumentException("Unable to get time-to-live security header");
                    }
                }
                catch (SOAPException e) {
                    throw new IllegalStateException("Unable to get security header");
                }
            }
            if ((securitySettings.isSignBody() || securitySettings.isSignSecurityTimestampHeader()) && (StringUtils.isBlank((CharSequence)securitySettings.getCanonicalizationAlgorithm()) || StringUtils.isBlank((CharSequence)securitySettings.getDigestAlgorithm()) || StringUtils.isBlank((CharSequence)securitySettings.getSignatureAlgorithm()) || StringUtils.isBlank((CharSequence)securitySettings.getTransformAlgorithm()))) {
                throw new IllegalArgumentException("Unable to get required algorithms for sigining");
            }
        } else {
            throw new IllegalArgumentException("Unable to get X509TokenSecurity profile processing inputs");
        }
    }

    public static void handleX509TokenProfileSecurity(WSDLInvokerParams wsdlInvokerParams, SOAPMessage soapMessage) throws SOAPException, CertificateEncodingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, XPathExpressionException {
        long startTs = System.nanoTime();
        X509TokenSecurityProfileHandler.validateX509SecuritySettings(wsdlInvokerParams, soapMessage);
        X509TokenSecurityProfileSettings securitySettings = wsdlInvokerParams.getX509TokenSecurityProfileSettings();
        X509TokenSecurityProfileHandler.addBinarySecurityToken(securitySettings, soapMessage);
        if (securitySettings.isSignBody() || securitySettings.isSignSecurityTimestampHeader()) {
            X509TokenSecurityProfileHandler.signMessage(securitySettings, soapMessage);
        }
        soapMessage.saveChanges();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("handleX509TokenProfileSecurity  time: {}ns", (Object)(System.nanoTime() - startTs));
        }
    }

    private static void addBinarySecurityToken(X509TokenSecurityProfileSettings x509TokenProfileSettings, SOAPMessage soapMessage) throws SOAPException, CertificateEncodingException {
        SOAPElement securityHeaderElement = X509TokenSecurityProfileHandler.getSecurityHeaderElement(soapMessage);
        if (securityHeaderElement == null) {
            X509TokenSecurityProfileHandler.createSecurityHeaderElement(soapMessage);
            securityHeaderElement = X509TokenSecurityProfileHandler.getSecurityHeaderElement(soapMessage);
        }
        X509TokenSecurityProfileHandler.createBinarySecurityTokenHeader(securityHeaderElement, x509TokenProfileSettings);
    }

    private static void signMessage(X509TokenSecurityProfileSettings securitySettings, SOAPMessage soapMessage) throws SOAPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, XPathExpressionException {
        X509TokenSecurityProfileHandler.assignWSUIds(securitySettings, soapMessage);
        X509TokenSecurityProfileHandler.createDetachedSignature(securitySettings, soapMessage);
    }

    private static CanonicalizationMethod getCanonicalizationMethod(X509TokenSecurityProfileSettings securitySettings, SOAPMessage soapMessage, XMLSignatureFactory xmlSignatureFactory) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, SOAPException {
        ExcC14NParameterSpec canonicalizationParameterSpec = null;
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(securitySettings.getCanonicalizationAlgorithm()) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(securitySettings.getCanonicalizationAlgorithm())) {
            ArrayList<String> canonicalizationPrefixList = new ArrayList<String>(3);
            canonicalizationPrefixList.add(soapMessage.getSOAPHeader().getPrefix());
            canonicalizationPrefixList.add(ELEMENT_PREFIX_WSU);
            canonicalizationPrefixList.add(ELEMENT_PREFIX_EC);
            canonicalizationParameterSpec = new ExcC14NParameterSpec(canonicalizationPrefixList);
        }
        return xmlSignatureFactory.newCanonicalizationMethod(securitySettings.getCanonicalizationAlgorithm(), canonicalizationParameterSpec);
    }

    private static List<Transform> getTransformsList(X509TokenSecurityProfileSettings securitySettings, SOAPMessage soapMessage, XMLSignatureFactory xmlSignatureFactory) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, SOAPException {
        ExcC14NParameterSpec transformC14NParameterSpec = null;
        ArrayList<Transform> transformList = new ArrayList<Transform>(1);
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(securitySettings.getTransformAlgorithm())) {
            ArrayList<String> transformPrefixList = new ArrayList<String>(2);
            transformPrefixList.add(soapMessage.getSOAPHeader().getPrefix());
            transformPrefixList.add(ELEMENT_PREFIX_EC);
            transformC14NParameterSpec = new ExcC14NParameterSpec(transformPrefixList);
        }
        Transform envTransform = xmlSignatureFactory.newTransform(securitySettings.getTransformAlgorithm(), transformC14NParameterSpec);
        transformList.add(envTransform);
        return transformList;
    }

    private static XMLSignatureFactory getXMLSignatureFactory() {
        XMLSignatureFactory xmlSignatureFactory = null;
        try {
            xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
        catch (Exception e) {
            xmlSignatureFactory = XMLSignatureFactory.getInstance();
        }
        return xmlSignatureFactory;
    }

    private static void createDetachedSignature(X509TokenSecurityProfileSettings securitySettings, SOAPMessage soapMessage) throws SOAPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, XPathExpressionException {
        Reference partReference;
        XMLSignatureFactory xmlSignatureFactory = X509TokenSecurityProfileHandler.getXMLSignatureFactory();
        SOAPElement securityHeaderElement = X509TokenSecurityProfileHandler.getSecurityHeaderElement(soapMessage);
        SOAPElement securityTokenElement = X509TokenSecurityProfileHandler.getBinarySecurityTokenHeader(securityHeaderElement);
        SOAPElement securityTTLHeaderElement = null;
        SOAPBody soapBody = soapMessage.getSOAPBody();
        String securityTokenId = X509TokenSecurityProfileHandler.getWSUId(securityTokenElement);
        DigestMethod digestMethod = xmlSignatureFactory.newDigestMethod(securitySettings.getDigestAlgorithm(), null);
        List<Transform> transformList = X509TokenSecurityProfileHandler.getTransformsList(securitySettings, soapMessage, xmlSignatureFactory);
        CanonicalizationMethod canonicalizationMethod = X509TokenSecurityProfileHandler.getCanonicalizationMethod(securitySettings, soapMessage, xmlSignatureFactory);
        ArrayList<Reference> signablePartRefList = new ArrayList<Reference>();
        if (securitySettings.isSignBody()) {
            String bodyId = X509TokenSecurityProfileHandler.getWSUId((SOAPElement)soapBody);
            partReference = xmlSignatureFactory.newReference("#" + bodyId, digestMethod, transformList, null, X509TokenSecurityProfileHandler.generateId(ATTRIBUTE_ID_PREFIX_REFERENCE));
            signablePartRefList.add(partReference);
        }
        if (securitySettings.isSignSecurityTimestampHeader()) {
            securityTTLHeaderElement = X509TokenSecurityProfileHandler.getSecurityTTLHeaderElement(securityHeaderElement);
            String ttlHeaderId = X509TokenSecurityProfileHandler.getWSUId(securityTTLHeaderElement);
            partReference = xmlSignatureFactory.newReference("#" + ttlHeaderId, digestMethod, transformList, null, X509TokenSecurityProfileHandler.generateId(ATTRIBUTE_ID_PREFIX_REFERENCE));
            signablePartRefList.add(partReference);
        }
        SignatureMethod signatureMethod = xmlSignatureFactory.newSignatureMethod(securitySettings.getSignatureAlgorithm(), null);
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, signablePartRefList);
        DOMSignContext signContext = new DOMSignContext(securitySettings.getPrivateKey(), (Node)securityHeaderElement);
        signContext.setDefaultNamespacePrefix(ELEMENT_PREFIX_DS);
        signContext.putNamespacePrefix(XML_DSIG_URI, ELEMENT_PREFIX_DS);
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(securitySettings.getCanonicalizationAlgorithm()) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(securitySettings.getCanonicalizationAlgorithm()) || "http://www.w3.org/2001/10/xml-exc-c14n#".equals(securitySettings.getTransformAlgorithm())) {
            signContext.putNamespacePrefix(securitySettings.getCanonicalizationAlgorithm(), ELEMENT_PREFIX_EC);
        }
        if (securitySettings.isSignBody()) {
            signContext.setIdAttributeNS((Element)soapBody, WSU_URI, ATTRIBUTE_NAME_ID);
        }
        if (securitySettings.isSignSecurityTimestampHeader()) {
            signContext.setIdAttributeNS((Element)securityTTLHeaderElement, WSU_URI, ATTRIBUTE_NAME_ID);
        }
        SOAPElement securityTokenReferenceElement = X509TokenSecurityProfileHandler.createSecurityTokenReferenceElement(securityHeaderElement, securityTokenId);
        KeyInfoFactory keyFactory = KeyInfoFactory.getInstance();
        DOMStructure domKeyInfo = new DOMStructure((Node)securityTokenReferenceElement);
        KeyInfo keyInfo = keyFactory.newKeyInfo(Collections.singletonList(domKeyInfo), X509TokenSecurityProfileHandler.generateId(ATTRIBUTE_ID_PREFIX_KEYINFO));
        XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo, null, X509TokenSecurityProfileHandler.generateId(ATTRIBUTE_ID_PREFIX_SIGNATURE), X509TokenSecurityProfileHandler.generateId(ATTRIBUTE_ID_PREFIX_SIGNATUREVALUE));
        signContext.setBaseURI("");
        signature.sign(signContext);
    }

    private static SOAPElement getSecurityHeaderElement(SOAPMessage soapMessage) throws SOAPException {
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        QName securityElementQName = new QName(WSSE_URI, ELEMENT_NAME_SECURITY);
        if (soapHeader != null) {
            return X509TokenSecurityProfileHandler.getChildElement((SOAPElement)soapHeader, securityElementQName);
        }
        return null;
    }

    private static SOAPElement getSecurityTTLHeaderElement(SOAPMessage soapMessage) throws SOAPException {
        SOAPElement securityHeaderElement = X509TokenSecurityProfileHandler.getSecurityHeaderElement(soapMessage);
        if (securityHeaderElement != null) {
            return X509TokenSecurityProfileHandler.getSecurityTTLHeaderElement(securityHeaderElement);
        }
        return null;
    }

    private static SOAPElement getSecurityTTLHeaderElement(SOAPElement securityHeaderElement) {
        SOAPElement securityTTLHeaderElement = X509TokenSecurityProfileHandler.getChildElement(securityHeaderElement, new QName(WSU_URI, ELEMENT_NAME_TIMESTAMP));
        return securityTTLHeaderElement;
    }

    private static SOAPElement createSecurityHeaderElement(SOAPMessage soapMessage) throws SOAPException {
        SOAPFactory soapFactory = SOAPFactory.newInstance();
        SOAPElement securityHeaderElement = soapFactory.createElement(ELEMENT_NAME_SECURITY, ELEMENT_PREFIX_WSSE, WSSE_URI);
        securityHeaderElement.addAttribute(new QName(WSU_NS), WSU_URI);
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        if (soapHeader == null) {
            soapHeader = soapMessage.getSOAPPart().getEnvelope().addHeader();
        }
        soapHeader.addChildElement(securityHeaderElement);
        return securityHeaderElement;
    }

    private static String createBinarySecurityTokenHeader(SOAPElement securityHeaderElement, X509TokenSecurityProfileSettings x509TokenProfileSettings) throws SOAPException, CertificateEncodingException {
        SOAPElement binarySecurityTokenElement = securityHeaderElement.addChildElement(ELEMENT_NAME_BINARY_SECURITY_TOKEN, ELEMENT_PREFIX_WSSE, WSSE_URI);
        binarySecurityTokenElement.addAttribute(new QName(ATTRIBUTE_NAME_ENCODING_TYPE), ATTRIBUTE_VALUE_BASE64_BINARY_ENCODING_TYPE);
        binarySecurityTokenElement.addAttribute(new QName(ATTRIBUTE_NAME_VALUE_TYPE), ATTRIBUTE_VALUE_VALUE_TYPE_X509V3);
        String binarySecurityTokenElementId = X509TokenSecurityProfileHandler.addId(ATTRIBUTE_ID_PREFIX_X509_TOKEN, binarySecurityTokenElement);
        binarySecurityTokenElement.addTextNode(Base64.getEncoder().encodeToString(x509TokenProfileSettings.getCertificate().getEncoded()));
        return binarySecurityTokenElementId;
    }

    private static SOAPElement getBinarySecurityTokenHeader(SOAPElement securityHeaderElement) {
        return X509TokenSecurityProfileHandler.getChildElement(securityHeaderElement, new QName(WSSE_URI, ELEMENT_NAME_BINARY_SECURITY_TOKEN));
    }

    private static String addIdToBody(SOAPMessage soapMessage) throws SOAPException {
        String elementId = X509TokenSecurityProfileHandler.generateId(ATTRIBUTE_ID_PREFIX_BODY);
        soapMessage.getSOAPBody().addAttribute(soapMessage.getSOAPPart().getEnvelope().createName(ATTRIBUTE_NAME_ID, ELEMENT_PREFIX_WSU, WSU_URI), elementId);
        return elementId;
    }

    private static String generateId(String prefix) {
        return prefix + "_" + UUID.randomUUID().toString();
    }

    private static String addId(String prefix, SOAPElement element) throws SOAPException {
        String elementId = X509TokenSecurityProfileHandler.generateId(prefix);
        element.addAttribute(new QName(WSU_URI, ATTRIBUTE_NAME_ID, ELEMENT_PREFIX_WSU), elementId);
        return elementId;
    }

    private static SOAPElement getChildElement(SOAPElement parentElement, QName elementQName) {
        Iterator elementIterator = parentElement.getChildElements(elementQName);
        if (elementIterator != null && elementIterator.hasNext()) {
            return (SOAPElement)elementIterator.next();
        }
        return null;
    }

    private static String getAttributeValue(SOAPElement element, QName attrubuteQName) {
        return element.getAttributeValue(attrubuteQName);
    }

    private static String getWSUId(SOAPElement element) {
        return X509TokenSecurityProfileHandler.getAttributeValue(element, new QName(WSU_URI, ATTRIBUTE_NAME_ID));
    }

    private static SOAPElement createSecurityTokenReferenceElement(SOAPElement securityElement, String securityTokenId) throws SOAPException {
        SOAPElement securityTokenReference = securityElement.addChildElement(ELEMENT_NAME_SECURITY_TOKEN_REFERENCE, ELEMENT_PREFIX_WSSE);
        SOAPElement reference = securityTokenReference.addChildElement(ELEMENT_NAME_REFERENCE, ELEMENT_PREFIX_WSSE);
        reference.setAttribute(ATTRIBUTE_NAME_URI, "#" + securityTokenId);
        reference.setAttribute(ATTRIBUTE_NAME_VALUE_TYPE, ATTRIBUTE_VALUE_VALUE_TYPE_X509V3);
        return securityTokenReference;
    }

    private static void assignWSUIds(X509TokenSecurityProfileSettings x509TokenSecurityProfileSettings, SOAPMessage soapMessage) throws SOAPException {
        SOAPElement timestampElement;
        if (x509TokenSecurityProfileSettings.isSignBody() && StringUtils.isBlank((CharSequence)X509TokenSecurityProfileHandler.getWSUId((SOAPElement)soapMessage.getSOAPBody()))) {
            X509TokenSecurityProfileHandler.addIdToBody(soapMessage);
        }
        if (x509TokenSecurityProfileSettings.isSignSecurityTimestampHeader() && StringUtils.isBlank((CharSequence)X509TokenSecurityProfileHandler.getWSUId(timestampElement = X509TokenSecurityProfileHandler.getSecurityTTLHeaderElement(soapMessage)))) {
            X509TokenSecurityProfileHandler.addId(ATTRIBUTE_ID_PREFIX_TIMESTAMP, timestampElement);
        }
    }
}

