/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import com.adobe.forms.foundation.wsdl.WSDLInvokerParams;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.json.JSONException;

public class WSDLUtils {
    public static boolean enableDebugging = false;

    public static String getPortFromBinding(Definition definition, String binding) throws Exception {
        String outPort = null;
        try {
            Map services = definition.getServices();
            Iterator serviceIterator = services.values().iterator();
            while (serviceIterator.hasNext() && outPort == null) {
                Service service = (Service)serviceIterator.next();
                Map ports = service.getPorts();
                Iterator portIterator = ports.values().iterator();
                while (portIterator.hasNext() && outPort == null) {
                    Port port = (Port)portIterator.next();
                    if (0 != port.getBinding().toString().compareTo(binding)) continue;
                    outPort = port.getName();
                }
            }
            if (outPort == null) {
                throw new JSONException("getPortFromBinding: invalid values");
            }
        }
        catch (JSONException e) {
            throw new Exception("getPortFromBinding: JSONException", e);
        }
        return outPort;
    }

    public static String getServiceEndPointFromPort(Definition definition, String requiredPort) throws Exception {
        String serviceLocationUri = null;
        try {
            Map services = definition.getServices();
            Iterator serviceIterator = services.values().iterator();
            while (serviceIterator.hasNext() && serviceLocationUri == null) {
                Service service = (Service)serviceIterator.next();
                Map ports = service.getPorts();
                Iterator portIterator = ports.values().iterator();
                while (portIterator.hasNext() && serviceLocationUri == null) {
                    Port port = (Port)portIterator.next();
                    if (0 != port.getName().compareTo(requiredPort)) continue;
                    List list = port.getExtensibilityElements();
                    int countElements = list.size();
                    for (int index = 0; index < countElements; ++index) {
                        ExtensibilityElement element = (ExtensibilityElement)list.get(index);
                        if (!(element instanceof SOAPAddressImpl)) continue;
                        SOAPAddressImpl address = (SOAPAddressImpl)element;
                        serviceLocationUri = address.getLocationURI();
                    }
                }
            }
            if (serviceLocationUri == null) {
                throw new JSONException("getPortFromBinding: invalid values");
            }
        }
        catch (JSONException e) {
            throw new Exception("getPortFromBinding: JSONException", e);
        }
        return serviceLocationUri;
    }

    public static String getBindingFromPort(Definition definition, String portName) throws Exception {
        String outBinding = null;
        try {
            Map services = definition.getServices();
            Iterator serviceIterator = services.values().iterator();
            while (serviceIterator.hasNext() && outBinding == null) {
                Service service = (Service)serviceIterator.next();
                Map ports = service.getPorts();
                Iterator portIterator = ports.values().iterator();
                while (portIterator.hasNext() && outBinding == null) {
                    Port port = (Port)portIterator.next();
                    if (0 != port.getName().compareTo(portName)) continue;
                    outBinding = port.getBinding().toString();
                }
            }
            if (outBinding == null) {
                throw new JSONException("getBindingFromPort: invalid values");
            }
        }
        catch (JSONException e) {
            throw new Exception("getBindingFromPort: JSONException", e);
        }
        return outBinding;
    }

    public static String getSoapActionURI(BindingOperation op) {
        String soapAction = null;
        List list = op.getExtensibilityElements();
        int countElements = list.size();
        for (int index = 0; index < countElements; ++index) {
            ExtensibilityElement element = (ExtensibilityElement)list.get(index);
            if (!(element instanceof SOAPOperationImpl)) continue;
            SOAPOperation soapOp = (SOAPOperation)element;
            soapAction = soapOp.getSoapActionURI();
        }
        return soapAction;
    }

    public static void getSoapActionURI(Definition definition, WSDLInvokerParams params, String operationName) throws Exception {
        String soapActionURI = null;
        String bindingRequired = WSDLUtils.getBindingFromPort(definition, params.getPort());
        Map allBindings = definition.getAllBindings();
        for (Binding binding : allBindings.values()) {
            if (binding.toString().compareTo(bindingRequired) != 0) continue;
            List list = binding.getExtensibilityElements();
            int length = list.size();
            for (int index = 0; index < length && soapActionURI == null; ++index) {
                if (!(list.get(index) instanceof SOAPBindingImpl)) continue;
                int soapOperationCount = binding.getBindingOperations().size();
                for (int soapOpIndex = 0; soapOpIndex < soapOperationCount && soapActionURI == null; ++soapOpIndex) {
                    BindingOperation bindingOp = (BindingOperation)binding.getBindingOperations().get(soapOpIndex);
                    Operation op = bindingOp.getOperation();
                    if (op.getName().compareTo(operationName) != 0) continue;
                    soapActionURI = WSDLUtils.getSoapActionURI(bindingOp);
                    params.setOpSoapUri(soapActionURI);
                    WSDLUtils.getOpInputRoot(params, op);
                }
            }
        }
    }

    public static void getOpInputRoot(WSDLInvokerParams params, Operation op) throws Exception {
        String opInputRoot = null;
        Input input = op.getInput();
        if (input != null) {
            Map msgParts = input.getMessage().getParts();
            for (Part part : msgParts.values()) {
                opInputRoot = part.getElementName().getLocalPart();
            }
            params.setOpInputRoot(opInputRoot);
        }
    }

    @Deprecated
    public static String getOperationNamespace(Definition definition, XSSchema schemaObj, String portName, String operationName) throws Exception {
        return WSDLUtils.getOperationNamespace(definition, null, schemaObj, portName, operationName);
    }

    public static String getOperationNamespace(Definition definition, XSSchemaSet schemaSet, String portName, String operationName) throws Exception {
        return WSDLUtils.getOperationNamespace(definition, schemaSet, null, portName, operationName);
    }

    private static String getOperationNamespace(Definition definition, XSSchemaSet schemaSet, XSSchema schemaObject, String portName, String operationName) throws Exception {
        Map allBindings = definition.getAllBindings();
        for (Binding binding : allBindings.values()) {
            String port = WSDLUtils.getPortFromBinding(definition, binding.toString());
            if (port.compareTo(portName) != 0) continue;
            List list = binding.getExtensibilityElements();
            int length = list.size();
            for (int index = 0; index < length; ++index) {
                if (!(list.get(index) instanceof SOAPBindingImpl)) continue;
                int soapOperationCount = binding.getBindingOperations().size();
                for (int soapOpIndex = 0; soapOpIndex < soapOperationCount; ++soapOpIndex) {
                    Input input;
                    Message message;
                    Map msgParts;
                    Iterator partIterator;
                    BindingOperation bindingOp = (BindingOperation)binding.getBindingOperations().get(soapOpIndex);
                    Operation op = bindingOp.getOperation();
                    if (op.getName().compareTo(operationName) != 0 || !(partIterator = (msgParts = (message = (input = op.getInput()).getMessage()).getParts()).values().iterator()).hasNext()) continue;
                    Part part = (Part)partIterator.next();
                    QName elementName = part.getElementName();
                    XSElementDecl element = schemaSet != null ? schemaSet.getElementDecl(elementName.getNamespaceURI(), elementName.getLocalPart()) : schemaObject.getElementDecl(elementName.getLocalPart());
                    return element.getTargetNamespace();
                }
            }
        }
        return null;
    }

    public static String getPortIfUnique(Definition definition, String operationName) throws Exception {
        Object port = null;
        Map allBindings = definition.getAllBindings();
        int instancesFound = 0;
        String bindingName = null;
        Iterator bindingIterator = allBindings.values().iterator();
        while (bindingIterator.hasNext() && instancesFound < 2) {
            Binding binding = (Binding)bindingIterator.next();
            List list = binding.getExtensibilityElements();
            int length = list.size();
            for (int index = 0; index < length && instancesFound < 2; ++index) {
                if (!(list.get(index) instanceof SOAPBindingImpl)) continue;
                int soapOperationCount = binding.getBindingOperations().size();
                for (int soapOpIndex = 0; soapOpIndex < soapOperationCount && instancesFound < 2; ++soapOpIndex) {
                    BindingOperation bindingOp = (BindingOperation)binding.getBindingOperations().get(soapOpIndex);
                    Operation op = bindingOp.getOperation();
                    if (op.getName().compareTo(operationName) != 0) continue;
                    bindingName = binding.toString();
                    ++instancesFound;
                }
            }
        }
        if (instancesFound == 1) {
            return WSDLUtils.getPortFromBinding(definition, bindingName);
        }
        return null;
    }

    public static String generateUniqueNSPrefix() {
        StringBuilder prefixBuilder = new StringBuilder("ns");
        Random objGenerator = new Random();
        prefixBuilder.append(objGenerator.nextInt(10000));
        return prefixBuilder.toString();
    }
}

