/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import com.adobe.forms.foundation.wsdl.AuthenticatedResourceLocator;
import com.adobe.forms.foundation.wsdl.WSDLInvokerParams;
import com.adobe.granite.keystore.KeyStoreService;
import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class CustomWSDLLocator
implements WSDLLocator {
    private static Logger logger = LoggerFactory.getLogger(CustomWSDLLocator.class);
    private String baseUri;
    private String latestImportUrl;
    private AuthenticatedResourceLocator resourceLocator;
    private Map<URL, InputSource> inputSourceMap = new HashMap<URL, InputSource>();
    private KeyStoreService keyStoreService = null;
    private ResourceResolverFactory resourceResolverFactory = null;
    private WSDLInvokerParams wsdlInvokerParams = null;

    public CustomWSDLLocator(String baseUri, AuthenticatedResourceLocator resourceLocator) {
        this.baseUri = baseUri;
        this.resourceLocator = resourceLocator;
    }

    public CustomWSDLLocator(String baseUri, AuthenticatedResourceLocator resourceLocator, KeyStoreService keyStoreService, ResourceResolverFactory resourceResolverFactory, WSDLInvokerParams wsdlInvokerParams) {
        this.baseUri = baseUri;
        this.resourceLocator = resourceLocator;
        this.keyStoreService = keyStoreService;
        this.resourceResolverFactory = resourceResolverFactory;
        this.wsdlInvokerParams = wsdlInvokerParams;
    }

    public InputSource getBaseInputSource() {
        InputSource inputSource = null;
        try {
            URL url = StringUtils.getURL(null, (String)this.baseUri);
            inputSource = this.getInputSource(url);
        }
        catch (MalformedURLException e) {
            logger.error("Failed to create url for baseUri - " + this.baseUri + " : " + e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputSource;
    }

    private InputSource getInputSource(URL url) throws Exception {
        InputSource inputSource = null;
        if (this.inputSourceMap.containsKey(url)) {
            inputSource = this.inputSourceMap.get(url);
        } else {
            try {
                inputSource = null != this.keyStoreService && null != this.resourceResolverFactory ? this.resourceLocator.getResource(url, this.keyStoreService, this.resourceResolverFactory, this.wsdlInvokerParams) : this.resourceLocator.getResource(url);
                this.inputSourceMap.put(url, inputSource);
            }
            catch (Exception e) {
                logger.error("Failed to get " + url + ": " + e.getStackTrace());
                throw e;
            }
        }
        return inputSource;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        InputSource inputSource = null;
        URL contextURL = null;
        try {
            contextURL = parentLocation != null ? StringUtils.getURL(null, (String)parentLocation) : null;
            URL url = contextURL != null ? StringUtils.getURL((URL)contextURL, (String)importLocation) : StringUtils.getURL(null, (String)importLocation);
            inputSource = this.getInputSource(url);
            this.latestImportUrl = url.toExternalForm();
        }
        catch (MalformedURLException e) {
            logger.error("Failed to created URL for parentLocation - " + parentLocation + " and importLocation - " + importLocation + " : " + e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputSource;
    }

    public String getBaseURI() {
        return this.baseUri;
    }

    public String getLatestImportURI() {
        return this.latestImportUrl;
    }

    public void close() {
        for (URL url : this.inputSourceMap.keySet()) {
            InputSource inputSource = this.inputSourceMap.get(url);
            try {
                inputSource.getByteStream().close();
            }
            catch (IOException e) {
                logger.error("Failed to close the input stream for " + url + " : " + e.getMessage());
            }
        }
    }
}

