/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pdf.inputs;

import com.adobe.fd.signatures.pdf.inputs.DSSPreferences;
import com.adobe.fd.signatures.pdf.inputs.JavascriptPreferences;
import com.adobe.fd.signatures.pdf.inputs.UnlockOptions;
import com.adobe.fd.signatures.pki.client.types.prefs.PKIPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.PKIPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;
import com.adobe.internal.pdftoolkit.services.javascript.JSExecuteOptions;

public class DSSPreferencesImpl
extends PreferencesMap
implements DSSPreferences {
    private static final long serialVersionUID = -8550268318654946935L;
    private static final String PKI_STR = "pki";
    private static final String JAVASCRIPT_STR = "javascript";
    private static final String VERIFY_CLOCK_SKEW_STR = "maxClockSkew";
    private static final long VERIFY_CLOCK_SKEW_DEFAULT = 3900L;
    private static final String MAX_REV_INFO_ARCHIVE_SIZE_STR = "maxRevInfoArchiveSize";
    private static final int MAX_REV_INFO_ARCHIVE_SIZE_DEFAULT = 102400;
    private static final String USE_ARCHIVED_REVOCATION_INFO_STR = "useArchivedRevocationInfo";
    private static final boolean USE_ARCHIVED_REVOCATION_INFO_DEFAULT = true;
    private static final String ENABLE_DOCUMENT_JAVASCRIPTS_STR = "enableDocumentJavascripts";
    private static final boolean ENABLE_DOCUMENT_JAVASCRIPTS_DEFAULT = true;
    private static final String ENFORCE_REVOCATION_EMBEDDING_STR = "enforceRevocationEmbedding";
    private static final boolean ENFORCE_REVOCATION_EMBEDDING_DEFAULT = false;
    private static final String EMBEDDED_REVOCATION_STR = "embeddedRevocation";
    private static final boolean EMBED_REVOCATION_DEFAULT = true;
    private static final String USE_VRI_STR = "useVRI";
    private static final boolean USE_VRI_DEFAULT = true;
    private static final String SUPPORT_PRE_RELEASE_SIGNATURES_STR = "supportPreReleaseSignatures";
    private static final boolean SUPPORT_PRE_RELEASE_SIGNATURES_DEFAULT = false;
    private static final String CREATE_FORM_DOM_STR = "createFormDOM";
    private static final boolean CREATE_FORM_DOM_DEFAULT = true;
    private static final String UNLOCK_OPTIONS = "unlockOptions";

    public DSSPreferencesImpl() {
        this.setPKIPreferences(new PKIPreferencesImpl());
        this.setJSPreferences(new JavascriptPreferences());
        this.setVerificationTimeClockSkew(3900L);
        this.setMaxRevInfoArchiveSize(102400);
        this.setUseArchivedRevocationInfo(true);
        this.setEnableDocumentJavascripts(true);
        this.setEnforceRevocationEmbedding(false);
        this.setUseVRI(true);
        this.setSupportPreReleaseSignatures(false);
        this.setCreateFormDOM(true);
        this.setEmbeddedRevocation(true);
    }

    public DSSPreferencesImpl(DSSPreferences prefs) {
    }

    public static DSSPreferencesImpl getInstance() {
        return new DSSPreferencesImpl();
    }

    public DSSPreferencesImpl getInstance(DSSPreferences dssPrefs) {
        if (dssPrefs == null) {
            return DSSPreferencesImpl.getInstance();
        }
        if (dssPrefs instanceof DSSPreferencesImpl) {
            return (DSSPreferencesImpl)dssPrefs;
        }
        return new DSSPreferencesImpl(dssPrefs);
    }

    @Override
    protected Object getPrefValueFromString(String prefName, String value) {
        if (VERIFY_CLOCK_SKEW_STR.equalsIgnoreCase(prefName)) {
            return new Long(value);
        }
        if (MAX_REV_INFO_ARCHIVE_SIZE_STR.equalsIgnoreCase(prefName)) {
            return new Integer(value);
        }
        if (USE_ARCHIVED_REVOCATION_INFO_STR.equalsIgnoreCase(prefName) || ENABLE_DOCUMENT_JAVASCRIPTS_STR.equalsIgnoreCase(prefName) || ENFORCE_REVOCATION_EMBEDDING_STR.equalsIgnoreCase(prefName) || USE_VRI_STR.equalsIgnoreCase(prefName) || SUPPORT_PRE_RELEASE_SIGNATURES_STR.equalsIgnoreCase(prefName) || CREATE_FORM_DOM_STR.equalsIgnoreCase(prefName) || EMBEDDED_REVOCATION_STR.equalsIgnoreCase(prefName)) {
            return new Boolean(value);
        }
        return null;
    }

    @Override
    public PreferencesMap newInstance() {
        return new DSSPreferencesImpl();
    }

    @Override
    protected PreferencesMap createChild(String myKey) {
        if (myKey.equalsIgnoreCase(PKI_STR)) {
            return new PKIPreferencesImpl();
        }
        if (myKey.equalsIgnoreCase(JAVASCRIPT_STR)) {
            return new JavascriptPreferences();
        }
        return null;
    }

    @Override
    public PKIPreferencesImpl getPKIPreferences() {
        return (PKIPreferencesImpl)this.get(PKI_STR);
    }

    @Override
    public void setPKIPreferences(PKIPreferences prefs) {
        this.put(PKI_STR, (Object)prefs);
    }

    @Override
    public JSExecuteOptions getJSPreferences() {
        JavascriptPreferences jsPrefs = (JavascriptPreferences)this.get(JAVASCRIPT_STR);
        if (jsPrefs == null) {
            return null;
        }
        JSExecuteOptions jsOpts = JSExecuteOptions.newInstance();
        jsOpts.setMemoryThreshhold(jsPrefs.getMemoryThreshhold());
        jsOpts.setScriptTimeOutInterval(jsPrefs.getScriptTimeOutInterval());
        return jsOpts;
    }

    @Override
    public void setJSPreferences(JavascriptPreferences prefs) {
        this.put(JAVASCRIPT_STR, (Object)prefs);
    }

    @Override
    public long getVerificationTimeClockSkew() {
        return (Long)this.get(VERIFY_CLOCK_SKEW_STR);
    }

    @Override
    public void setVerificationTimeClockSkew(long skew) {
        this.put(VERIFY_CLOCK_SKEW_STR, (Object)skew);
    }

    @Override
    public int getMaxRevInfoArchiveSize() {
        return (Integer)this.get(MAX_REV_INFO_ARCHIVE_SIZE_STR);
    }

    @Override
    public void setMaxRevInfoArchiveSize(int maxRevInfoArchiveSize) {
        this.put(MAX_REV_INFO_ARCHIVE_SIZE_STR, (Object)maxRevInfoArchiveSize);
    }

    @Override
    public boolean getUseArchivedRevocationInfo() {
        return (Boolean)this.get(USE_ARCHIVED_REVOCATION_INFO_STR);
    }

    @Override
    public void setUseArchivedRevocationInfo(boolean useArchivedRevocationInfo) {
        this.put(USE_ARCHIVED_REVOCATION_INFO_STR, (Object)useArchivedRevocationInfo);
    }

    @Override
    public boolean getEnableDocumentJavascripts() {
        return (Boolean)this.get(ENABLE_DOCUMENT_JAVASCRIPTS_STR);
    }

    @Override
    public void setEnableDocumentJavascripts(boolean enableDocumentJavascripts) {
        this.put(ENABLE_DOCUMENT_JAVASCRIPTS_STR, (Object)enableDocumentJavascripts);
    }

    @Override
    public boolean getEnforceRevocationEmbedding() {
        return (Boolean)this.get(ENFORCE_REVOCATION_EMBEDDING_STR);
    }

    @Override
    public void setEnforceRevocationEmbedding(boolean enforceRevocationEmbedding) {
        this.put(ENFORCE_REVOCATION_EMBEDDING_STR, (Object)enforceRevocationEmbedding);
    }

    @Override
    public boolean getEmbeddedRevocation() {
        return (Boolean)this.get(EMBEDDED_REVOCATION_STR);
    }

    @Override
    public void setEmbeddedRevocation(boolean embeddedRevocation) {
        this.put(EMBEDDED_REVOCATION_STR, (Object)embeddedRevocation);
    }

    @Override
    public boolean getUseVRI() {
        return (Boolean)this.get(USE_VRI_STR);
    }

    @Override
    public void setUseVRI(boolean useVRI) {
        this.put(USE_VRI_STR, (Object)useVRI);
    }

    @Override
    public boolean getSupportPreReleaseSignatures() {
        return (Boolean)this.get(SUPPORT_PRE_RELEASE_SIGNATURES_STR);
    }

    @Override
    public void setSupportPreReleaseSignatures(boolean supportPreReleaseSignatures) {
        this.put(SUPPORT_PRE_RELEASE_SIGNATURES_STR, (Object)supportPreReleaseSignatures);
    }

    @Override
    public void setCreateFormDOM(boolean createFormDOM) {
        this.put(CREATE_FORM_DOM_STR, (Object)createFormDOM);
    }

    @Override
    public boolean getCreateFormDom() {
        return (Boolean)this.get(CREATE_FORM_DOM_STR);
    }

    @Override
    public UnlockOptions getUnlockOptions() {
        return (UnlockOptions)this.get(UNLOCK_OPTIONS);
    }

    @Override
    public void setUnlockOptions(UnlockOptions unlockOption) {
        this.put(UNLOCK_OPTIONS, (Object)unlockOption);
    }

    @Override
    public Object getProperty(String key) {
        return this.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.put(key, value);
    }
}

