/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.docmanager.passivation;

import com.adobe.aemfd.docmanager.internal.persistence.PersistenceUtils;
import com.adobe.aemfd.docmanager.io.IOUtils;
import com.adobe.aemfd.docmanager.passivation.DocumentPassivationHandler;
import com.adobe.aemfd.docmanager.passivation.PassivationConnection;
import com.adobe.aemfd.docmanager.passivation.PassivationType;
import com.adobe.aemfd.docmanager.source.DocumentSourceHandler;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPassivationHandler
implements DocumentPassivationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPassivationHandler.class);
    private boolean persistOnPassivate;
    private boolean closeStreamOnDispose;
    private boolean computeUnknownLengthIfNonPersistent;

    protected AbstractPassivationHandler(boolean persistOnPassivate, boolean closeStreamOnDispose, boolean computeUnknownLengthIfNonPersistent) {
        this.persistOnPassivate = persistOnPassivate;
        this.closeStreamOnDispose = closeStreamOnDispose;
        this.computeUnknownLengthIfNonPersistent = computeUnknownLengthIfNonPersistent;
    }

    public void inlined() {
    }

    protected DocumentSourceHandler doPassivate(byte[] preBuffer, PassivationConnection conn, long length) throws IOException {
        throw new UnsupportedOperationException("Sub-classes must implement doPassivate() for non-persistent scenarios!");
    }

    public DocumentSourceHandler handlePassivation(byte[] preBuffer, PassivationConnection conn) throws IOException {
        if (this.persistOnPassivate) {
            return PersistenceUtils.passivatePersistently((byte[])preBuffer, (PassivationConnection)conn);
        }
        long pcl = conn.getLength();
        if (pcl == -1L && this.computeUnknownLengthIfNonPersistent) {
            int pbl = preBuffer == null ? 0 : preBuffer.length;
            pcl = (long)pbl + IOUtils.length((InputStream)conn.getContentStream());
        }
        return this.doPassivate(preBuffer, conn, pcl);
    }

    protected void doDispose(PassivationConnection conn, boolean passivated, PassivationType pType) {
    }

    public void dispose(PassivationConnection conn, boolean passivated, PassivationType pType) {
        if (this.closeStreamOnDispose) {
            try {
                conn.getContentStream().close();
            }
            catch (IOException e) {
                logger.warn("Failed to close input-stream of type " + conn.getContentStream().getClass().getName() + " while disposing document passivation handler.", (Throwable)e);
            }
        }
        this.doDispose(conn, passivated, pType);
    }
}

