/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.fdfl.utils.AdaptiveFormUtil;
import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLocalizationService;
import com.adobe.aemds.guide.service.GuideModelImporter;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuideModuleImporter;
import com.adobe.aemds.guide.service.GuideSchemaType;
import com.adobe.aemds.guide.submitutils.FileRequestParameter;
import com.adobe.aemds.guide.utils.AuthoringErrorMessages;
import com.adobe.aemds.guide.utils.CustomJSONWriter;
import com.adobe.aemds.guide.utils.DataLookUp;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideHTMLParser;
import com.adobe.aemds.guide.utils.GuideStringWriterResponse;
import com.adobe.aemds.guide.utils.GuideValueMapResource;
import com.adobe.aemds.guide.utils.GuideWCMUtils;
import com.adobe.aemds.guide.utils.JSONCreationOptions;
import com.adobe.aemds.guide.utils.NameUtils;
import com.adobe.aemds.guide.utils.SchemaImportOptions;
import com.adobe.aemds.guide.utils.TranslationUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.service.StaleAssetIndicatorService;
import com.adobe.forms.common.submitutils.CustomParameterRequest;
import com.adobe.forms.common.submitutils.CustomResponse;
import com.adobe.forms.common.submitutils.ParameterMap;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.TemplatedResource;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.EditConfig;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.components.Toolbar;
import com.day.cq.wcm.commons.WCMUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.script.SimpleBindings;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideUtils.class);
    private static final int ID_LENGTH = 16;
    private static final String RIGHT_LANG_DIRECTION = "rtl";
    private static final String LEFT_LANG_DIRECTION = "ltr";
    private static final Pattern defaultAEMRequestParameters = Pattern.compile("^((sling|cq):.*|:cq_csrf_token)$");
    private static final String MSG_NO_REPEATABLE_ITEM = "Could not compute repeatable item for chart.";

    public static String getSignConfigPath(Resource guideContainerResource) {
        String signConfigPath;
        block2: {
            block1: {
                if (guideContainerResource == null) {
                    return null;
                }
                signConfigPath = null;
                ValueMap guideContainerProperties = guideContainerResource.getValueMap();
                String useSignedPdf = (String)guideContainerProperties.get("_useSignedPdf", (Object)"");
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"true", (CharSequence)useSignedPdf)) break block1;
                Resource signerInfo = guideContainerResource.getChild("signerInfo");
                ValueMap signerInfoProperties = signerInfo.getValueMap();
                signConfigPath = (String)signerInfoProperties.get("signConfigPath", (Object)"");
                break block2;
            }
            String query = "/jcr:root" + guideContainerResource.getPath() + "//element(*, nt:unstructured)[@guideNodeClass = 'esign']";
            Iterator iterator = guideContainerResource.getResourceResolver().findResources(query, "xpath");
            if (!iterator.hasNext()) break block2;
            Resource esignResource = (Resource)iterator.next();
            ValueMap esignProperties = esignResource.getValueMap();
            signConfigPath = (String)esignProperties.get("cq:cloudserviceconfigs", (Object)"");
        }
        return signConfigPath;
    }

    public static JSONArray getAdobeSignFields(String htmlVal) {
        JSONArray adobeSignFieldsArray = new JSONArray();
        HashSet<String> hs = new HashSet<String>();
        Pattern pattern = Pattern.compile("\\{\\{[*]?([^:]*)_es_:");
        Matcher matcher = pattern.matcher(htmlVal);
        while (matcher.find()) {
            String fieldName = matcher.group(1);
            if (!hs.add(fieldName)) continue;
            adobeSignFieldsArray.put((Object)fieldName);
        }
        return adobeSignFieldsArray;
    }

    public static <T> List<T> getTextVariables(Resource resource, Class<T> variableClass) {
        ArrayList<Object> textVariableList = new ArrayList<Object>();
        Resource itemsResource = resource.getChild("items");
        if (itemsResource != null) {
            Iterable variableIterator = itemsResource.getChildren();
            for (Resource variable : variableIterator) {
                Object textVariable = variable.adaptTo(variableClass);
                textVariableList.add(textVariable);
            }
        }
        return textVariableList;
    }

    public static String formatDateDefaultValues(String htmlVal) {
        String result = htmlVal;
        SimpleDateFormat inFormat = new SimpleDateFormat("yyyy-mm-dd");
        Pattern pattern = Pattern.compile("\\{\\{[*]?[^:]*_es_:[^:]*:isdate(\\(format=[\\\"\\']?([^\\\"\\'\\)]*)[\\\"\\']?\\))?(:default\\([\\\"\\']?([^\\\"\\'\\)]*)[\\\"\\']?\\))?[^\\}]*\\}\\}");
        Matcher matcher = pattern.matcher(htmlVal);
        while (matcher.find()) {
            String dateTextTag = matcher.group(0);
            String dateFormat = matcher.group(2);
            String defaultDateStr = matcher.group(4);
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)defaultDateStr)) continue;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dateFormat)) {
                dateFormat = "mm/dd/yy";
            }
            try {
                Date defaultDate = inFormat.parse(defaultDateStr);
                SimpleDateFormat outFormat = new SimpleDateFormat(dateFormat);
                String formattedDefaultDateStr = outFormat.format(defaultDate);
                String correctedDateTextTag = dateTextTag.replace(defaultDateStr, formattedDefaultDateStr);
                result = result.replace(dateTextTag, correctedDateTextTag);
            }
            catch (ParseException parseException) {}
        }
        return result;
    }

    public static String updateSigner(String name, int signerIndex, String htmlVal) {
        Pattern pattern = Pattern.compile("(\\{\\{[*]?" + name + "_es_:[*]?signer(\\d+)[:}])");
        Matcher matcher = pattern.matcher(htmlVal);
        while (matcher.find()) {
            String fieldString = matcher.group(1);
            String fieldSignerIndex = matcher.group(2);
            String newFieldString = fieldString.replace("signer" + fieldSignerIndex, "signer" + signerIndex);
            htmlVal = htmlVal.replace(fieldString, newFieldString);
        }
        return htmlVal;
    }

    public static ResourceResolver getServiceResourceResolver(ResourceResolverFactory resourceResolverFactory) {
        try {
            return resourceResolverFactory.getServiceResourceResolver(null);
        }
        catch (Exception e) {
            logger.error("Cannot provide  serviceResourceResolver", (Throwable)e);
            return null;
        }
    }

    public static ResourceResolver getCloudServiceUserResourceResolver(ResourceResolverFactory resourceResolverFactory) {
        ResourceResolver resourceResolver = null;
        if (resourceResolverFactory != null) {
            try {
                HashMap<String, String> authenticationInfo = new HashMap<String, String>();
                authenticationInfo.put("sling.service.subservice", "readCloudService");
                resourceResolver = resourceResolverFactory.getServiceResourceResolver(authenticationInfo);
            }
            catch (LoginException e) {
                logger.error("Cannot provide service resource resolver", (Throwable)e);
            }
        }
        return resourceResolver;
    }

    public static Map<String, String> convertStringToMap(String params) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (params != null) {
            String[] strategyParams;
            for (String param : strategyParams = params.split(",")) {
                String[] keyValue = param.split("=");
                if (keyValue.length == 2) {
                    paramMap.put(keyValue[0], keyValue[1]);
                    continue;
                }
                paramMap.put(param, param);
            }
        }
        return paramMap;
    }

    public static boolean hasNestablePanelLayout(GuideNode parentNode, GuideNode node) {
        try {
            String nodeLayout;
            if (parentNode == null || !GuideUtils.isLayoutablePanel(parentNode)) {
                return false;
            }
            if (node == null || !GuideUtils.isLayoutablePanel(node)) {
                return false;
            }
            String parentNodeLayout = parentNode.getLayoutPath();
            if (parentNodeLayout != null && (parentNodeLayout.startsWith("/libs/") || parentNodeLayout.startsWith("/apps/"))) {
                parentNodeLayout = parentNodeLayout.substring(6);
            }
            if ((nodeLayout = node.getLayoutPath()) != null && (nodeLayout.startsWith("/libs/") || nodeLayout.startsWith("/apps/"))) {
                nodeLayout = nodeLayout.substring(6);
            }
            return org.apache.commons.lang3.StringUtils.equals((CharSequence)parentNodeLayout, (CharSequence)nodeLayout);
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
    }

    public static String getGuideContainerPath(SlingHttpServletRequest request, Resource resource) {
        String guideContainerPath = null;
        String guideContainerNodeName = "guideContainer";
        String containerParamValue = request.getParameter("guideContainerName");
        if (containerParamValue != null) {
            guideContainerNodeName = containerParamValue;
        } else if (GuideContainerThreadLocal.getGuideContainerName() != null) {
            guideContainerNodeName = GuideContainerThreadLocal.getGuideContainerName();
        } else {
            logger.debug("Guide container name not found in ThreadLocal.");
        }
        try {
            Resource guideContainerResource;
            Resource currentResource;
            ResourceResolver resolver = request.getResourceResolver();
            for (currentResource = resource; currentResource != null && !currentResource.getResourceType().equals("cq:Page"); currentResource = currentResource.getParent()) {
                String normalizedNodeType = GuideUtils.getNormalizedNodeType(currentResource.getResourceType(), currentResource.getResourceSuperType());
                if (!GuideConstants.CONTAINER_RESOURCES.contains(normalizedNodeType) && !GuideUtils.isGuideContainerResource(currentResource)) continue;
                guideContainerPath = currentResource.getPath();
                break;
            }
            if (guideContainerPath == null && currentResource != null && currentResource.getResourceType().equals("cq:Page")) {
                guideContainerPath = resource.getPath() + "/" + guideContainerNodeName;
            }
            if ((guideContainerResource = request.getResourceResolver().getResource(guideContainerPath)) == null) {
                guideContainerPath = null;
            } else {
                ValueMap properties = ResourceUtil.getValueMap((Resource)guideContainerResource);
                String guideRef = (String)properties.get("guideRef", null);
                if (guideRef != null && guideRef.length() != 0) {
                    String path = GuideUtils.guideRefToGuidePath(guideRef);
                    Resource guideContainer = request.getResourceResolver().getResource(path);
                    if (guideContainer != null) {
                        guideContainerPath = path;
                    } else {
                        logger.error("No guide found in guide reference present in guide container");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new GuideException("No guide Container found", e);
        }
        return guideContainerPath;
    }

    public static ArrayList<String> getOptions(String keyValueString, String key, I18n i18n, boolean removeEscaping, Resource formResource) {
        ArrayList<String> splitValues = new ArrayList<String>();
        String value = keyValueString.trim();
        if (value.length() > 0) {
            String optionValue;
            String optionKey;
            boolean endLoop = true;
            int pos = -1;
            int start = 0;
            do {
                if ((pos = value.indexOf(61, start)) > 0 && value.charAt(pos - 1) == '\\') {
                    start = pos + 1;
                    endLoop = false;
                    continue;
                }
                endLoop = true;
            } while (!endLoop);
            if (pos == -1) {
                optionKey = value;
                optionValue = value;
            } else {
                optionKey = value.substring(0, pos);
                optionValue = value.substring(pos + 1);
            }
            if (removeEscaping) {
                optionKey = optionKey.replace("\\=", "=");
                optionValue = optionValue.replace("\\=", "=");
            }
            String translatedString = null;
            if (formResource != null && TranslationUtils.isNewTranslation(formResource.getValueMap())) {
                translatedString = GuideUtils.translateOrReturnOriginal(keyValueString, key, i18n, formResource);
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)keyValueString, (CharSequence)translatedString)) {
                    translatedString = GuideUtils.translateOrReturnOriginal(optionValue, i18n);
                }
            } else {
                translatedString = GuideUtils.translateOrReturnOriginal(optionValue, key, i18n, formResource);
            }
            splitValues.add(optionKey);
            splitValues.add(translatedString);
        } else {
            splitValues.add("");
            splitValues.add("");
        }
        return splitValues;
    }

    public static boolean isRichTextField(JSONObject jsonObject) throws JSONException {
        if (jsonObject.has("allowRichText")) {
            return jsonObject.getBoolean("allowRichText");
        }
        return false;
    }

    public static boolean setToolbarLabel(String name, String title, EditContext editContext, SlingHttpServletRequest request) {
        Toolbar tb;
        EditConfig editConfig;
        if (editContext != null && (editConfig = editContext.getEditConfig()) != null && (tb = editConfig.getToolbar()) != null) {
            if (name != null) {
                tb.add(0, (Toolbar.Item)new Toolbar.Label(title + name));
            }
            tb.add(1, (Toolbar.Item)new Toolbar.Separator());
            return true;
        }
        return false;
    }

    public static String encodeForHtml(String str, XSSAPI xssapi) {
        String result = xssapi.encodeForHTML(str);
        return result == null ? "" : result;
    }

    public static String encodeForHtmlAttr(String str, XSSAPI xssapi) {
        String result = xssapi.encodeForHTMLAttr(str);
        return result == null ? "" : result;
    }

    public static String encodeForJSString(String str, XSSAPI xssapi) {
        String result = xssapi.encodeForJSString(str);
        return result == null ? "" : result;
    }

    public static String filterHtml(String str, XSSAPI xssapi) {
        String result = xssapi.filterHTML(str);
        return result == null ? "" : result;
    }

    public static String getValidCSSColor(String str, org.apache.sling.xss.XSSAPI xssapi) {
        String result = xssapi.getValidCSSColor(str, null);
        return result == null ? "" : result;
    }

    public static String encodeForCSSString(String str, org.apache.sling.xss.XSSAPI xssapi) {
        String result = xssapi.encodeForCSSString(str);
        return result == null ? "" : result;
    }

    public static String sanitizeCSSString(String str, org.apache.sling.xss.XSSAPI xssapi) {
        String[] parts = str.split(";");
        StringBuilder sanitizedCSS = new StringBuilder();
        for (String part : parts) {
            if (part.trim().startsWith("content")) {
                String filteredContent = xssapi.filterHTML(part);
                String decodedString = StringEscapeUtils.unescapeHtml4((String)filteredContent);
                sanitizedCSS.append(decodedString).append(";");
                continue;
            }
            if (part.trim().contains("color")) {
                sanitizedCSS.append(part.trim().split(":")[0]).append(":").append(GuideUtils.getValidCSSColor(part.trim().split(":")[1], xssapi)).append(";");
                continue;
            }
            sanitizedCSS.append(xssapi.encodeForCSSString(part)).append(";");
        }
        return sanitizedCSS.deleteCharAt(sanitizedCSS.length() - 1).toString();
    }

    public static String getDefaultLocale(Resource resource) {
        String defaultLocale = "en";
        try {
            Node parentNode;
            Node containerNode = (Node)resource.adaptTo(Node.class);
            if (containerNode != null && (parentNode = containerNode.getParent()) != null && parentNode.hasProperty("jcr:language")) {
                defaultLocale = parentNode.getProperty("jcr:language").getString();
            }
        }
        catch (Exception e) {
            logger.error("Unable to access Page Locale", (Throwable)e);
        }
        return defaultLocale;
    }

    public static String getThemeClientLibName(Resource resource) {
        try {
            String theme;
            Node containerNode = (Node)resource.adaptTo(Node.class);
            if (containerNode != null && containerNode.hasProperty("themeRef") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(theme = containerNode.getProperty("themeRef").getString()))) {
                Resource themeResource = resource.getResourceResolver().getResource(theme + "/jcr:content/metadata");
                if (themeResource != null) {
                    Node themeNode = (Node)themeResource.adaptTo(Node.class);
                    if (themeNode != null && themeNode.hasProperty("clientlibCategory")) {
                        return themeNode.getProperty("clientlibCategory").getString();
                    }
                } else {
                    logger.warn("Unable to retrieve the theme resource: " + theme);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Unable to get Client lib name: " + e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String getLocaleParamFromRequest(SlingHttpServletRequest request) {
        String acceptLangParam = null;
        String[] supportedLocales = null;
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        if (bindings != null) {
            GuideLocalizationService guideLocalizationService = (GuideLocalizationService)bindings.getSling().getService(GuideLocalizationService.class);
            supportedLocales = guideLocalizationService.getSupportedLocales();
        }
        try {
            acceptLangParam = GuideUtils.getLocaleFromURI(request.getRequestPathInfo(), supportedLocales);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)acceptLangParam)) {
                acceptLangParam = org.apache.commons.lang3.StringUtils.trimToEmpty((String)request.getParameter("afAcceptLang"));
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)acceptLangParam)) {
                acceptLangParam = org.apache.commons.lang3.StringUtils.trimToEmpty((String)((String)request.getAttribute("afAcceptLang")));
            }
            if (GuideUtils.useBrowserLocale(request) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)acceptLangParam)) {
                acceptLangParam = org.apache.commons.lang3.StringUtils.trimToEmpty((String)request.getHeader("Accept-Language"));
            }
        }
        catch (Exception e) {
            logger.error("Could not get locale information in request object: " + e.getMessage(), (Throwable)e);
        }
        return acceptLangParam;
    }

    private static String getLocaleFromURI(RequestPathInfo requestPathInfo, String[] supportedLocales) {
        Object selector = null;
        Object[] selectors = requestPathInfo.getSelectors();
        if (ArrayUtils.isNotEmpty((Object[])selectors) && ArrayUtils.isNotEmpty((Object[])supportedLocales)) {
            for (int i = selectors.length - 1; i >= 0; --i) {
                Object sel = selectors[i];
                if (!ArrayUtils.contains((Object[])supportedLocales, (Object)sel)) continue;
                selector = sel;
                break;
            }
        }
        return selector;
    }

    public static String getLocale(SlingHttpServletRequest request, Resource guideContainerResource) {
        try {
            String defaultLocale = GuideUtils.getDefaultLocale(guideContainerResource);
            String localeCode = null;
            String clientLibPrefix = "guides.I18N";
            Object locale = null;
            SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
            HtmlLibraryManager clientlibManager = (HtmlLibraryManager)bindings.getSling().getService(HtmlLibraryManager.class);
            boolean clientLibForDefaultLocaleExists = clientlibManager.getLibraries(new String[]{clientLibPrefix + "." + defaultLocale}, null, true, false).toArray().length > 0;
            String acceptLang = GuideUtils.getLocaleParamFromRequest(request);
            if (acceptLang == null || acceptLang.trim().isEmpty()) {
                acceptLang = defaultLocale;
            }
            String[] locales = org.apache.commons.lang3.StringUtils.split((String)acceptLang, (String)",");
            for (int i = 0; i < locales.length; ++i) {
                String[] categories;
                Collection libraries;
                boolean clientLibForLocaleExists;
                localeCode = org.apache.commons.lang3.StringUtils.substringBefore((String)locales[i], (String)";");
                String[] splitLocale = org.apache.commons.lang3.StringUtils.split((String)localeCode, (String)"-");
                localeCode = splitLocale[0].toLowerCase();
                if (splitLocale.length > 1) {
                    localeCode = localeCode + splitLocale[1].toUpperCase();
                }
                boolean bl = clientLibForLocaleExists = (libraries = clientlibManager.getLibraries(categories = new String[]{clientLibPrefix + "." + localeCode}, null, true, false)).toArray().length > 0;
                if (clientLibForLocaleExists) {
                    return localeCode;
                }
                if (splitLocale.length <= 1) continue;
                categories = new String[]{clientLibPrefix + "." + splitLocale[0].toLowerCase()};
                libraries = clientlibManager.getLibraries(categories, null, true, false);
                boolean bl2 = clientLibForLocaleExists = libraries.toArray().length > 0;
                if (!clientLibForLocaleExists) continue;
                return splitLocale[0].toLowerCase();
            }
            if (clientLibForDefaultLocaleExists) {
                return defaultLocale;
            }
            return "en";
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public static I18n getI18n(SlingHttpServletRequest request, Resource guideFieldResource) {
        I18n i18n = null;
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            String containerPath;
            String acceptLang = GuideUtils.getAcceptLang(request);
            if (GuideUtils.isEditableTemplateResource(guideFieldResource).booleanValue()) {
                String formAssetPath = resourceResolver.resolve((HttpServletRequest)request, request.getRequestURI()).getPath();
                formAssetPath = formAssetPath.substring(request.getContextPath().length());
                String formPath = formAssetPath.replace("/content/dam/formsanddocuments/", "/content/forms/af/");
                guideFieldResource = resourceResolver.getResource(formPath);
            }
            if ((containerPath = GuideUtils.getGuideContainerPath(request, guideFieldResource)) == null || containerPath.isEmpty()) {
                containerPath = GuideUtils.getGuideContainerPathFromResource(request, guideFieldResource);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)containerPath)) {
                Locale locale = new Locale(acceptLang);
                if (WCMMode.fromRequest((ServletRequest)request) == WCMMode.EDIT || WCMMode.fromRequest((ServletRequest)request) == WCMMode.DESIGN) {
                    String baseName = TranslationUtils.getDictionaryPath(resourceResolver, containerPath);
                    Resource baseResource = request.getResourceResolver().getResource(baseName);
                    ResourceBundle resourceBundle = GuideUtils.isDesiredLocaleDictPresent(baseResource, locale) != false ? request.getResourceBundle(baseName, locale) : null;
                    i18n = new I18n(resourceBundle);
                } else {
                    i18n = new I18n(GuideUtils.getResourceBundle(request, guideFieldResource, locale));
                }
            } else {
                i18n = request != null ? new I18n(request.getResourceBundle(request.getLocale())) : new I18n(request.getResourceBundle(null));
            }
        }
        catch (Exception e) {
            logger.error("There was certainly some problem in geti18n api", (Throwable)e);
        }
        return i18n;
    }

    public static String getAssetPathFromPage(String pagePath) {
        return pagePath.replace("/content/forms/af", "/content/dam/formsanddocuments");
    }

    public static ValueMap getDamJcrValueMap(ResourceResolver resourceResolver, SlingHttpServletRequest request, Resource contentResource) {
        String guideContainerPath = GuideUtils.getGuideContainerPathFromResource(request, contentResource);
        Resource guideContainer = resourceResolver.getResource(guideContainerPath);
        String damAssetPath = GuideUtils.getAssetPathFromPage(guideContainer.getParent().getPath());
        ValueMap damValueMap = resourceResolver.getResource(damAssetPath).getValueMap();
        return damValueMap;
    }

    public static Boolean isEditableTemplateResource(Resource resource) {
        Resource pageParent;
        Boolean result = false;
        Resource pageResource = GuideUtils.getPageResource(resource);
        if (pageResource != null && "cq:Template".equals((pageParent = pageResource.getParent()).getResourceType())) {
            result = pageParent.getChild("initial") != null && pageParent.getChild("policies") != null && pageParent.getChild("structure") != null;
        }
        return result;
    }

    public static Resource getPageResource(Resource resource) {
        while (resource != null && !"cq:Page".equals(resource.getResourceType())) {
            resource = resource.getParent();
        }
        return resource;
    }

    public static I18n getI18n(ResourceBundleProvider resourceBundleProvider, Resource containerResource, Locale locale) {
        if (resourceBundleProvider != null && containerResource != null && locale != null) {
            return new I18n(resourceBundleProvider.getResourceBundle(containerResource.getPath(), locale));
        }
        return null;
    }

    public static String getDataMimeType(Resource formResource) {
        GuideContainer guideContainerBean;
        GuideSchemaType schemaType;
        String mimeType = "application/xml";
        if (formResource != null && (schemaType = (guideContainerBean = GuideContainer.from(formResource)).getSchema()) != null && (GuideSchemaType.JSON.equals((Object)schemaType) || GuideSchemaType.FDM.equals((Object)schemaType))) {
            mimeType = "application/json";
        }
        return mimeType;
    }

    public static String getSchemaType(JSONObject formContainerJson) {
        String type = GuideSchemaType.BASIC.getValue();
        String schemaType = formContainerJson.optString("schemaType", "");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)schemaType) && GuideSchemaType.isGuideSchemaType(schemaType)) {
            type = schemaType;
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)formContainerJson.optString("xsdRef"))) {
            type = GuideSchemaType.XSD.getValue();
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)formContainerJson.optString("xdpRef"))) {
            type = GuideSchemaType.XDP.getValue();
        }
        return type;
    }

    public static String getAfDataSom(String schemaType, String name, String bindRef) {
        String identifier = name;
        String fieldType = "none";
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)bindRef)) {
            fieldType = schemaType;
            identifier = bindRef;
        }
        return fieldType + ":" + identifier;
    }

    public static JSONObject somToAdapativeFormItem(JSONObject formContainerJson, String somExpression) {
        JSONObject afItemJson = null;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)somExpression) || formContainerJson == null) {
            return afItemJson;
        }
        if ("guide[0].guide1[0]".equals(somExpression)) {
            return formContainerJson;
        }
        try {
            JSONObject rootPanelJSon = formContainerJson.getJSONObject("rootPanel");
            if ("guide[0].guide1[0].guideRootPanel[0]".equals(somExpression)) {
                return rootPanelJSon;
            }
            String afItemSom = somExpression.replaceFirst("guide\\[0\\]\\.guide1\\[0\\]\\.guideRootPanel\\[0\\]\\.", "");
            afItemJson = GuideUtils.searchAFItemForSom(rootPanelJSon, afItemSom);
        }
        catch (JSONException jsonException) {
            logger.error("Error creating signer info " + jsonException.getMessage(), (Throwable)jsonException);
        }
        return afItemJson;
    }

    private static JSONObject searchAFItemForSom(JSONObject afItemJson, String parentSom) {
        JSONObject parentJson = afItemJson;
        String afItemSom = parentSom;
        if (parentJson != null) {
            int nextIndex;
            String fieldName = afItemSom.substring(0, afItemSom.indexOf("["));
            if ((parentJson = parentJson.optJSONObject("items")) == null && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fieldName)) {
                return null;
            }
            Iterator keys = parentJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONObject childJson = parentJson.optJSONObject(key);
                if (childJson == null || !fieldName.equals(childJson.optString("name"))) continue;
                parentJson = childJson;
                break;
            }
            if ((nextIndex = afItemSom.indexOf(".")) != -1) {
                afItemSom = afItemSom.substring(nextIndex + 1);
                return GuideUtils.searchAFItemForSom(parentJson, afItemSom);
            }
            return parentJson;
        }
        return null;
    }

    public static String paramToString(RequestParameter param) {
        if (param != null) {
            return param.toString();
        }
        return null;
    }

    public static String guideRefToGuidePath(String guideRefPath) {
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)guideRefPath, (CharSequence)"/content/dam/formsanddocuments/")) {
            return "/content/forms/af/" + org.apache.commons.lang3.StringUtils.substringAfter((String)guideRefPath, (String)"/content/dam/formsanddocuments/") + "/jcr:content/guideContainer";
        }
        return guideRefPath;
    }

    public static String guideRefToDocPath(String guideRefPath) {
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)guideRefPath, (CharSequence)"/content/dam/formsanddocuments/")) {
            return GuideUtils.convertADAssetPathToWebChannelPagePath(guideRefPath) + "/jcr:content/guideContainer";
        }
        return guideRefPath;
    }

    public static String manipulateBindRefForFragments(String bindRefPrefixForFragment, String bindRef, String fragmentRoot) {
        String manipulatedBindRef = bindRef;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bindRefPrefixForFragment) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fragmentRoot)) {
            if (fragmentRoot.equals(bindRef)) {
                return null;
            }
            if (fragmentRoot.equals("/") || fragmentRoot.equals("xfa[0].form[0]")) {
                return bindRef;
            }
            if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)bindRef, (CharSequence)"xfa[0].form[0]") && !org.apache.commons.lang3.StringUtils.startsWith((CharSequence)bindRef, (CharSequence)(fragmentRoot + '.'))) {
                return bindRef;
            }
            if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)bindRef, (CharSequence)"/") && !org.apache.commons.lang3.StringUtils.startsWith((CharSequence)bindRef, (CharSequence)(fragmentRoot + '/'))) {
                return bindRef;
            }
            if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)bindRef, (CharSequence)"xfa[0].form[0]")) {
                manipulatedBindRef = bindRefPrefixForFragment + org.apache.commons.lang3.StringUtils.substringAfter((String)bindRef, (String)fragmentRoot);
            } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)bindRef, (CharSequence)"/")) {
                manipulatedBindRef = bindRefPrefixForFragment + org.apache.commons.lang3.StringUtils.substringAfter((String)bindRef, (String)fragmentRoot);
            }
        }
        return manipulatedBindRef;
    }

    public static String getNamespacedKeys(String value, String key, Resource formResource) {
        String dictKey = "fd_" + value;
        if (formResource != null) {
            dictKey = GuideUtils.getNamespacedKeys(value, key, formResource.getValueMap());
        }
        return dictKey;
    }

    public static String getNamespacedKeys(String value, String key, ValueMap properties) {
        String dictKey = "fd_" + value;
        if (properties != null && !properties.isEmpty() && key != null) {
            try {
                String translationId = TranslationUtils.getTranslationId(properties, key, value);
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)translationId)) {
                    dictKey = translationId;
                }
            }
            catch (IOException ex) {
                logger.error("[AF] Unable to fetch translation id for {}", (Object)key, (Object)ex);
            }
        }
        return dictKey;
    }

    public static String translateOrReturnOriginal(String value, String key, I18n i18n, @Nullable ValueMap properties) {
        if (i18n != null) {
            String localizedkey;
            String nameSpacedkey;
            if (properties != null && TranslationUtils.isNewTranslation(properties)) {
                nameSpacedkey = GuideUtils.getNamespacedKeys(value, key, properties);
                localizedkey = i18n.getVar(nameSpacedkey);
            } else {
                nameSpacedkey = GuideUtils.getNamespacedKeys(value, key, properties).replaceAll("\r", "");
                localizedkey = i18n.getVar(nameSpacedkey);
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)localizedkey, (CharSequence)nameSpacedkey)) {
                    nameSpacedkey = GuideUtils.getNamespacedKeys(value, key, properties);
                    localizedkey = i18n.getVar(nameSpacedkey);
                }
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)localizedkey, (CharSequence)nameSpacedkey)) {
                    nameSpacedkey = GuideUtils.getNamespacedKeys(org.apache.commons.lang3.StringUtils.strip((String)value), key, properties);
                    localizedkey = i18n.getVar(nameSpacedkey);
                }
            }
            if (!nameSpacedkey.equals(localizedkey)) {
                return localizedkey;
            }
        }
        return value;
    }

    public static String translateOrReturnOriginal(String original, String key, I18n i18n, @Nullable Resource formResource) {
        return GuideUtils.translateOrReturnOriginal(original, key, i18n, formResource != null ? formResource.getValueMap() : null);
    }

    public static String escapeXml(String unescaped) {
        return StringEscapeUtils.escapeXml((String)unescaped);
    }

    public static boolean isGuideFileUploadModel(String guideNodeClass) {
        return "guideFileUpload".equals(guideNodeClass);
    }

    public static boolean isGuideButtonModel(String guideNodeClass) {
        return "guideButton".equals(guideNodeClass);
    }

    public static boolean isGuideFieldModel(String guideNodeClass) {
        return GuideConstants.GUIDE_FIELDS_CLASS_NAMES.indexOf(guideNodeClass) >= 0;
    }

    public static boolean isGuidePanelModel(String guideNodeClass) {
        return GuideConstants.GUIDE_PANELS_CLASS_NAMES.indexOf(guideNodeClass) >= 0;
    }

    public static boolean isGuideCompositeField(String guideNodeClass) {
        return GuideConstants.GUIDE_COMPOSITE_FIELD_CLASS_NAMES.indexOf(guideNodeClass) >= 0;
    }

    public static boolean isGuideTnCModel(String guideNodeClass) {
        return "guideTermsAndConditions".equals(guideNodeClass);
    }

    public static JSONObject getGuideContainer(JSONObject guideJson) throws GuideException {
        try {
            return guideJson.has("rootPanel") ? guideJson : (guideJson.has("jcr:content") ? guideJson.getJSONObject("jcr:content").getJSONObject("guideContainer") : guideJson);
        }
        catch (Exception e) {
            logger.error("Could not get guideContainer within GuideJson : " + guideJson.toString(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public static ValueMap getGuideContainer(SlingHttpServletRequest request, Resource elementResource) {
        if (elementResource == null) {
            return null;
        }
        Iterator iter = elementResource.listChildren();
        Resource guideContainer = null;
        while (iter.hasNext() && guideContainer == null) {
            Resource current = (Resource)iter.next();
            if (!GuideConstants.CONTAINER_RESOURCES.contains(current.getResourceType())) continue;
            guideContainer = current;
        }
        if (guideContainer != null) {
            return ResourceUtil.getValueMap(guideContainer);
        }
        logger.error("No guideContainer found");
        throw new GuideException("No guideContainer found");
    }

    public static Boolean isValidGuide(SlingHttpServletRequest request, Resource resource) throws RepositoryException {
        ValueMap properties = null;
        properties = GuideConstants.CONTAINER_RESOURCES.contains(resource.getResourceType()) ? ResourceUtil.getValueMap((Resource)resource) : GuideUtils.getGuideContainer(request, resource);
        String guideRef = (String)properties.get("guideRef", null);
        if (guideRef != null && guideRef.length() != 0) {
            String guideContainerPath = GuideUtils.guideRefToGuidePath(guideRef);
            Resource guideContainer = request.getResourceResolver().getResource(guideContainerPath);
            if (guideContainer == null) {
                logger.error("No guide found in guide reference present in guide container");
                return false;
            }
        }
        return true;
    }

    public static Locale getAFLocale(String locale, GuideLocalizationService guideLocalizationService) {
        HashSet<String> supportedLocales = new HashSet<String>(Arrays.asList(guideLocalizationService.getSupportedLocales()));
        if (!supportedLocales.contains(locale)) {
            String language = new Locale(locale).getLanguage();
            locale = supportedLocales.contains(language) ? language : "en";
        }
        return new Locale(locale);
    }

    private static String[] getAemSupportedLocales(GuideLocalizationService guideLocalizationService) {
        String[] aemSupportedlocales = guideLocalizationService != null ? guideLocalizationService.getSupportedLocales() : GuideConstants.AEM_SUPPORTED_LOCALES;
        return aemSupportedlocales;
    }

    public static String getAFPathFromFormContainerResource(Resource formContainerResource) {
        String afPath = formContainerResource.getPath();
        if (afPath.endsWith("/")) {
            afPath = afPath.substring(0, afPath.length() - 1);
        }
        if (!afPath.contains("/content/dam/formsanddocuments/") && !afPath.contains("/content/forms/af/")) {
            logger.debug("Adaptive Form is not found in the specified Path.");
            afPath = null;
        } else if (!afPath.contains("/content/dam/formsanddocuments/")) {
            afPath = GuideUtils.convertGuideContainerPathToFMAssetPath(afPath);
        }
        return afPath;
    }

    private static String getGuideContainerPathFromFormContainerResource(Resource formContainerResource) {
        return GuideUtils.convertFMAssetPathToContainerPath(GuideUtils.getAFPathFromFormContainerResource(formContainerResource));
    }

    public static JSONCreationOptions getJsonCreationOptions(String guideContainerPath, String locale, GuideLocalizationService guideLocalizationService) {
        JSONCreationOptions jsonCreationOptions = new JSONCreationOptions();
        jsonCreationOptions.setFormContainerPath(guideContainerPath);
        jsonCreationOptions.setIncludeFragmentJson(true);
        jsonCreationOptions.setLocale(GuideUtils.getAFLocale(locale, guideLocalizationService));
        return jsonCreationOptions;
    }

    public static JSONObject getFormGuideJsonFromFormSubmitInfo(FormSubmitInfo formSubmitInfo, GuideModelTransformer guideModelTransformer, GuideLocalizationService guideLocalizationService) {
        Resource formContainerResource = formSubmitInfo.getFormContainerResource();
        String guideContainerPath = GuideUtils.getGuideContainerPathFromFormContainerResource(formSubmitInfo.getFormContainerResource());
        Resource guideResource = formContainerResource.getResourceResolver().getResource(guideContainerPath);
        JSONCreationOptions jsonCreationOptions = GuideUtils.getJsonCreationOptions(guideContainerPath, formSubmitInfo.getLocale(), guideLocalizationService);
        return guideModelTransformer.exportGuideJsonObject(guideResource, jsonCreationOptions);
    }

    public static String getNormalizedNodeType(String resourceType, String resourceSuperType) {
        String normalizedType = null;
        if (resourceType == null && resourceSuperType == null) {
            return null;
        }
        if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"fd/")) {
            normalizedType = resourceType;
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/libs/fd/") || org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/apps/fd/")) {
            normalizedType = resourceType.substring(6);
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"fd/")) {
            normalizedType = resourceSuperType;
        } else if (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"/libs/fd/") || org.apache.commons.lang3.StringUtils.startsWith((CharSequence)resourceSuperType, (CharSequence)"/apps/fd/")) {
            normalizedType = resourceSuperType.substring(6);
        }
        return normalizedType;
    }

    public static void walkThroughContent(List<String> list, Resource elementResource, String resourceToBeFound) {
        if (elementResource != null) {
            Iterator iter = elementResource.listChildren();
            while (iter.hasNext()) {
                Resource current = (Resource)iter.next();
                String normalizedNodeType = GuideUtils.getNormalizedNodeType(current.getResourceType(), current.getResourceSuperType());
                if (resourceToBeFound.equals(normalizedNodeType)) {
                    list.add(current.getPath());
                }
                GuideUtils.walkThroughContent(list, current, resourceToBeFound);
            }
        }
    }

    public static boolean isLayoutablePanel(GuideNode node) {
        return GuideUtils.isPanel(node.getResource());
    }

    public static String convertFMAssetPathToContainerPath(String fragRef) {
        fragRef = StringUtils.replace((String)fragRef, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1);
        fragRef = fragRef + "/jcr:content" + "/" + "guideContainer";
        return fragRef;
    }

    private static String removeChannelNameFromEndIfExist(String pagePath) {
        String retVal = pagePath;
        retVal = org.apache.commons.lang3.StringUtils.substringBefore((String)retVal, (String)"/channels/");
        retVal = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)retVal, (String)"/jcr:content");
        return retVal;
    }

    public static String convertGuideContainerPathToFMAssetPath(String guideContainerPath) {
        String fmPath = org.apache.commons.lang3.StringUtils.substringBefore((String)guideContainerPath, (String)"/jcr:content/guideContainer");
        String retVal = GuideUtils.removeChannelNameFromEndIfExist(fmPath);
        retVal = org.apache.commons.lang3.StringUtils.replace((String)retVal, (String)"/content/forms/af/", (String)"/content/dam/formsanddocuments/", (int)1);
        return retVal;
    }

    public static String convertGuideContainerPathToFMAssetMetadataPath(String guideContainerPath) {
        String fmAssetMetadataPath = GuideUtils.convertGuideContainerPathToFMAssetPath(guideContainerPath);
        fmAssetMetadataPath = fmAssetMetadataPath + "/jcr:content/metadata";
        return fmAssetMetadataPath;
    }

    public static String getDoRTemplateRef(String guideContainerPath, String runtimeLocale, ResourceResolver resourceResolver) {
        String formDAMAssetMetadataPath = GuideUtils.convertGuideContainerPathToFMAssetMetadataPath(guideContainerPath);
        Resource containerResource = resourceResolver.getResource(guideContainerPath);
        Resource formMetadataResource = resourceResolver.getResource(formDAMAssetMetadataPath);
        String dorTemplateRef = "";
        if (formMetadataResource != null) {
            ValueMap metadata = formMetadataResource.getValueMap();
            dorTemplateRef = (String)metadata.get("xdpRef", (Object)"");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dorTemplateRef)) {
                dorTemplateRef = (String)metadata.get((Object)"dorTemplateRef");
                String dorType = (String)metadata.get("dorType", (Object)"");
                if ("generate".equals(dorType)) {
                    dorTemplateRef = GuideUtils.convertGuideContainerPathToFMAssetPath(guideContainerPath) + "/jcr:content/renditions/dorTemplate/" + runtimeLocale;
                } else if ("none".equals(dorType)) {
                    dorTemplateRef = "";
                }
            }
        } else if (containerResource != null && !GuideUtils.isEditableTemplateResource(containerResource).booleanValue()) {
            logger.error("DAM asset metadata node not available for guide container path: " + guideContainerPath);
        }
        return dorTemplateRef;
    }

    public static ResourceResolver getResolverFromResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (resourceResolverHelper != null) {
            return resourceResolverHelper.getResourceResolver();
        }
        return null;
    }

    public static ResourceResolver getResolverFromResource(GuideContainer guideContainer) {
        Resource resource = null;
        if (guideContainer != null && (resource = guideContainer.getResource()) != null) {
            return resource.getResourceResolver();
        }
        return null;
    }

    public static StrSubstitutor getStringSubstitutor(JSONObject valueMap) {
        return new StrSubstitutor((StrLookup)new DataLookUp(valueMap));
    }

    public static Boolean isPanel(Resource resource) {
        Boolean isPanel = Boolean.FALSE;
        if (resource != null) {
            isPanel = resource.isResourceType("fd/af/components/panel") || resource.isResourceType("fd/af/components/rootPanel");
        }
        return isPanel;
    }

    public static Boolean hasModifyPermission(Resource resource) {
        Session currentSession = (Session)resource.getResourceResolver().adaptTo(Session.class);
        try {
            if (currentSession.hasPermission(resource.getPath(), "set_property")) {
                return Boolean.TRUE;
            }
        }
        catch (RepositoryException e) {
            logger.error("unable to check the permissions for setting property on " + resource.getPath(), (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public static Boolean embedFragmentResources(Resource fragmentPanelResource, String fragmentPath, Boolean processConversion) {
        ResourceResolver resourceResolver = fragmentPanelResource.getResourceResolver();
        try {
            Resource prevItemsResources = resourceResolver.getResource(fragmentPanelResource.getPath() + "/items");
            if (prevItemsResources != null) {
                resourceResolver.delete(prevItemsResources);
            }
            resourceResolver.copy(fragmentPath, fragmentPanelResource.getPath());
            if (processConversion.booleanValue()) {
                GuideUtils.convertPanelToNewResponsiveLayout(fragmentPanelResource);
            }
            ModifiableValueMap modifiableMap = (ModifiableValueMap)fragmentPanelResource.adaptTo(ModifiableValueMap.class);
            modifiableMap.remove((Object)"fragRef");
            fragmentPanelResource.getResourceResolver().commit();
        }
        catch (Exception e) {
            logger.error("error in embedding adaptive form fragment", (Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean convertToNewResponsiveLayout(Resource guideContainerResource) {
        Resource rootPanelResource = guideContainerResource.getChild("rootPanel");
        if (!GuideUtils.hasModifyPermission(rootPanelResource).booleanValue()) {
            logger.error("Has insufficient permissions to convert to new responsive layout " + rootPanelResource.getPath());
            return Boolean.FALSE;
        }
        GuideUtils.convertPanelToNewResponsiveLayout(rootPanelResource);
        try {
            rootPanelResource.getResourceResolver().commit();
        }
        catch (PersistenceException e) {
            logger.error("Unable to save changes of converted layout " + rootPanelResource.getPath(), (Throwable)e);
        }
        return Boolean.TRUE;
    }

    public static void convertPanelToNewResponsiveLayout(Resource panelResource) {
        Resource itemsResource;
        Resource layoutResource = panelResource.getChild("layout");
        String layoutResourceType = layoutResource.getResourceType();
        if ("fd/af/layouts/gridFluidLayout".equals(layoutResourceType)) {
            ModifiableValueMap modifiableMap = (ModifiableValueMap)layoutResource.adaptTo(ModifiableValueMap.class);
            modifiableMap.put((Object)"sling:resourceType", (Object)"fd/af/layouts/gridFluidLayout2");
            modifiableMap.remove((Object)"columns");
        }
        if ((itemsResource = panelResource.getChild("items")) != null) {
            String itemsResourceType = itemsResource.getResourceType();
            if ("fd/af/layouts/gridFluidLayout".equals(itemsResourceType)) {
                ModifiableValueMap modifiableMap = (ModifiableValueMap)itemsResource.adaptTo(ModifiableValueMap.class);
                modifiableMap.remove((Object)"sling:resourceType");
            }
            for (Resource item : itemsResource.getChildren()) {
                ModifiableValueMap modifiableMap = (ModifiableValueMap)item.adaptTo(ModifiableValueMap.class);
                modifiableMap.remove((Object)"colspan");
                if (!item.isResourceType("fd/af/components/panel")) continue;
                GuideUtils.convertPanelToNewResponsiveLayout(item);
            }
        }
    }

    public static Boolean isOldResponsiveLayout(Resource panelResource) {
        if (!GuideUtils.isPanel(panelResource).booleanValue()) {
            return null;
        }
        Resource layoutResource = panelResource.getChild("layout");
        if (layoutResource == null) {
            return null;
        }
        String layoutResourceType = layoutResource.getResourceType();
        if ("fd/af/layouts/gridFluidLayout".equals(layoutResourceType)) {
            return Boolean.TRUE;
        }
        if ("fd/af/layouts/gridFluidLayout2".equals(layoutResourceType)) {
            return Boolean.FALSE;
        }
        Resource itemsResource = panelResource.getChild("items");
        if (itemsResource != null && itemsResource.hasChildren()) {
            for (Resource itemResource : itemsResource.getChildren()) {
                Boolean isOldResponsiveLayout = GuideUtils.isOldResponsiveLayout(itemResource);
                if (isOldResponsiveLayout == null) continue;
                return isOldResponsiveLayout;
            }
        }
        return null;
    }

    public static Boolean hasOldResponsiveLayout(Resource panelResource) {
        Boolean isOldResponsiveLayout = GuideUtils.isOldResponsiveLayout(panelResource);
        if (isOldResponsiveLayout != null) {
            return isOldResponsiveLayout;
        }
        return Boolean.FALSE;
    }

    public static GuidePanel getRootPanel(Resource resource, SlingHttpServletRequest slingRequest) {
        Iterator iter = resource.listChildren();
        GuidePanel rootPanel = null;
        ResourceResolver resourceResolver = resource.getResourceResolver();
        while (iter.hasNext() && rootPanel == null) {
            Resource current = (Resource)iter.next();
            String name = current.getName();
            if (!"rootPanel".equals(name)) continue;
            rootPanel = new GuidePanel();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("resource", (Object)current);
            bindings.put("request", (Object)slingRequest);
            rootPanel.init(bindings);
        }
        return rootPanel;
    }

    public static GuideModuleImporter getGuideModuleImporter(SlingHttpServletRequest slingRequest) {
        SlingBindings bindings = null;
        GuideModuleImporter guideModuleImporter = null;
        if (slingRequest != null && (bindings = (SlingBindings)slingRequest.getAttribute(SlingBindings.class.getName())) != null) {
            guideModuleImporter = (GuideModuleImporter)bindings.getSling().getService(GuideModuleImporter.class);
        }
        return guideModuleImporter;
    }

    public static Resource getRootPanel(Resource resource) {
        try {
            if (resource != null) {
                for (Resource item : resource.getChildren()) {
                    String valueOfResourceType;
                    ValueMap valueMap = (ValueMap)item.adaptTo(ValueMap.class);
                    if (valueMap.get((Object)"sling:resourceType") == null || !"fd/af/components/rootPanel".equals(valueOfResourceType = (String)valueMap.get((Object)"sling:resourceType"))) continue;
                    return item;
                }
            }
        }
        catch (Exception e) {
            logger.error("error in getting root panel via guide json", (Throwable)e);
        }
        return null;
    }

    public static String removePrefix(String str, String prefix) {
        if (str == null || prefix == null) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static Calendar getLastModifiedTimeFromStaleAssetIndicatorService(GuideContainer guideContainer, StaleAssetIndicatorService staleAssetIndicatorService) {
        Resource assetNode = null;
        Calendar lastModifiedTime = null;
        try {
            ResourceResolver guideResourceResolver = guideContainer.getResource().getResourceResolver();
            if (guideResourceResolver != null) {
                String assetPath = GuideUtils.convertGuideContainerPathToFMAssetPath(guideContainer.getPath());
                assetNode = guideResourceResolver.getResource(assetPath);
                lastModifiedTime = assetNode != null && org.apache.commons.lang3.StringUtils.startsWith((CharSequence)assetPath, (CharSequence)"/content/dam/formsanddocuments/") ? GuideUtils.getCurrentLMT(assetNode, staleAssetIndicatorService) : guideContainer.getLastModifiedTime();
            }
        }
        catch (Exception e) {
            logger.error("Error while calling getLastModifiedTimeFromStaleAssetIndicatorService", (Throwable)e);
        }
        return lastModifiedTime;
    }

    public static boolean isJsonBasedSchema(String schemaType) {
        return GuideSchemaType.JSON.equals((Object)GuideSchemaType.getGuideSchemaType(schemaType)) || GuideSchemaType.FDM.equals((Object)GuideSchemaType.getGuideSchemaType(schemaType));
    }

    public static boolean isXDPValid(Resource guideContainer) {
        if (guideContainer == null) {
            return false;
        }
        GuideContainer guideContainerBean = GuideContainer.from(guideContainer);
        if (!GuideSchemaType.XDP.equals((Object)guideContainerBean.getSchema())) {
            return false;
        }
        String xdpRef = guideContainerBean.getSchemaRef();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)xdpRef)) {
            return false;
        }
        return guideContainerBean.getResource().getResourceResolver().getResource(xdpRef) != null;
    }

    public static boolean isMetaTemplateValid(ResourceResolver resourceResolver, String metaTemplateRef) {
        if (resourceResolver == null) {
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)metaTemplateRef)) {
            return false;
        }
        return resourceResolver.getResource(metaTemplateRef) != null;
    }

    public static String getMetaTemplateRef(Resource guideContainerResource) {
        ValueMap map;
        if (guideContainerResource != null && !GuideUtils.isGuideContainerResource(guideContainerResource)) {
            return "";
        }
        ValueMap guideContainerProperties = guideContainerResource.getValueMap();
        String metaTemplateRef = (String)guideContainerProperties.get("metaTemplateRef", (Object)"");
        Resource print = GuideUtils.getPrintNodeResource(guideContainerResource);
        if (print != null && (map = print.getValueMap()).containsKey((Object)"metaTemplateRef")) {
            metaTemplateRef = (String)map.get("metaTemplateRef", (Object)"");
        }
        return metaTemplateRef;
    }

    public static Resource getPrintNodeResource(Resource guideContainer) {
        return GuideUtils.isCoreComponentBasedForm(guideContainer) ? guideContainer.getChild("fd:view/print") : guideContainer.getChild("view/print");
    }

    public static boolean isCoreComponentBasedForm(Resource guideContainer) {
        return guideContainer != null && guideContainer.getValueMap() != null && GuideUtils.isCoreComponentBasedForm(guideContainer.getValueMap());
    }

    public static boolean isCoreComponentBasedForm(ValueMap propertiesMap) {
        return "2.1".equals(propertiesMap.get("fd:version", (Object)""));
    }

    public static boolean isGuideContainerResource(Resource resource) {
        return GuideWCMUtils.isGuideContainerResource(resource);
    }

    public static String translateOrReturnOriginal(String original, I18n i18n) {
        return GuideUtils.translateOrReturnOriginal(original, null, i18n, ValueMap.EMPTY);
    }

    public static boolean isCacheableContainerResource(Resource resource) {
        return GuideConstants.CACHEABLE_CONTAINER_RESOURCES.contains(resource.getResourceType());
    }

    public static boolean isV2GuideContainerResource(Resource resource) {
        return resource.isResourceType("core/fd/components/form/container/v2/container") || resource.isResourceType("core/fd/components/form/container/v1/container") || "form".equals(resource.getValueMap().get("fieldType", (Object)""));
    }

    public static boolean isTargetEnabled(Resource guideContainerResource) {
        ValueMap props = (ValueMap)guideContainerResource.getParent().adaptTo(ValueMap.class);
        return (Boolean)props.get("targetEnabled", (Object)false);
    }

    public static boolean isAdobeTargetConfigured(Resource resource) {
        HierarchyNodeInheritanceValueMap valueMap = new HierarchyNodeInheritanceValueMap(resource);
        Object cloudserviceConfigs = valueMap.getInherited("cq:cloudserviceconfigs", String[].class);
        if (cloudserviceConfigs != null) {
            for (String cloudserviceConfig : (String[])cloudserviceConfigs) {
                if (!cloudserviceConfig.startsWith("/etc/cloudservices/testandtarget")) continue;
                return true;
            }
        }
        return false;
    }

    public static String getAlternateContainerPathFromCurrentContainer(RequestPathInfo requestPathInfo) {
        String currentContainerPath = requestPathInfo.getResourcePath();
        String extension = null;
        if (currentContainerPath == null) {
            return null;
        }
        extension = requestPathInfo.getExtension();
        if (extension == null) {
            return currentContainerPath.substring(0, currentContainerPath.lastIndexOf("/")) + "/" + "guideContainer2";
        }
        return currentContainerPath.substring(0, currentContainerPath.lastIndexOf("/")) + "/" + "guideContainer2" + "." + extension;
    }

    public static List<AuthoringError> validateFormAuthoredState(GuideContainer guideContainer, String afInitializationState, I18n localI18n) {
        String aemWorkflowStr;
        int aemWorkflowIndex;
        Boolean hasDefaultCaptcha;
        Boolean isMinCountZero;
        Boolean hasAdobeSignBlockComponent;
        String errorMsg;
        Boolean hasVerifyComponent;
        String errorMsg2;
        ArrayList<AuthoringError> errorList = new ArrayList<AuthoringError>();
        if (!guideContainer.isSignatureConfiguredCorrectly()) {
            String errorMsg3 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_E_SIGN_0007"));
            errorList.add(new AuthoringError(errorMsg3, "MSG_E_SIGN_0007"));
        }
        String xdpRef = guideContainer.getXdpRef();
        String dorTemplateRef = guideContainer.getDorTemplateRef();
        int esignNodeClassIndex = afInitializationState.indexOf("\"guideNodeClass\\\":\\\"esign\\\"");
        if (esignNodeClassIndex > 0) {
            String errorMsg4;
            int beginIndex = afInitializationState.substring(0, esignNodeClassIndex).lastIndexOf("{");
            String signatureStepJsonStr = afInitializationState.substring(beginIndex, afInitializationState.indexOf("}", beginIndex) + 1);
            Boolean isEchoSignService = signatureStepJsonStr.contains("\"signingService\\\":\\\"echosign\\\"");
            if (signatureStepJsonStr.contains("\"fd:targetVersion\\\":\\\"1.1\\\"") && isEchoSignService.booleanValue()) {
                if (!guideContainer.isAdobeSignEnabled()) {
                    errorMsg4 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_E_SIGN_0001"));
                    errorList.add(new AuthoringError(errorMsg4, "MSG_E_SIGN_0001"));
                } else if (!guideContainer.isFormFillerFirstSigner()) {
                    errorMsg4 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_E_SIGN_0002"));
                    errorList.add(new AuthoringError(errorMsg4, "MSG_E_SIGN_0002"));
                }
            } else if (guideContainer.isAdobeSignEnabled() && isEchoSignService.booleanValue()) {
                errorMsg4 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_E_SIGN_0003"));
                errorList.add(new AuthoringError(errorMsg4, "MSG_E_SIGN_0003"));
            }
        }
        Boolean isXDPBased = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)xdpRef);
        Boolean isDorConfigured = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dorTemplateRef);
        Boolean canAfProduceDor = isXDPBased != false || isDorConfigured != false;
        Boolean isDorAutogenerate = "generate".equals(guideContainer.getDoRType());
        if (guideContainer.isAdobeSignEnabled() && !canAfProduceDor.booleanValue()) {
            errorMsg2 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_E_SIGN_0004"));
            errorList.add(new AuthoringError(errorMsg2, "MSG_E_SIGN_0004"));
        }
        if (esignNodeClassIndex > 0 && !canAfProduceDor.booleanValue()) {
            errorMsg2 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_E_SIGN_0005"));
            errorList.add(new AuthoringError(errorMsg2, "MSG_E_SIGN_0005"));
        }
        if ((hasVerifyComponent = Boolean.valueOf(afInitializationState.contains("\"guideNodeClass\\\":\\\"verify\\\""))).booleanValue() && isDorConfigured.booleanValue() && dorTemplateRef.contains(".pdf")) {
            errorMsg = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_VERIFY_STEP_0003"));
            errorList.add(new AuthoringError(errorMsg, "MSG_VERIFY_STEP_0003"));
        }
        if (hasVerifyComponent.booleanValue() && !canAfProduceDor.booleanValue()) {
            errorMsg = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_VERIFY_STEP_0002"));
            errorList.add(new AuthoringError(errorMsg, "MSG_VERIFY_STEP_0002"));
        }
        if ((hasAdobeSignBlockComponent = Boolean.valueOf(afInitializationState.contains("\"guideNodeClass\\\":\\\"guideAdobeSignBlock\\\""))).booleanValue() && !isDorAutogenerate.booleanValue()) {
            String errorMsg5 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_E_SIGN_0006"));
            errorList.add(new AuthoringError(errorMsg5, "MSG_E_SIGN_0006"));
        }
        if ((isMinCountZero = Boolean.valueOf(afInitializationState.contains("\\\"minOccur\\\":\\\"0\\\""))).booleanValue() && hasVerifyComponent.booleanValue()) {
            String errorMsg6 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_VERIFY_STEP_0001"));
            errorList.add(new AuthoringError(errorMsg6, "MSG_VERIFY_STEP_0001"));
        }
        if ((hasDefaultCaptcha = Boolean.valueOf(afInitializationState.contains("\"captchaService\\\":\\\"afcaptcha\\\""))).booleanValue()) {
            String errorMsg7 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_DEFAULT_CAPTCHA_0001"));
            errorList.add(new AuthoringError(errorMsg7, "MSG_DEFAULT_CAPTCHA_0001"));
        }
        if ((aemWorkflowIndex = afInitializationState.indexOf(aemWorkflowStr = "\"aemWorkflowId\\\":")) > -1) {
            String errorMsg8 = localI18n.getVar(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_FLAMINGO_0001"));
            int aemWorkflowEndIndex = afInitializationState.indexOf(125, aemWorkflowIndex) + 1;
            String workflowIdsStr = afInitializationState.substring(aemWorkflowIndex + 2 + aemWorkflowStr.length(), aemWorkflowEndIndex);
            try {
                Gson gson = new Gson();
                Map workflowIdMap = (Map)gson.fromJson(StringEscapeUtils.unescapeJava((String)workflowIdsStr).replace("\\\"", "'"), Map.class);
                for (Map.Entry entry : workflowIdMap.entrySet()) {
                    String workFlowId = (String)entry.getValue();
                    errorMsg8 = org.apache.commons.lang3.StringUtils.join((Object[])new String[]{errorMsg8, "<br/><a href=\\\"" + workFlowId + "\\\">" + (String)entry.getKey() + "</a>"});
                }
            }
            catch (Exception e) {
                logger.error("Error while fetching workflow id for smart forms", (Throwable)e);
            }
            errorList.add(new AuthoringError(errorMsg8, "MSG_FLAMINGO_0001", AuthoringError.ErrorType.Info));
        }
        return errorList;
    }

    public static boolean isDorTemplateRefValid(Resource guideContainer) {
        if (guideContainer == null) {
            return false;
        }
        GuideContainer guideContainerBean = GuideContainer.from(guideContainer);
        ValueMap guideContainerProps = (ValueMap)guideContainerBean.getResource().adaptTo(ValueMap.class);
        String xsdRef = GuideSchemaType.XSD.equals((Object)guideContainerBean.getSchema()) ? guideContainerBean.getSchemaRef() : null;
        String dorTemplateRef = null;
        if (xsdRef == null || xsdRef.length() == 0) {
            return false;
        }
        dorTemplateRef = (String)guideContainerProps.get("dorTemplateRef", null);
        if (dorTemplateRef != null) {
            boolean isValid = true;
            try {
                isValid = guideContainer.getResourceResolver().getResource(dorTemplateRef) != null;
            }
            catch (SlingException ex) {
                isValid = false;
                logger.error("DOR Template present in XDP is either set to null or is relative" + ex.getMessage(), (Throwable)ex);
            }
            return isValid;
        }
        return false;
    }

    public static String getXFALocale(String locale) {
        String xfaLocale = locale;
        for (int i = 0; i < GuideConstants.AEM_SUPPORTED_LOCALES.length; ++i) {
            if (!GuideConstants.AEM_SUPPORTED_LOCALES[i].equals(locale)) continue;
            xfaLocale = GuideConstants.AEM_XFA_SUPPORTED_LOCALES[i];
            break;
        }
        return xfaLocale;
    }

    public static String getGuideRuntimeLocale(SlingHttpServletRequest slingRequest, Resource resource) {
        int index = 0;
        String[] GUIDES_SUPPORTED_CLIENTLIBS = GuideConstants.GUIDES_SUPPORTED_CLIENTLIBS;
        String[] supportedLocales = GuideConstants.AEM_SUPPORTED_LOCALES;
        if (resource != null && slingRequest != null) {
            Locale authoringLocale;
            SlingBindings bindings = (SlingBindings)slingRequest.getAttribute(SlingBindings.class.getName());
            if (bindings != null) {
                GuideLocalizationService guideLocalizationService = (GuideLocalizationService)bindings.getSling().getService(GuideLocalizationService.class);
                supportedLocales = guideLocalizationService.getSupportedLocales();
                GUIDES_SUPPORTED_CLIENTLIBS = GuideUtils.sanitizeLocaleList(supportedLocales);
            }
            String locale = GuideUtils.getLocale(slingRequest, resource);
            index = Arrays.asList(GUIDES_SUPPORTED_CLIENTLIBS).indexOf(locale);
            if (index == -1 && (authoringLocale = slingRequest.getLocale()) != null) {
                index = Arrays.asList(GUIDES_SUPPORTED_CLIENTLIBS).indexOf(authoringLocale.toString());
            }
            if (index == -1) {
                index = 0;
            }
        }
        return supportedLocales[index];
    }

    public static Calendar getCurrentLMT(Resource containerResource, StaleAssetIndicatorService staleAssetIndicatorService) {
        Calendar calendar = Calendar.getInstance();
        if (staleAssetIndicatorService != null) {
            long currentLMT = staleAssetIndicatorService.getAssetTreeLMT(containerResource);
            calendar.setTimeInMillis(currentLMT);
        } else {
            logger.info("staleAssetIndicatorService not available : Guide Json cache miss");
            calendar.setTimeInMillis(Long.MAX_VALUE);
        }
        return calendar;
    }

    public static String getAcceptLang(SlingHttpServletRequest request) {
        if (request == null) {
            return "en";
        }
        String language = null;
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        String afLang = GuideUtils.getLocaleParamFromRequest(request);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)afLang)) {
            language = GuideUtils.getAcceptLang(afLang, bindings);
        }
        return org.apache.commons.lang3.StringUtils.isEmpty(language) ? GuideUtils.getDefaultLocale(request) : language;
    }

    private static String getDefaultLocale(SlingHttpServletRequest request) {
        try {
            Resource guideContainerResource;
            ResourceResolver guideResourceResolver;
            String path;
            Resource resource = request.getResource();
            if (resource != null && (path = GuideUtils.getGuideContainerPath(request, resource)) != null && !path.isEmpty() && (guideResourceResolver = request.getResourceResolver()) != null && (guideContainerResource = guideResourceResolver.getResource(path)) != null) {
                return GuideUtils.getDefaultLocale(guideContainerResource);
            }
        }
        catch (Exception e) {
            logger.error("Guide Resource not found", (Throwable)e);
        }
        return "en";
    }

    private static String getAcceptLang(String locale, SlingBindings bindings) {
        String acceptLang = locale;
        if (bindings != null) {
            GuideLocalizationService guideLocalizationService = (GuideLocalizationService)bindings.getSling().getService(GuideLocalizationService.class);
            String[] supportedLocales = guideLocalizationService.getSupportedLocales();
            String[] supportedLocalesSanitized = GuideUtils.sanitizeLocaleList(supportedLocales);
            String[] locales = org.apache.commons.lang3.StringUtils.split((String)acceptLang, (String)",");
            for (int i = 0; i < locales.length; ++i) {
                int index;
                String localeCode = org.apache.commons.lang3.StringUtils.substringBefore((String)locales[i], (String)";");
                String[] splitLocale = org.apache.commons.lang3.StringUtils.split((String)localeCode, (String)"-");
                localeCode = splitLocale[0].toLowerCase();
                if (splitLocale.length > 1) {
                    localeCode = localeCode + splitLocale[1].toUpperCase();
                }
                if ((index = Arrays.asList(supportedLocalesSanitized).indexOf(localeCode)) != -1) {
                    acceptLang = supportedLocales[index];
                    return acceptLang;
                }
                if (splitLocale.length <= 1 || (index = Arrays.asList(supportedLocalesSanitized).indexOf(splitLocale[0].toLowerCase())) == -1) continue;
                acceptLang = supportedLocales[index];
                return acceptLang;
            }
            return null;
        }
        return locale;
    }

    public static void visitToCollectProperties(JSONObject guideTypeJsonObject, String toCheck, String keyToPut, String valueToPut, JSONArray collection) {
        try {
            if (guideTypeJsonObject.has(toCheck)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((String)guideTypeJsonObject.get(keyToPut), guideTypeJsonObject.get(valueToPut));
                collection.put((Object)jsonObject);
            }
            if (guideTypeJsonObject.has("items")) {
                JSONObject items = (JSONObject)guideTypeJsonObject.get("items");
                Iterator childKeys = items.keys();
                while (childKeys.hasNext()) {
                    GuideUtils.visitToCollectProperties((JSONObject)items.get((String)childKeys.next()), toCheck, keyToPut, valueToPut, collection);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in visting XML Schema", (Throwable)e);
        }
    }

    public static ResourceBundle getResourceBundle(SlingHttpServletRequest request, Resource guideContainerResource, Locale desiredLocale) {
        String guideContainerPath = GuideUtils.getGuideContainerPath(request, guideContainerResource);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)guideContainerPath)) {
            guideContainerPath = GuideUtils.getGuideContainerPathFromResource(request, guideContainerResource);
        }
        String baseName = TranslationUtils.getDictionaryPath(request.getResourceResolver(), guideContainerPath);
        Resource baseResource = request.getResourceResolver().getResource(baseName);
        if (GuideUtils.isDesiredLocaleDictPresent(baseResource, desiredLocale).booleanValue()) {
            return request.getResourceBundle(baseName, desiredLocale);
        }
        return null;
    }

    public static Boolean isDesiredLocaleDictPresent(Resource baseResource, Locale desiredLocale) {
        if (baseResource != null) {
            for (Resource childResource : baseResource.getChildren()) {
                String lang = (String)childResource.getValueMap().get("jcr:language", null);
                String desiredLocaleString = org.apache.commons.lang3.StringUtils.replace((String)desiredLocale.toString().toLowerCase(), (String)"_", (String)"-");
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)desiredLocaleString, (CharSequence)lang) && !org.apache.commons.lang3.StringUtils.startsWith((CharSequence)lang, (CharSequence)desiredLocaleString)) continue;
                return true;
            }
        }
        return false;
    }

    public static I18n getI18nForDesiredLocale(SlingHttpServletRequest request, Resource guideContainerResource, Locale desiredLocale) {
        ResourceBundle resourceBundle;
        if (desiredLocale == null) {
            desiredLocale = request.getLocale();
        }
        if (guideContainerResource != null && request != null && (resourceBundle = GuideUtils.getResourceBundle(request, guideContainerResource, desiredLocale)) != null) {
            return new I18n(resourceBundle);
        }
        return null;
    }

    public static int getLocaleIndexFromLocale(String locale, String[] AEM_SUPPORTED_LOCALES) {
        String[] GUIDES_SUPPORTED_CLIENTLIBS = GuideUtils.sanitizeLocaleList(AEM_SUPPORTED_LOCALES);
        int index = Arrays.asList(GUIDES_SUPPORTED_CLIENTLIBS).indexOf(locale);
        if (index == -1) {
            index = 0;
        }
        return index;
    }

    public static String[] sanitizeLocaleList(String[] locales) {
        String[] sanitizedLocales = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            String localeCode = locales[i];
            String[] splitLocale = org.apache.commons.lang3.StringUtils.split((String)localeCode, (String)"-");
            localeCode = splitLocale[0].toLowerCase();
            if (splitLocale.length > 1) {
                localeCode = localeCode + splitLocale[1].toUpperCase();
            }
            sanitizedLocales[i] = localeCode;
        }
        return sanitizedLocales;
    }

    public static String getInheritedProperty(Resource resource, String propertyName) {
        PageManager pageManager;
        ResourceResolver resourceResolver;
        String retVal = null;
        if (resource != null && (resourceResolver = resource.getResourceResolver()) != null && (pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class)) != null) {
            Page page = pageManager.getContainingPage(resource);
            retVal = WCMUtils.getInheritedProperty((Page)page, (ResourceResolver)resourceResolver, (String)propertyName);
        }
        return retVal;
    }

    public static Session getUserSessionFromRequest(SlingHttpServletRequest slingHttpServletRequest) {
        return (Session)slingHttpServletRequest.getResourceResolver().adaptTo(Session.class);
    }

    public static String getLanguageDirection(String language) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)language) && GuideUtils.isLangRTL(language)) {
            return RIGHT_LANG_DIRECTION;
        }
        return LEFT_LANG_DIRECTION;
    }

    public static boolean isLangRTL(String language) {
        return Arrays.stream(new String[]{"ar", "iw", "he", "fa", "ur", "ug", "ji", "yi"}).anyMatch(lang -> lang.equalsIgnoreCase(language.split("-|_")[0]));
    }

    public static SlingHttpServletResponse processInternalPostOnRestEndPoint(SlingHttpServletRequest request, SlingHttpServletResponse response, String postUrl) {
        CustomParameterRequest wrappedRequest = null;
        CustomResponse wrappedResponse = null;
        try {
            ParameterMap wrappedParameterMap = GuideUtils.prepareWrappedRequestWithDataXMLAndAttachments(request);
            wrappedRequest = new CustomParameterRequest(request, wrappedParameterMap, "POST");
            wrappedResponse = new CustomResponse(response);
            request.getRequestDispatcher(postUrl).forward((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        catch (Exception e) {
            logger.error("Some Problem While Posting to rest End Point", (Throwable)e);
        }
        return wrappedResponse;
    }

    public static void addToRequestMap(ParameterMap requestParameterMap, String key, RequestParameter[] requestParameter) {
        requestParameterMap.put((Object)key, (Object)requestParameter);
    }

    public static List getFileAttachmentList(SlingHttpServletRequest request, String guideContainerPath) {
        ResourceResolver resourceResolver;
        Resource formContainerResource;
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        GuideModelTransformer guideModelTransformer = (GuideModelTransformer)bindings.getSling().getService(GuideModelTransformer.class);
        List<Object> fileAttachments = new ArrayList();
        if (guideModelTransformer != null && (formContainerResource = (resourceResolver = request.getResourceResolver()).getResource(guideContainerPath)) != null) {
            JSONObject guideJson;
            String locale = request.getParameter("runtimeLocale");
            if (locale == null || locale.isEmpty()) {
                locale = "en";
            }
            String guideJsonString = (guideJson = guideModelTransformer.exportGuideJsonObject(formContainerResource, null, new Locale(locale))) != null ? guideJson.toString() : "";
            fileAttachments = GuideUtils.getFileAttachmentList(guideJsonString);
        }
        return fileAttachments;
    }

    public static List<JSONObject> getFileAttachmentList(@Nonnull String guideJsonString) {
        List<Object> fileAttachmentList = new ArrayList<JSONObject>();
        try {
            fileAttachmentList = (List)AdaptiveFormUtil.getComponentsFromAFTemplateJson((String)guideJsonString, (String)"guideFileUpload", new ArrayList());
        }
        catch (GuideException ex) {
            logger.error("[AF] Unable to parse json while getting file attachment list", (Throwable)ex);
        }
        return fileAttachmentList;
    }

    public static ParameterMap prepareWrappedRequestWithDataXMLAndAttachments(SlingHttpServletRequest request) {
        ParameterMap wrappedParameterMap = new ParameterMap();
        RequestParameterMap originalParams = request.getRequestParameterMap();
        ArrayList<FileAttachmentWrapper> fileAttachments = new ArrayList<FileAttachmentWrapper>();
        try {
            for (Map.Entry param : originalParams.entrySet()) {
                RequestParameter[] rpm = (RequestParameter[])param.getValue();
                if (rpm != null && rpm.length > 0 && !rpm[0].isFormField()) {
                    FileAttachmentWrapper fileAttachment = new FileAttachmentWrapper(rpm[0].getFileName(), rpm[0].getContentType(), rpm[0].get());
                    fileAttachments.add(fileAttachment);
                }
                if (!defaultAEMRequestParameters.matcher((CharSequence)param.getKey()).matches()) continue;
                wrappedParameterMap.put(param.getKey(), param.getValue());
            }
            if (fileAttachments.size() > 0) {
                RequestParameter[] attachments = new RequestParameter[fileAttachments.size()];
                int index = 0;
                for (FileAttachmentWrapper fileAttachment : fileAttachments) {
                    attachments[index++] = new FileRequestParameter(fileAttachment.getFileName(), IOUtils.toByteArray((InputStream)fileAttachment.getInputStream()), fileAttachment.getContentType());
                }
                GuideUtils.addToRequestMap(wrappedParameterMap, "attachments", attachments);
            }
            GuideUtils.addToRequestMap(wrappedParameterMap, "dataXml", originalParams.getValues("jcr:data"));
        }
        catch (Exception e) {
            logger.error("Not Able to make internal post req parameter", (Throwable)e);
        }
        return wrappedParameterMap;
    }

    public static String getFieldLayout(Resource guideContainerResource, String propertyName, String defaultValue) {
        String fieldLayout = defaultValue;
        if (guideContainerResource != null) {
            ValueMap properties = (ValueMap)guideContainerResource.adaptTo(ValueMap.class);
            fieldLayout = (String)properties.get(propertyName, (Object)defaultValue);
        }
        return fieldLayout;
    }

    public static boolean setEmbedFragButton(String title, EditContext editContext, SlingHttpServletRequest request, String fragRef, String currentPanelPath, String bindRef) {
        if (editContext != null) {
            Toolbar tb;
            EditConfig editConfig = editContext.getEditConfig();
            XSSAPI xssapi = (XSSAPI)request.adaptTo(XSSAPI.class);
            if (editConfig != null && (tb = editConfig.getToolbar()) != null) {
                if (title != null) {
                    tb.add((Toolbar.Item)new Toolbar.Separator());
                    fragRef = org.apache.commons.lang3.StringUtils.replace((String)fragRef, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1);
                    String handler = "function(){guidelib.author.editConfigListeners.embedFragment(\"" + fragRef + "\", \"" + currentPanelPath + "\" ,\"" + bindRef + "\");}";
                    tb.add((Toolbar.Item)new Toolbar.Button(title, handler));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean setButtonForPanel(String title, EditContext editContext, SlingHttpServletRequest request, String currentPanelPath, String bindRef, String handler) {
        return GuideUtils.setButtonForPanel(title, editContext, request, currentPanelPath, bindRef, handler, null);
    }

    public static boolean setButtonForPanel(String title, EditContext editContext, SlingHttpServletRequest request, String currentPanelPath, String bindRef, String handler, Integer index) {
        Toolbar tb;
        EditConfig editConfig;
        if (editContext != null && (editConfig = editContext.getEditConfig()) != null && (tb = editConfig.getToolbar()) != null) {
            if (index == null) {
                index = tb.size();
            }
            if (title != null) {
                tb.add(index.intValue(), (Toolbar.Item)new Toolbar.Separator());
                tb.add(index + 1, (Toolbar.Item)new Toolbar.Button(title, handler));
            }
            return true;
        }
        return false;
    }

    public static void putQueryParamsToRedirectRequest(String responseString, Map<String, String> redirectParameters) {
        try {
            String[] pairs = responseString.split("&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] fields = pairs[i].split("=");
                if (fields.length != 2) continue;
                String name = URLDecoder.decode(fields[0].trim(), "UTF-8");
                String value = URLDecoder.decode(fields[1].trim(), "UTF-8");
                redirectParameters.put(name, value);
            }
        }
        catch (Exception e) {
            logger.error("Error while putting params to redirect Request", (Throwable)e);
        }
    }

    public static double parseSize(String size) {
        if (size.indexOf("in") >= 0 || size.indexOf("mm") >= 0 || size.indexOf("cm") >= 0 || size.indexOf("pt") >= 0 || size.indexOf("px") >= 0) {
            return Double.parseDouble(size.substring(0, size.length() - 2));
        }
        return 1.0;
    }

    public static JSONObject trimLazyChildren(String guideJsonString) {
        JSONObject trimmedGuideJson = null;
        try {
            trimmedGuideJson = new JSONObject(guideJsonString);
            GuideUtils.trimJsonOfLazyInstances(trimmedGuideJson);
        }
        catch (Exception e) {
            logger.error("Could not trim children", (Throwable)e);
        }
        return trimmedGuideJson;
    }

    private static void trimJsonOfLazyInstances(JSONObject jsonObject) {
        try {
            if (jsonObject.has("optimizeRenderPerformance")) {
                if (jsonObject.has("items")) {
                    jsonObject.remove("items");
                }
            } else if (jsonObject.has("rootPanel")) {
                GuideUtils.trimJsonOfLazyInstances(jsonObject.getJSONObject("rootPanel"));
            } else if (jsonObject.has("items")) {
                JSONObject itemsNode = jsonObject.getJSONObject("items");
                Iterator keys = itemsNode.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONObject childItem = itemsNode.getJSONObject(key);
                    GuideUtils.trimJsonOfLazyInstances(childItem);
                }
            }
        }
        catch (Exception e) {
            logger.error("Some exception while removing on demand children", (Throwable)e);
        }
    }

    public static String findJsonObjectWithProperty(JSONObject jsonObject, String propertyName, String propertyValue, String path, boolean ignorePath) {
        String stringifiedResult;
        block7: {
            stringifiedResult = "";
            try {
                if (jsonObject.has(propertyName) && propertyValue.equals(jsonObject.getString(propertyName)) && (ignorePath || path.equals(jsonObject.get("jcr:path")))) {
                    JSONObject itemsNode = jsonObject.getJSONObject("items");
                    Iterator keys = itemsNode.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        JSONObject childItem = itemsNode.getJSONObject(key);
                        GuideUtils.trimJsonOfLazyInstances(childItem);
                    }
                    return jsonObject.toString();
                }
                if (jsonObject.has("rootPanel")) {
                    return GuideUtils.findJsonObjectWithProperty(jsonObject.getJSONObject("rootPanel"), propertyName, propertyValue, path, ignorePath);
                }
                if (jsonObject.has("items")) {
                    JSONObject itemsNode = jsonObject.getJSONObject("items");
                    Iterator keys = itemsNode.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        JSONObject childItem = itemsNode.getJSONObject(key);
                        stringifiedResult = stringifiedResult + GuideUtils.findJsonObjectWithProperty(childItem, propertyName, propertyValue, path, ignorePath);
                    }
                    break block7;
                }
                return "";
            }
            catch (Exception e) {
                logger.error("Error while fetching json for " + propertyValue, (Throwable)e);
            }
        }
        return stringifiedResult;
    }

    public static String findJsonObjectWithProperty(JSONObject jsonObject, String propertyName, String propertyValue, String path) {
        return GuideUtils.findJsonObjectWithProperty(jsonObject, propertyName, propertyValue, path, Boolean.FALSE);
    }

    public static String getAssetHTMLFromFullHTML(String templateId, String html) {
        return GuideHTMLParser.getAssetHTMLFromFullHTML(html, templateId);
    }

    public static String formJsonHtmlString(String json, String html, String multipleJson) {
        StringWriter stringWriter = new StringWriter();
        CustomJSONWriter jsonWriter = new CustomJSONWriter(stringWriter);
        jsonWriter.object();
        jsonWriter.key("json").value(json);
        jsonWriter.key("html").value(html);
        jsonWriter.key("multipleJson").value(multipleJson);
        jsonWriter.endObject();
        return stringWriter.toString();
    }

    public static String getLayoutScriptFromContainer(GuideContainer guideContainer) {
        String script = guideContainer.getLayout();
        Resource scriptResource = GuideUtils.getResolverFromResource(guideContainer).getResource(script);
        String scriptPath = scriptResource != null ? scriptResource.getPath() : "/libs/" + script;
        script = scriptPath + "/" + org.apache.commons.lang3.StringUtils.substringAfterLast((String)script, (String)"/") + ".jsp";
        return script;
    }

    public static String produceHTML(GuideContainer guideContainer, SlingHttpServletResponse slingHttpServletResponse) {
        String script = GuideUtils.getLayoutScriptFromContainer(guideContainer);
        SlingHttpServletRequest slingRequest = guideContainer.getSlingRequest();
        try {
            String guideContainerPath = guideContainer.getPath();
            String urlToRootPanel = guideContainerPath + "/" + "rootPanel" + "." + "html";
            RequestDispatcher dispatcher = slingRequest.getRequestDispatcher(urlToRootPanel);
            WCMMode.DISABLED.toRequest((ServletRequest)slingRequest);
            GuideStringWriterResponse responseWrapper = new GuideStringWriterResponse(slingHttpServletResponse);
            dispatcher.include((ServletRequest)new SlingHttpServletRequestWrapper(slingRequest), (ServletResponse)responseWrapper);
            return responseWrapper.getString();
        }
        catch (Exception e) {
            logger.error("Error while executing script " + script, (Throwable)e);
            return null;
        }
    }

    public static String getJsonForGivenTemplateId(JSONObject guideJsonObject, String templateId) {
        String retVal = null;
        try {
            JSONObject newGuideJsonObject = new JSONObject(guideJsonObject.toString());
            retVal = GuideUtils.findJsonObjectWithProperty(newGuideJsonObject, "templateId", templateId, "", Boolean.TRUE);
        }
        catch (Exception e) {
            logger.error("[AF] Could not find json for given template id {}", (Object)templateId, (Object)e);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptAsStringFromClientLib(HtmlLibraryManager htmlLibraryManager, String clientLibPath, boolean minify) {
        StringWriter writer = new StringWriter();
        InputStream inputStream = null;
        try {
            HtmlLibrary htmlLibrary = htmlLibraryManager.getLibrary(LibraryType.JS, clientLibPath);
            if (htmlLibrary != null) {
                inputStream = htmlLibrary.getInputStream(minify);
                IOUtils.copy((InputStream)inputStream, (Writer)writer);
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return writer.toString();
    }

    public static ArrayList<String> getScriptFromClientLibList(HtmlLibraryManager htmlLibraryManager, String[] clientLibCategories, boolean minify) {
        Collection clientLibrary = htmlLibraryManager.getLibraries(clientLibCategories, null, true, false);
        ArrayList<String> script = new ArrayList<String>();
        Iterator iter = clientLibrary.iterator();
        while (iter.hasNext()) {
            String path = ((ClientLibrary)iter.next()).getPath();
            script.add(GuideUtils.getScriptAsStringFromClientLib(htmlLibraryManager, path, minify));
        }
        return script;
    }

    public static JSONObject getDictionaryInfoFromAssetPaths(JSONArray assetList, List<String> locales, ResourceResolver resourceResolver) {
        JSONObject dictionaryInfo = new JSONObject();
        JSONArray dictInfoArray = new JSONArray();
        try {
            for (String locale : locales) {
                JSONObject localeObject = new JSONObject();
                localeObject.put("lang", (Object)locale);
                JSONArray pathArray = new JSONArray();
                for (int index = 0; index < assetList.length(); ++index) {
                    String path = assetList.getString(index);
                    String convertedPath = GuideUtils.convertContainerPathToDictionaryPath(path, locale, resourceResolver);
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)convertedPath)) continue;
                    pathArray.put((Object)convertedPath);
                }
                localeObject.put("dicts", (Object)pathArray);
                dictInfoArray.put((Object)localeObject);
            }
            dictionaryInfo.put("languages", (Object)dictInfoArray);
        }
        catch (Exception e) {
            logger.error("Could not create dictionary paths", (Throwable)e);
        }
        return dictionaryInfo;
    }

    private static String convertContainerPathToDictionaryPath(String containerPath, String locale, ResourceResolver resourceResolver) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)containerPath) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)locale)) {
            return TranslationUtils.getDictionaryPath(resourceResolver, containerPath) + "/" + locale;
        }
        return null;
    }

    public static String getDefaultPattern(String componentType) {
        if (componentType.equals("guideEmail")) {
            return "^[a-zA-Z0-9.!#$%&\u2019*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)*$";
        }
        return "";
    }

    public static JSONObject getCCRData(String jsonData) throws JSONException {
        JSONObject submissionInfoRoot;
        JSONObject jsonRoot;
        JSONObject jsonDataObj;
        if (jsonData != null && jsonData.length() > 0 && (jsonDataObj = new JSONObject(jsonData)).has("afData") && (jsonRoot = jsonDataObj.optJSONObject("afData")).has("afSubmissionInfo") && (submissionInfoRoot = jsonRoot.optJSONObject("afSubmissionInfo")).has("icc:data")) {
            JSONObject iccData = submissionInfoRoot.optJSONObject("icc:data");
            return iccData;
        }
        return null;
    }

    public static Boolean listContains(List<String> list, String searchString, Boolean ignoreCase) {
        if (searchString != null && list != null) {
            if (!ignoreCase.booleanValue()) {
                return list.contains(searchString);
            }
            for (String str : list) {
                if (!searchString.equalsIgnoreCase(str)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static SlingBindings getSlingBinding(SlingHttpServletRequest slingRequest) {
        SlingBindings bindings = null;
        if (slingRequest != null) {
            bindings = (SlingBindings)slingRequest.getAttribute(SlingBindings.class.getName());
        }
        return bindings;
    }

    public static boolean checkIfForms(Resource resource) {
        return GuideUtils.checkIfForms(resource, false);
    }

    public static boolean checkIfForms(Resource resource, boolean isV2) {
        Resource pageContent = resource.getChild("jcr:content");
        if (pageContent != null) {
            Resource guideContainer = pageContent.getChild("guideContainer");
            if (guideContainer != null) {
                Resource guideContainerMergedResource = (Resource)guideContainer.adaptTo(TemplatedResource.class);
                if (guideContainerMergedResource == null) {
                    guideContainerMergedResource = guideContainer;
                } else {
                    logger.warn("GuideContainer resource has been locked in the editable template for the form - " + resource.getPath());
                }
                return isV2 ? GuideUtils.isV2GuideContainerResource(guideContainerMergedResource) : GuideUtils.isGuideContainerResource(guideContainerMergedResource);
            }
            Page currentPage = (Page)resource.adaptTo(Page.class);
            if (currentPage != null) {
                Template template = currentPage.getTemplate();
                if (template == null) {
                    return false;
                }
                if (template.hasStructureSupport()) {
                    Resource res = (Resource)pageContent.adaptTo(TemplatedResource.class);
                    if (res == null) {
                        return false;
                    }
                    Iterator it = res.listChildren();
                    while (it.hasNext()) {
                        Resource child = (Resource)it.next();
                        String name = child.getName();
                        if (!"guideContainer".equals(name)) continue;
                        logger.warn("GuideContainer resource has been locked in the editable template for the form - " + resource.getPath());
                        return isV2 ? GuideUtils.isV2GuideContainerResource(child) : GuideUtils.isGuideContainerResource(child);
                    }
                }
            }
        }
        return false;
    }

    public static Resource getMergedFormResource(ResourceResolver resolver, String formPath) {
        Resource formResource = resolver.resolve(formPath);
        if (ResourceUtil.isNonExistingResource((Resource)formResource)) {
            return null;
        }
        if (!GuideUtils.checkIfForms(formResource)) {
            return null;
        }
        Page currentPage = (Page)formResource.adaptTo(Page.class);
        if (currentPage == null) {
            return formResource;
        }
        Template template = currentPage.getTemplate();
        if (template != null && template.hasStructureSupport()) {
            formResource = (Resource)formResource.adaptTo(TemplatedResource.class);
        }
        return formResource;
    }

    public static boolean checkIfFormsTemplate(Resource resource) {
        return GuideUtils.checkIfFormsTemplate(resource, false);
    }

    public static boolean checkIfFormsTemplate(Resource resource, boolean checkIfV2) {
        Resource templateContent = resource.getChild("jcr:content");
        if (templateContent != null) {
            ValueMap templateGuideContainerValueMap;
            String guideContainerVersion;
            Resource templateGuideContainer;
            ValueMap templateContentValueMap = templateContent.getValueMap();
            String guideComponentType = (String)templateContentValueMap.get("guideComponentType", (Object)"");
            if (!checkIfV2 ? guideComponentType != null && guideComponentType.length() > 0 : (templateGuideContainer = templateContent.getChild("guideContainer")) != null && "2.1".equals(guideContainerVersion = (String)(templateGuideContainerValueMap = templateGuideContainer.getValueMap()).get("fd:version", (Object)""))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRepeatable(JSONObject obj) {
        int maxOccur = obj.optInt("maxOccur", 1);
        int minOccur = obj.optInt("minOccur", 1);
        return minOccur != 1 || maxOccur != 1;
    }

    public static boolean isCompositeField(JSONObject obj) {
        String objType = obj.optString("guideNodeClass", "");
        return GuideConstants.GUIDE_COMPOSITE_FIELD_TYPES.contains(objType);
    }

    public static boolean isSubmitableField(JSONObject obj) {
        String objType = obj.optString("guideNodeClass", "");
        return GuideConstants.GUIDE_SUBMITABLE_FIELD_TYPES.contains(objType);
    }

    public static boolean isStaticTextType(String type) {
        return "guideTextDraw".equals(type) || "guideAdobeSignBlock".equals(type);
    }

    public static boolean hasFloatingField(JSONObject obj) {
        JSONArray documentFragmentVariables;
        Boolean isFloatingField = Boolean.FALSE;
        String objType = obj.optString("guideNodeClass", "");
        if (GuideUtils.isStaticTextType(objType) && (documentFragmentVariables = obj.optJSONArray("documentFragmentVariables")) != null && documentFragmentVariables.length() > 0) {
            isFloatingField = Boolean.TRUE;
        }
        return isFloatingField;
    }

    public static Boolean isDeprecatedAD(Resource containerResource) {
        Boolean isDeprecatedAD = false;
        if (containerResource != null) {
            if (containerResource.isResourceType("fd/adaddon/components/guideDocumentContainer")) {
                isDeprecatedAD = true;
            } else if (containerResource.isResourceType("fd/ccm/web-channel/components/documentContainer/v1/documentContainer")) {
                isDeprecatedAD = false;
            }
        }
        return isDeprecatedAD;
    }

    public static FileAttachmentWrapper findFileAttachment(List<FileAttachmentWrapper> attachmentWrappers, String fileName) {
        if (attachmentWrappers != null) {
            for (FileAttachmentWrapper fileAttachmentWrapper : attachmentWrappers) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)fileAttachmentWrapper.getFileName(), (CharSequence)fileName)) continue;
                return fileAttachmentWrapper;
            }
        }
        return null;
    }

    public static Resource getFormResource(Resource otherResource, String fragRef) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fragRef) && otherResource != null) {
            String path = GuideUtils.convertFMAssetPathToContainerPath(fragRef);
            ResourceResolver resolver = otherResource.getResourceResolver();
            return resolver.getResource(path);
        }
        return null;
    }

    public static Resource getFormBreakpointResource(ResourceResolver resolver, String formPath) {
        Resource formResource = GuideUtils.getMergedFormResource(resolver, formPath);
        if (formResource == null) {
            return null;
        }
        if (formResource.getChild("jcr:content") == null) {
            return null;
        }
        Resource jcrResource = formResource.getChild("jcr:content");
        if (jcrResource == null) {
            return null;
        }
        Resource responsiveResource = jcrResource.getChild("cq:responsive");
        if (responsiveResource == null) {
            return null;
        }
        return responsiveResource.getChild("breakpoints");
    }

    public static JSONObject getFormJson(Resource formRes, GuideModelTransformer guideModelTransformer) {
        JSONObject guideJson = null;
        try {
            Locale defaultFallBackLocaleObject = new Locale("en");
            guideJson = guideModelTransformer.exportGuideJsonObject(formRes, null, defaultFallBackLocaleObject);
        }
        catch (GuideException e) {
            logger.error("Failed to Fetch Form Json", (Throwable)e);
        }
        return guideJson;
    }

    private static Resource findGuideContainerFromPage(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (GuideUtils.isGuideContainerResource(resource)) {
            return resource;
        }
        Resource r = null;
        Iterator t = resource.listChildren();
        while (t.hasNext() && r == null) {
            Resource child = (Resource)t.next();
            if (child != null && GuideUtils.isGuideContainerResource(resource)) {
                return child;
            }
            r = GuideUtils.findGuideContainerFromPage(child);
        }
        return r;
    }

    public static String getGuideContainerPathFromResource(SlingHttpServletRequest request, Resource resource) {
        String path = null;
        Resource pageResource = GuideUtils.getPageResource(resource);
        Resource guideContainer = GuideUtils.findGuideContainerFromPage(pageResource);
        if (guideContainer != null) {
            path = guideContainer.getPath();
        }
        return path;
    }

    public static boolean isUnboundObj(JSONObject obj) {
        String bindRef = obj.optString("bindRef");
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bindRef);
    }

    public static String getThemeContentRef(Resource guideContainerResource) {
        ValueMap vmap = guideContainerResource.getValueMap();
        String themeRef = (String)vmap.get("themeRef", String.class);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)themeRef)) {
            themeRef = themeRef + "/jcr:content";
        }
        return themeRef;
    }

    public static String getGuideName(Resource rsrc) throws GuideException {
        ValueMap properties = ResourceUtil.getValueMap((Resource)rsrc);
        String name = (String)properties.get("name", (Object)"");
        if (name == null || name.isEmpty()) {
            String resourceName = "";
            if (rsrc != null && rsrc.getName() != null) {
                resourceName = rsrc.getName();
                if (resourceName.startsWith("guide")) {
                    resourceName = resourceName.substring("guide".length());
                }
                resourceName = resourceName + Calendar.getInstance().getTimeInMillis();
            }
            GuideUtils.setGuideName(rsrc, resourceName);
            name = rsrc.getName();
        }
        return name;
    }

    private static void setGuideName(Resource rsrc, String name) throws GuideException {
        block5: {
            Session currentSession = (Session)rsrc.getResourceResolver().adaptTo(Session.class);
            try {
                if (currentSession.hasPermission(rsrc.getPath(), "set_property")) {
                    ModifiableValueMap modifiableMap = (ModifiableValueMap)rsrc.adaptTo(ModifiableValueMap.class);
                    modifiableMap.put((Object)"name", (Object)name);
                    try {
                        rsrc.getResourceResolver().commit();
                        break block5;
                    }
                    catch (PersistenceException e) {
                        logger.error("unable to set name property on " + rsrc.getPath(), (Throwable)e);
                        throw new GuideException((Exception)((Object)e));
                    }
                }
                logger.error("user has no write permission on the node " + rsrc.getPath() + ". Adaptive Form will not work properly");
            }
            catch (RepositoryException e) {
                logger.error("unable to check the permissions for setting property on " + rsrc.getPath(), (Throwable)e);
                throw new GuideException((Exception)((Object)e));
            }
        }
    }

    public static Resource getResource(ResourceResolver resourceResolver, String path, JSONObject json) {
        return GuideUtils.getResource(resourceResolver, path, json, null);
    }

    public static Resource getResource(ResourceResolver resourceResolver, String path, JSONObject json, Resource parentResource) {
        return GuideUtils.getResource(resourceResolver, path, json, parentResource, false);
    }

    public static Resource getResource(ResourceResolver resourceResolver, String path, JSONObject json, Resource parentResource, boolean useNameAsResourceIdentifier) {
        if (json == null) {
            return new GuideValueMapResource(resourceResolver, path, null, (ValueMap)new ValueMapDecorator(new HashMap()), parentResource);
        }
        String resourceType = "nt:unstructured";
        if (json.has("sling:resourceType")) {
            resourceType = json.optString("sling:resourceType");
        } else if (json.has("sling:resourceSuperType")) {
            resourceType = json.optString("sling:resourceSuperType");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ValueMapDecorator valueMap = new ValueMapDecorator(map);
        ArrayList<Resource> children = new ArrayList<Resource>();
        GuideValueMapResource valueMapResource = new GuideValueMapResource(resourceResolver, path, resourceType, (ValueMap)valueMap, children, parentResource);
        try {
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = json.get(key);
                if (value instanceof JSONObject) {
                    String name = null;
                    if (useNameAsResourceIdentifier) {
                        name = ((JSONObject)value).optString("name");
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name)) {
                            name = key;
                        }
                    } else {
                        name = key;
                    }
                    Resource child = GuideUtils.getResource(resourceResolver, path + "/" + name, (JSONObject)value, (Resource)valueMapResource, useNameAsResourceIdentifier);
                    children.add(child);
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < array.length(); ++i) {
                        list.add(array.get(i));
                    }
                    map.put(key, list.toArray());
                    continue;
                }
                map.put(key, value);
            }
        }
        catch (JSONException e) {
            logger.error("Exception while creating resource from JSON", (Throwable)e);
        }
        return valueMapResource;
    }

    public static Iterator<Resource> getResourceIterator(ResourceResolver resourceResolver, String path, Iterator<JSONObject> jsonObjectIterator) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        while (jsonObjectIterator.hasNext()) {
            JSONObject jsonObject = jsonObjectIterator.next();
            resourceList.add(GuideUtils.getResource(resourceResolver, path, jsonObject));
        }
        return resourceList.iterator();
    }

    public static void fillQueue(Queue<Resource> queue, Resource resource, String type) {
        ResourceResolver resourceResolver;
        Resource structureContent;
        Template template;
        if (resource == null) {
            return;
        }
        Page page = (Page)resource.getParent().adaptTo(Page.class);
        if (page != null && (template = page.getTemplate()) != null && template.hasStructureSupport() && (structureContent = (resourceResolver = resource.getResourceResolver()).getResource(template.getPath() + "/structure/jcr:content")) != null) {
            Iterator iterator = structureContent.listChildren();
            while (iterator.hasNext()) {
                Resource child = (Resource)iterator.next();
                if (child.isResourceType("fd/af/components/guideContainer")) continue;
                GuideUtils.fillQueue(queue, child, type);
            }
        }
        Iterator iterator = resource.listChildren();
        while (iterator.hasNext()) {
            Resource child = (Resource)iterator.next();
            if (child.isResourceType("fd/af/components/guideheader") || child.isResourceType("fd/af/components/guidefooter") || child.isResourceType("wcm/foundation/components/responsivegrid")) {
                GuideUtils.fillQueue(queue, child, type);
                continue;
            }
            if (child.isResourceType("fd/af/components/guideimage")) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)type, (CharSequence)"Image")) continue;
                queue.add(child);
                continue;
            }
            if (!child.isResourceType("fd/af/components/afFormTitle") && !child.isResourceType("fd/af/components/guidetextdraw") || !org.apache.commons.lang3.StringUtils.equals((CharSequence)type, (CharSequence)"StaticText")) continue;
            queue.add(child);
        }
    }

    public static Resource getAdaptiveFormBrandingComponents(ResourceResolver resourceResolver, String guideContainerPath, String templateRef, String type, String value, I18n i18n) {
        ValueMapResource option;
        ValueMapDecorator valueMap;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)guideContainerPath) || resourceResolver.getResource(guideContainerPath) == null) {
            return null;
        }
        Resource jcrContentResource = resourceResolver.getResource(guideContainerPath).getParent();
        HashMap map = new HashMap();
        ValueMapDecorator vm = new ValueMapDecorator(map);
        ArrayList<ValueMapResource> children = new ArrayList<ValueMapResource>();
        ValueMapResource itemsResource = new ValueMapResource(resourceResolver, jcrContentResource.getPath(), "nt:unstructured", (ValueMap)vm, children);
        ArrayDeque<Resource> queue = new ArrayDeque<Resource>();
        GuideUtils.fillQueue(queue, jcrContentResource, type);
        for (Resource child : queue) {
            String localizedSentence;
            String sentence;
            ValueMap properties = child.getValueMap();
            valueMap = new ValueMapDecorator(new HashMap());
            option = new ValueMapResource(resourceResolver, child.getPath(), "nt:unstructured", (ValueMap)valueMap);
            String name = (String)properties.get("name", String.class);
            String humanizedName = NameUtils.humanize(name);
            String text = "";
            text = i18n != null ? (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)humanizedName, (CharSequence)"Form ") ? (org.apache.commons.lang3.StringUtils.equals((CharSequence)(sentence = "Use Adaptive " + humanizedName), (CharSequence)(localizedSentence = i18n.getVar(sentence))) ? i18n.get("Use Adaptive {0}", "0 replaced with type, example Logo Image", new Object[]{i18n.getVar(humanizedName)}) : localizedSentence) : (org.apache.commons.lang3.StringUtils.equals((CharSequence)(sentence = "Use Adaptive Form " + humanizedName), (CharSequence)(localizedSentence = i18n.getVar(sentence))) ? i18n.get("Use Adaptive Form {0}", "0 replaced with type, example Logo Image", new Object[]{i18n.getVar(humanizedName)}) : localizedSentence)) : (org.apache.commons.lang3.StringUtils.startsWith((CharSequence)humanizedName, (CharSequence)"Form ") ? "Use Adaptive " + humanizedName : "Use Adaptive Form " + humanizedName);
            valueMap.put((Object)"value", (Object)name);
            valueMap.put((Object)"text", (Object)text);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)value, (CharSequence)name) && org.apache.commons.lang3.StringUtils.equals((CharSequence)templateRef, (CharSequence)"/libs/fd/af/dor/templates/defaultTemplate.xdp")) {
                valueMap.put((Object)"selected", (Object)true);
            }
            children.add(option);
        }
        ValueMapDecorator templateValueMap = new ValueMapDecorator(new HashMap());
        ValueMapResource templateOption = new ValueMapResource(resourceResolver, "", "nt:unstructured", (ValueMap)templateValueMap);
        templateValueMap.put((Object)"value", (Object)"template");
        templateValueMap.put((Object)"text", (Object)GuideUtils.translateVar("Use Template " + NameUtils.humanize(value), i18n));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)templateRef) && !templateRef.equals("/libs/fd/af/dor/templates/defaultTemplate.xdp")) {
            templateValueMap.put((Object)"selected", (Object)true);
            children.add(templateOption);
        }
        valueMap = new ValueMapDecorator(new HashMap());
        option = new ValueMapResource(resourceResolver, "", "nt:unstructured", (ValueMap)valueMap);
        valueMap.put((Object)"value", (Object)"     ");
        valueMap.put((Object)"text", (Object)(i18n != null ? i18n.get("Use Custom") : "Use Custom"));
        children.add(option);
        return itemsResource;
    }

    private static String translateVar(String text, I18n i18n) {
        return i18n != null ? i18n.getVar(text) : text;
    }

    public static Resource getThemeResource(Resource formResource) {
        String themeRef = GuideUtils.getThemeContentRef(formResource);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)themeRef)) {
            ResourceResolver resolver = formResource.getResourceResolver();
            return resolver.getResource(themeRef);
        }
        return null;
    }

    public static boolean isScriptAuthoringAllowed(Principal userPrincipal, UserManager um) throws RepositoryException {
        boolean isAllowed = false;
        User user = (User)um.getAuthorizable(userPrincipal);
        if (user.isAdmin()) {
            isAllowed = true;
        } else {
            Group scriptWritersGroup = (Group)um.getAuthorizable("forms-script-writers");
            Group templateScriptWritersGroup = (Group)um.getAuthorizable("af-template-script-writers");
            if (scriptWritersGroup != null) {
                isAllowed = scriptWritersGroup.isMember((Authorizable)user);
            } else if (templateScriptWritersGroup != null) {
                isAllowed = templateScriptWritersGroup.isMember((Authorizable)user);
            }
        }
        return isAllowed;
    }

    public static boolean showRuleEditor(Principal userPrincipal, UserManager um, String[] customGroups) throws RepositoryException {
        if (customGroups == null || customGroups.length == 0) {
            return true;
        }
        User user = (User)um.getAuthorizable(userPrincipal);
        if (user.isAdmin()) {
            return true;
        }
        for (String groupName : customGroups) {
            Group group = (Group)um.getAuthorizable(groupName);
            if (group == null || !group.isMember((Authorizable)user)) continue;
            return true;
        }
        return false;
    }

    public static Object getNakedBoundJsonData(Object data) {
        Object boundData = null;
        boundData = data instanceof JSONObject && ((JSONObject)data).optJSONObject("afData") != null ? ((JSONObject)data).optJSONObject("afData").optJSONObject("afBoundData").optJSONObject("data") : data;
        return boundData;
    }

    public static boolean isDORConfigured(Resource formResource) {
        String xdpRef = GuideUtils.getDoRTemplateRef(GuideUtils.convertGuideContainerPathToFMAssetPath(formResource.getPath()), "en", formResource.getResourceResolver());
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)xdpRef);
    }

    public static String generateSOM(Resource element) {
        String som;
        ValueMap valueMap = ResourceUtil.getValueMap((Resource)element);
        Resource parentElement = element.getParent();
        String guideNodeClass = (String)valueMap.get((Object)"guideNodeClass");
        if (guideNodeClass == null) {
            som = GuideUtils.generateSOM(parentElement);
        } else {
            String name = (String)valueMap.get((Object)"name");
            name = GuideUtils.sanitize(name, element.getResourceResolver());
            som = name + "[0]";
            som = "guideContainerNode".equals(guideNodeClass) ? "guide[0]." + som : GuideUtils.generateSOM(parentElement) + "." + som;
        }
        return som;
    }

    private static String sanitize(String input, ResourceResolver resourceResolver) {
        XSSAPI xssapi = (XSSAPI)resourceResolver.adaptTo(XSSAPI.class);
        return GuideUtils.encodeForHtml(input, xssapi);
    }

    public static Object marshallDataWithAFWrapper(Object data) throws Exception {
        HashMap<String, Map> jsonData;
        if (data instanceof String) {
            ObjectMapper mapper = new ObjectMapper();
            data = mapper.readValue(data.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        if (data instanceof Map && (jsonData = (HashMap<String, Map>)data).get("afData") == null) {
            HashMap boundDataObject = new HashMap();
            HashMap unboundDataObject = new HashMap();
            for (Map.Entry thisEntry : jsonData.entrySet()) {
                String entityName = (String)thisEntry.getKey();
                if (!(jsonData.get(entityName) instanceof List)) continue;
                List jsonList = (List)jsonData.get(entityName);
                Map arrayData = (Map)jsonList.get(0);
                jsonData = new HashMap<String, Map>();
                jsonData.put(entityName, arrayData);
            }
            boundDataObject.put("data", jsonData);
            unboundDataObject.put("data", new HashMap());
            HashMap afData = new HashMap();
            HashMap afDataChildren = new HashMap();
            afDataChildren.put("afBoundData", boundDataObject);
            afDataChildren.put("afUnboundData", unboundDataObject);
            afData.put("afData", afDataChildren);
            data = new ObjectMapper().writeValueAsString(afData);
        }
        return data;
    }

    public static String getRedirectUrl(String redirectUrl, String formPath) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)redirectUrl) && redirectUrl.matches("^(https?)://.+")) {
            return redirectUrl;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            int lastSlash = redirectUrl.lastIndexOf(47);
            if (redirectUrl.indexOf(46, lastSlash) == -1) {
                redirectUrl = redirectUrl + ".html";
            }
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formPath)) {
            redirectUrl = formPath + "." + "guideThankYouPage.html";
        }
        return redirectUrl;
    }

    public static List<Resource> getGuideContainerFromFormPage(Resource formPageResource) {
        Resource jcrContentNode;
        ArrayList<Resource> guideContainerResourceList = new ArrayList<Resource>();
        if (formPageResource != null && !(formPageResource instanceof NonExistingResource) && (jcrContentNode = formPageResource.getChild("jcr:content")) != null) {
            Iterator formPageResourceIterator = jcrContentNode.listChildren();
            while (formPageResourceIterator.hasNext()) {
                Resource currentResource = (Resource)formPageResourceIterator.next();
                if (!GuideUtils.isGuideContainerResource(currentResource)) continue;
                guideContainerResourceList.add(currentResource);
            }
        }
        return guideContainerResourceList;
    }

    public static String convertFMAssetPathToFormPagePath(String FMAssetPath) {
        return org.apache.commons.lang3.StringUtils.replace((String)FMAssetPath, (String)"/content/dam/formsanddocuments/", (String)"/content/forms/af/", (int)1);
    }

    public static String convertFormPagePathToFMAssetPath(String formPagePath) {
        formPagePath = GuideUtils.removeChannelNameFromEndIfExist(formPagePath);
        return org.apache.commons.lang3.StringUtils.replace((String)formPagePath, (String)"/content/forms/af/", (String)"/content/dam/formsanddocuments/", (int)1);
    }

    public static String convertADAssetPathToWebChannelPagePath(String FMDocAssetPath) {
        return GuideUtils.convertFMAssetPathToFormPagePath(FMDocAssetPath) + "/channels/web";
    }

    private static <T> List<T> convertIteratorToList(Iterator<T> i) {
        ArrayList<T> list = new ArrayList<T>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public static JSONArray getMergedJSONArray(JSONArray array1, JSONArray array2) throws JSONException {
        JSONArray[] arrays;
        JSONArray array = new JSONArray();
        for (JSONArray currentArray : arrays = new JSONArray[]{array1, array2}) {
            if (currentArray == null) continue;
            for (int i = 0; i < currentArray.length(); ++i) {
                array.put(currentArray.get(i));
            }
        }
        return array;
    }

    public static boolean isWebChannel(Resource resource) {
        String channel;
        Page page;
        if (resource == null) {
            return false;
        }
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        return pageManager != null && (page = pageManager.getContainingPage(resource)) != null && org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"web", (CharSequence)(channel = (String)page.getContentResource().getValueMap().get((Object)"fd:channelType")));
    }

    public static Resource getParentResource(Resource resource, String parentResourceType) {
        if (resource == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parentResourceType)) {
            return null;
        }
        Resource parentResource = null;
        while (resource != null) {
            if (resource.isResourceType(parentResourceType)) {
                parentResource = resource;
                break;
            }
            resource = resource.getParent();
        }
        return parentResource;
    }

    public static Map<String, Object> getCommonRepeatableBindRefForTableRow(GuideModelImporter guideModelImporter, Resource tableRowResource, Resource guideContainerResource) {
        if (guideModelImporter == null || tableRowResource == null || guideContainerResource == null) {
            return null;
        }
        ResourceResolver resourceResolver = tableRowResource.getResourceResolver();
        if (resourceResolver == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("hasRepeatableBindRefs", false);
        map.put("commonRepeatableBindRef", null);
        HashSet<String> childrenBindRefs = new HashSet<String>();
        GuideUtils.computeRowChildrenBindRefs(tableRowResource, childrenBindRefs);
        try {
            JSONObject jsonObject = GuideUtils.getFDMJson(guideModelImporter, guideContainerResource, 1);
            HashMap<String, Map<String, Object>> bindRefToCollectionInfoMap = new HashMap<String, Map<String, Object>>();
            GuideUtils.createBindRefToCollectionInfoMap(jsonObject, bindRefToCollectionInfoMap);
            HashSet<String> commonRepeatableBindRefs = new HashSet<String>();
            boolean allCollectionLevelZero = true;
            boolean isAnyCollectionLevelGreaterThanOne = false;
            for (String childrenBindRef : childrenBindRefs) {
                if (!bindRefToCollectionInfoMap.containsKey(childrenBindRef)) continue;
                Map innerMap = (Map)bindRefToCollectionInfoMap.get(childrenBindRef);
                String parentCollectionPath = (String)innerMap.get("parentCollectionPath");
                Integer collectionLevel = (Integer)innerMap.get("collectionLevel");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)parentCollectionPath)) {
                    commonRepeatableBindRefs.add(parentCollectionPath);
                }
                if (collectionLevel > 0) {
                    allCollectionLevelZero = false;
                }
                if (collectionLevel <= 1) continue;
                isAnyCollectionLevelGreaterThanOne = true;
            }
            if (allCollectionLevelZero) {
                return map;
            }
            if (isAnyCollectionLevelGreaterThanOne) {
                map.put("hasRepeatableBindRefs", true);
                map.put("commonRepeatableBindRef", null);
                return map;
            }
            String commonRepeatableBindRef = null;
            if (commonRepeatableBindRefs.size() == 1) {
                Iterator iterator = commonRepeatableBindRefs.iterator();
                while (iterator.hasNext()) {
                    String str;
                    commonRepeatableBindRef = str = (String)iterator.next();
                }
            }
            map.put("hasRepeatableBindRefs", true);
            map.put("commonRepeatableBindRef", commonRepeatableBindRef);
        }
        catch (JSONException e) {
            logger.error("Can not parse json string.", (Throwable)e);
        }
        return map;
    }

    private static void computeRowChildrenBindRefs(Resource tableRowResource, Set<String> bindRefs) {
        if (tableRowResource == null) {
            return;
        }
        Iterator children = tableRowResource.listChildren();
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            if (child.hasChildren()) {
                GuideUtils.computeRowChildrenBindRefs(child, bindRefs);
                continue;
            }
            ValueMap vm = child.getValueMap();
            String bindRef = (String)vm.get("bindRef", String.class);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bindRef)) continue;
            bindRefs.add(bindRef);
        }
    }

    private static JSONObject getFDMJson(GuideModelImporter guideModelImporter, Resource guideContainerResource, int maxCollectionLevel) throws JSONException {
        if (guideModelImporter == null || guideContainerResource == null) {
            return null;
        }
        String schemaRef = GuideContainer.from(guideContainerResource).getSchemaRef();
        SchemaImportOptions schemaImportOptions = new SchemaImportOptions();
        schemaImportOptions.setGuideContainer(guideContainerResource);
        schemaImportOptions.setSchemaPath(schemaRef);
        schemaImportOptions.setSchemaType(GuideSchemaType.FDM);
        schemaImportOptions.setMaxCollectionLevel(maxCollectionLevel);
        String jsonStr = guideModelImporter.createFormJsonFromSchema(schemaImportOptions);
        JSONObject jsonObject = new JSONObject(jsonStr);
        return jsonObject;
    }

    public static Map<String, Object> getCommonRepeatableItemForChart(GuideModelImporter guideModelImporter, Resource chartResource, Resource guideContainerResource) {
        if (guideModelImporter == null || chartResource == null || guideContainerResource == null) {
            return null;
        }
        ResourceResolver resourceResolver = chartResource.getResourceResolver();
        if (resourceResolver == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("hasRepeatableBindRefs", false);
        map.put("commonRepeatableBindRef", null);
        ValueMap vm = chartResource.getValueMap();
        String xExp = (String)vm.get("xExp", String.class);
        String yExp = (String)vm.get("yExp", String.class);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)xExp) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)yExp)) {
            return null;
        }
        Boolean multiSeries = (Boolean)vm.get("multiSeries", Boolean.class);
        String seriesNameExp = (String)vm.get("seriesName", String.class);
        int expectedSeriesNameCollectionLevel = 0;
        int expectedXYCollectionLevel = 1;
        if (Boolean.TRUE.equals(multiSeries)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)seriesNameExp)) {
                map.put("hasRepeatableBindRefs", true);
                map.put("commonRepeatableBindRef", null);
                return map;
            }
            ++expectedSeriesNameCollectionLevel;
            ++expectedXYCollectionLevel;
        }
        try {
            Map innerMap;
            JSONObject jsonObject = GuideUtils.getFDMJson(guideModelImporter, guideContainerResource, expectedXYCollectionLevel);
            HashMap<String, Map<String, Object>> bindRefToCollectionInfoMap = new HashMap<String, Map<String, Object>>();
            GuideUtils.createBindRefToCollectionInfoMap(jsonObject, bindRefToCollectionInfoMap);
            int seriesNameCollectionLevel = 0;
            String seriesParentCollectionPath = null;
            if (Boolean.TRUE.equals(multiSeries) && bindRefToCollectionInfoMap.containsKey(seriesNameExp)) {
                Map innerMap2 = (Map)bindRefToCollectionInfoMap.get(seriesNameExp);
                seriesParentCollectionPath = (String)innerMap2.get("parentCollectionPath");
                seriesNameCollectionLevel = (Integer)innerMap2.get("collectionLevel");
            }
            String xParentCollectionPath = null;
            String yParentCollectionPath = null;
            int xCollectionLevel = 0;
            int yCollectionLevel = 0;
            if (bindRefToCollectionInfoMap.containsKey(xExp)) {
                innerMap = (Map)bindRefToCollectionInfoMap.get(xExp);
                xParentCollectionPath = (String)innerMap.get("parentCollectionPath");
                xCollectionLevel = (Integer)innerMap.get("collectionLevel");
            }
            if (bindRefToCollectionInfoMap.containsKey(yExp)) {
                innerMap = (Map)bindRefToCollectionInfoMap.get(yExp);
                yParentCollectionPath = (String)innerMap.get("parentCollectionPath");
                yCollectionLevel = (Integer)innerMap.get("collectionLevel");
            }
            if (seriesNameCollectionLevel > 0 && (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)seriesParentCollectionPath) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)seriesParentCollectionPath, (CharSequence)Text.getRelativeParent((String)xParentCollectionPath, (int)1)))) {
                map.put("hasRepeatableBindRefs", true);
                map.put("commonRepeatableBindRef", null);
            } else if (seriesNameCollectionLevel == expectedSeriesNameCollectionLevel && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)xParentCollectionPath) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)yParentCollectionPath) && org.apache.commons.lang3.StringUtils.equals((CharSequence)xParentCollectionPath, (CharSequence)yParentCollectionPath) && xCollectionLevel == expectedXYCollectionLevel && yCollectionLevel == expectedXYCollectionLevel) {
                map.put("hasRepeatableBindRefs", true);
                map.put("commonRepeatableBindRef", xParentCollectionPath);
                map.put("chartSeriesRepeatableBindRef", seriesParentCollectionPath);
            } else {
                map.put("hasRepeatableBindRefs", true);
                map.put("commonRepeatableBindRef", null);
                logger.error("Not able to compute repeatable item for chart component. xExp=" + xExp + ", yExp=" + yExp + ", seriesNameExp=" + seriesNameExp + ", xCollectionLevel=" + xCollectionLevel + ", yCollectionLevel=" + yCollectionLevel + ", seriesNameCollectionLevel=" + seriesNameCollectionLevel + ", expectedXYCollectionLevel=" + expectedXYCollectionLevel + ", expectedSeriesNameCollectionLevel=" + expectedSeriesNameCollectionLevel);
            }
        }
        catch (JSONException e) {
            logger.error("Can not parse json string.", (Throwable)e);
        }
        return map;
    }

    public static List<FileAttachmentWrapper> getFileAttachmentWrapperList(ParameterMap parameterMap) {
        ArrayList<FileAttachmentWrapper> fileAttachments = new ArrayList<FileAttachmentWrapper>();
        for (Map.Entry param : parameterMap.entrySet()) {
            RequestParameter[] rpm = (RequestParameter[])param.getValue();
            if (rpm == null || rpm.length <= 0 || rpm[0].isFormField()) continue;
            String newFileName = rpm[0].getFileName();
            if (org.apache.commons.lang3.StringUtils.contains((CharSequence)newFileName, (CharSequence)"/")) {
                newFileName = newFileName.substring(newFileName.indexOf("/") + 1);
                newFileName = newFileName.replaceAll("[^a-zA-Z0-9.]", "");
            }
            FileAttachmentWrapper fileAttachment = new FileAttachmentWrapper(newFileName, rpm[0].getContentType(), rpm[0].get());
            fileAttachments.add(fileAttachment);
        }
        return fileAttachments;
    }

    private static void createBindRefToCollectionInfoMap(JSONObject fdmJsonObject, Map<String, Map<String, Object>> map) throws JSONException {
        if (fdmJsonObject == null) {
            return;
        }
        Iterator keys = fdmJsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object obj = fdmJsonObject.opt(key);
            if (obj instanceof JSONObject) {
                GuideUtils.createBindRefToCollectionInfoMap(fdmJsonObject.optJSONObject(key), map);
                continue;
            }
            if (!"bindRef".equals(key) || !fdmJsonObject.has("parentCollectionPath") || !fdmJsonObject.has("collectionLevel")) continue;
            String bindRef = fdmJsonObject.getString("bindRef");
            String parentCollectionPath = fdmJsonObject.getString("parentCollectionPath");
            int collectionLevel = fdmJsonObject.getInt("collectionLevel");
            if (map.containsKey(bindRef)) continue;
            HashMap<String, Object> innerMap = new HashMap<String, Object>();
            innerMap.put("parentCollectionPath", parentCollectionPath);
            innerMap.put("collectionLevel", collectionLevel);
            map.put(bindRef, innerMap);
        }
    }

    public static void setMasterAuthoringConfig(Map<String, Object> authoringConfig, ValueMap resourceProps) {
        String masterPath;
        if (resourceProps != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(masterPath = (String)resourceProps.get("cq:master", (Object)"")))) {
            authoringConfig.put("master", masterPath);
        }
    }

    public static boolean isValidFormResource(ResourceResolver resourceResolver, String formPath, String formType) {
        if ("".equals(formPath)) {
            return false;
        }
        if (resourceResolver == null) {
            return false;
        }
        Resource formResource = resourceResolver.getResource(formPath);
        if (formResource == null) {
            return false;
        }
        Resource jcrContent = formResource.getChild("jcr:content");
        if (jcrContent == null) {
            return false;
        }
        ValueMap props = jcrContent.getValueMap();
        return (Integer)props.get(formType, (Object)0) == 1;
    }

    public static boolean processChartAddition(GuideModelImporter guideModelImporter, Resource chartResource, Resource guideContainerResource) throws Exception {
        Map<String, Object> map = GuideUtils.getCommonRepeatableItemForChart(guideModelImporter, chartResource, guideContainerResource);
        if (map == null) {
            return false;
        }
        Boolean hasBindRef = (Boolean)map.get("hasRepeatableBindRefs");
        String repeatableItem = (String)map.get("commonRepeatableBindRef");
        String seriesRepeatableItem = (String)map.get("chartSeriesRepeatableBindRef");
        if (hasBindRef.booleanValue()) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)repeatableItem)) {
                throw new Exception(MSG_NO_REPEATABLE_ITEM);
            }
            ValueMap valueMap = (ValueMap)chartResource.adaptTo(ModifiableValueMap.class);
            if (valueMap == null) {
                valueMap = chartResource.getValueMap();
            }
            valueMap.put((Object)"repeatableItem", (Object)repeatableItem);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)seriesRepeatableItem)) {
                valueMap.put((Object)"seriesRepeatableItem", (Object)seriesRepeatableItem);
            }
        }
        return hasBindRef;
    }

    public static boolean isDorTemplateAnAcroForm(String templatePath, ResourceResolver resourceResolver) {
        Resource templateMeta = resourceResolver.getResource(templatePath + "/jcr:content/metadata");
        if (templateMeta != null) {
            return Boolean.parseBoolean((String)templateMeta.getValueMap().get("acroForm", (Object)"false"));
        }
        return false;
    }

    private static boolean useBrowserLocale(SlingHttpServletRequest request) {
        AdaptiveFormConfigurationService adaptiveFormConfigurationService;
        boolean usePreviousTranslationApproach = false;
        SlingBindings slingBindings = GuideUtils.getSlingBinding(request);
        if (slingBindings != null && (adaptiveFormConfigurationService = (AdaptiveFormConfigurationService)slingBindings.getSling().getService(AdaptiveFormConfigurationService.class)) != null) {
            usePreviousTranslationApproach = adaptiveFormConfigurationService.isUseBrowserLocale();
        }
        return usePreviousTranslationApproach;
    }

    public static String syncExcludeFromDorData(String dataJSON, String ServerSideExcludeFromDorData) {
        String newData = "";
        try {
            JSONObject parent = new JSONObject(dataJSON);
            if (parent.has("afData")) {
                JSONObject afSubmissionObject = null;
                JSONObject afData = parent.getJSONObject("afData");
                if (afData.has("afSubmissionInfo")) {
                    afSubmissionObject = afData.getJSONObject("afSubmissionInfo");
                }
                if (afSubmissionObject == null) {
                    afSubmissionObject = new JSONObject();
                    afSubmissionObject.put("excludeFromDoR", (Object)ServerSideExcludeFromDorData);
                    afData.put("afSubmissionInfo", (Object)afSubmissionObject);
                } else {
                    afSubmissionObject.put("excludeFromDoR", (Object)ServerSideExcludeFromDorData);
                }
                newData = parent.toString();
            } else {
                newData = dataJSON;
            }
        }
        catch (Exception ex) {
            logger.error("Error occurred while aligning excludeFromDor data in data.json with the one computed in server.", (Throwable)ex);
        }
        return newData;
    }

    public static String getFormRelativePath(String formContainerPath) {
        String formPath = org.apache.commons.lang3.StringUtils.substringBefore((String)formContainerPath, (String)"/jcr:content/guideContainer");
        formPath = org.apache.commons.lang3.StringUtils.replace((String)formPath, (String)"/content/forms/af/", (String)"");
        return formPath;
    }

    public static Resource getFormResourceFromEncodedPath(String encodedFormPath, ResourceResolver resourceResolver) {
        byte[] bytes = Base64.getDecoder().decode(encodedFormPath);
        Resource resource = resourceResolver.getResource(new String(bytes, StandardCharsets.UTF_8));
        return resource;
    }

    public static Resource getFormContainerResourceFromEncodedPath(String encodedFormPath, ResourceResolver resourceResolver) {
        String formPath;
        byte[] bytes = Base64.getDecoder().decode(encodedFormPath);
        String formContainerPath = formPath = new String(bytes, StandardCharsets.UTF_8);
        Resource formPathResource = resourceResolver.getResource(formPath);
        if (GuideWCMUtils.isForms(formPath) || GuideUtils.isEditableTemplateResource(formPathResource).booleanValue()) {
            formContainerPath = formPath + "/jcr:content/guideContainer";
        }
        return resourceResolver.getResource(formContainerPath);
    }

    public static String sanitizeJSON(String str, XSSAPI xssapi) {
        String sanitizedString = "";
        try {
            JSONObject jsonObject = new JSONObject(str);
            Iterator itr = jsonObject.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                String value = jsonObject.optString(key);
                if ("thankYouContent".equals(key)) {
                    jsonObject.put(key, (Object)GuideUtils.filterHtml(value, xssapi));
                    continue;
                }
                jsonObject.put(key, (Object)GuideUtils.encodeForHtml(value, xssapi));
            }
            sanitizedString = jsonObject.toString();
        }
        catch (JSONException ex) {
            sanitizedString = GuideUtils.encodeForHtml(str, xssapi);
        }
        return sanitizedString;
    }

    public static String getFormDataId(String formContainerPath, String submissionId, Date date) {
        Calendar calendar = DateUtils.toCalendar((Date)date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return GuideUtils.getFormRelativePath(formContainerPath) + "/" + year + "/" + month + "/" + day + "/" + submissionId;
    }

    public static String getFormName(String guidePath) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)guidePath)) {
            return "";
        }
        int index = guidePath.indexOf("/jcr:content/guideContainer");
        String formPath = guidePath.substring(0, index);
        String formName = formPath.substring(formPath.lastIndexOf("/") + 1).replaceAll("-", "_");
        return formName;
    }

    public static JSONObject convertArrayValuesToCommaSeparatedValues(JSONObject data) throws JSONException {
        JSONObject convertedData = new JSONObject();
        Iterator itr = data.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = data.get(key);
            if (value instanceof JSONArray) {
                Object val;
                int i;
                JSONArray array = (JSONArray)value;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < array.length() && !((val = array.get(i)) instanceof JSONArray) && !(val instanceof JSONObject); ++i) {
                    sb.append(array.optString(i));
                    if (i >= array.length() - 1) continue;
                    sb.append(",");
                }
                if (i == array.length()) {
                    convertedData.put(key, (Object)sb.toString());
                    continue;
                }
                convertedData.put(key, value);
                continue;
            }
            if (value instanceof JSONObject) {
                convertedData.put(key, (Object)GuideUtils.convertArrayValuesToCommaSeparatedValues((JSONObject)value));
                continue;
            }
            convertedData.put(key, value);
        }
        return convertedData;
    }

    public static class AuthoringError {
        private String errorMessage;
        private String errorCode;
        private ErrorType errorType;

        public AuthoringError(String errorMessage) {
            this.errorMessage = errorMessage;
            this.errorType = ErrorType.Error;
        }

        public AuthoringError(String errorMessage, String errorCode) {
            this(errorMessage);
            this.errorCode = errorCode;
        }

        public AuthoringError(String errorMessage, String errorCode, ErrorType errorType) {
            this(errorMessage, errorCode);
            this.errorType = errorType;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorType() {
            return this.errorType.toString();
        }

        public void setErrorType(ErrorType errorType) {
            this.errorType = errorType;
        }

        private static enum ErrorType {
            Error("error"),
            Info("info"),
            Warn("warn");

            private String errorType;

            private ErrorType(String errorType) {
                this.errorType = errorType;
            }

            public String toString() {
                return this.errorType;
            }
        }
    }
}

