/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.utils.GuideConstants;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class ExpEditorUtils {
    public static JSONObject getEventsObject(JsonNode scriptsNode) throws JSONException {
        JSONArray scriptArray = new JSONArray();
        JSONObject eventsObj = new JSONObject();
        if (scriptsNode != null) {
            Iterator scriptsIterator = scriptsNode.fields();
            while (scriptsIterator.hasNext()) {
                Map.Entry script = (Map.Entry)scriptsIterator.next();
                String key = (String)script.getKey();
                String eventModel = ExpEditorUtils.getScriptModel(((JsonNode)script.getValue()).asText(), key);
                String eventProperty = ExpEditorUtils.getEventProperty(key);
                scriptArray.put((Object)eventModel);
                eventsObj.put(eventProperty, (Object)scriptArray);
            }
        }
        return eventsObj;
    }

    public static String getScriptModel(String script, String eventName) {
        String scriptModel = null;
        if (StringUtils.isNotBlank((CharSequence)script) && StringUtils.isNotBlank((CharSequence)eventName)) {
            script = StringEscapeUtils.escapeEcmaScript((String)script);
            scriptModel = String.format("{\"script\":{\"content\":\"%s\",\"event\":\"%s\"},\"nodeName\":\"SCRIPTMODEL\",\"version\":1,\"enabled\":true}", script, eventName);
        }
        return scriptModel;
    }

    public static String getEventProperty(String eventName) {
        String secureEventProperty = null;
        if (StringUtils.isNotBlank((CharSequence)eventName)) {
            secureEventProperty = GuideConstants.SECURE_EVENT_PROPERTY_MAPPING.get(eventName);
        }
        return secureEventProperty;
    }
}

