/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.sightly.SightlyWCMMode;
import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.toggle.api.ToggleRouter;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AEMForm
extends WCMUsePojo {
    public static final int NO_FORM_SELECTED = -1;
    public static final int MOBILE_FORM = 1;
    public static final int ADAPTIVE_FORM = 2;
    public static final int MC_DOCUMENT = 8;
    public static final int MOBILE_FORMSET = 3;
    public static final int INLINE_SUBMIT = 4;
    public static final int PAGE_REFRESH_SUBMIT = 5;
    private static final int THANKYOU_PAGE = 6;
    private static final int THANKYOU_MESSAGE = 7;
    public static final String PROP_THANK_YOU_CONFIG = "thankyouConfig";
    public static final String PROP_THANK_YOU_PAGE = "thankyouPage";
    public static final String PROP_THANK_YOU_MESSAGE = "thankyouMessage";
    protected Resource mResource;
    protected ValueMap mResourceProps;
    private Logger logger;

    public void activate() throws Exception {
        this.mResource = this.getResource();
        this.mResourceProps = this.getProperties();
        SlingHttpServletRequest request = this.getRequest();
        request.setAttribute("formContainerPath", (Object)this.mResource.getPath());
        this.logger = LoggerFactory.getLogger(AEMForm.class);
    }

    protected String getClientLibCategory(String themePath) {
        if ("".equals(themePath)) {
            return "";
        }
        Resource themeResource = this.getResource().getResourceResolver().getResource(themePath + "/jcr:content/metadata");
        if (themeResource == null) {
            throw new GuideException("Invalid Theme Name " + themePath);
        }
        ValueMap themeProps = themeResource.getValueMap();
        return (String)themeProps.get("clientlibCategory", (Object)"");
    }

    public String getThemeName() {
        return this.getClientLibCategory(this.getThemeRef());
    }

    public String getFormPath() {
        if ("adaptiveDocument".equals(this.mResourceProps.get("formType", (Object)""))) {
            return (String)this.mResourceProps.get("docRef", (Object)"");
        }
        return (String)this.mResourceProps.get("formRef", (Object)"");
    }

    public boolean getEnableFocusOnFirstField() {
        return (Boolean)this.mResourceProps.get("enableFocusOnFirstField", (Object)true);
    }

    protected String getThemeRef() {
        return (String)this.mResourceProps.get("themeRef", (Object)"");
    }

    public String getThemePath() {
        return StringUtils.isNotBlank((CharSequence)this.getThemeRef()) ? this.getThemeRef() + "/" + "jcr:content" : "";
    }

    public String getFormEditPagePath() {
        return this.getFormPath();
    }

    public int getFormType() {
        int formType = -1;
        String formPath = this.getFormPath();
        if (!"".equals(formPath)) {
            ResourceResolver resolver = this.mResource.getResourceResolver();
            if (GuideUtils.isValidFormResource(resolver, formPath, "guide")) {
                formType = 2;
            } else if (GuideUtils.isValidFormResource(resolver, formPath, "mcdocument")) {
                formType = 8;
            } else if (GuideUtils.isValidFormResource(resolver, formPath, "xfaForm")) {
                formType = 1;
            }
        }
        return formType;
    }

    public boolean getIsAdaptiveForm() {
        return this.getFormType() == 2;
    }

    public boolean getIsMCDocument() {
        return this.getFormType() == 8;
    }

    public boolean getIsMobileForm() {
        return this.getFormType() == 1;
    }

    public boolean getIsMobileFormset() {
        return this.getFormType() == 3;
    }

    public boolean getIsFormSelected() {
        return this.getFormType() != -1;
    }

    public String getSubmitType() {
        if ("message".equals(this.getThankyouConfig())) {
            return "inline";
        }
        return (String)this.mResourceProps.get("submitType", (Object)"inline");
    }

    public String getThankyouMessage() {
        return (String)this.mResourceProps.get(PROP_THANK_YOU_MESSAGE, (Object)"");
    }

    public String getThankyouPage() {
        String redirectUrl = (String)this.mResourceProps.get(PROP_THANK_YOU_PAGE, (Object)"");
        return GuideUtils.getRedirectUrl(redirectUrl, null);
    }

    public String getThankyouConfig() {
        return (String)this.mResourceProps.get(PROP_THANK_YOU_CONFIG, (Object)"page");
    }

    public String getHeight() {
        String height = (String)this.mResourceProps.get("height", (Object)"auto");
        if (!"auto".equals(height)) {
            try {
                height = Integer.parseInt(height) + "px";
            }
            catch (NumberFormatException ex) {
                height = "auto";
            }
        }
        return height;
    }

    public String getCssClientlib() {
        return (String)this.mResourceProps.get("cssClientlib", (Object)"");
    }

    public String getAdditionalParamString() {
        String paramString = "";
        SightlyWCMMode wcmMode = this.getWcmMode();
        if (!wcmMode.isEdit()) {
            paramString = "&wcmmode=" + wcmMode.toString();
        }
        return paramString;
    }

    public boolean getIsPlaceholderVisible() {
        boolean isEditWCMMode = false;
        SightlyWCMMode wcmMode = this.getWcmMode();
        if (!wcmMode.isDisabled()) {
            isEditWCMMode = true;
        }
        return isEditWCMMode && !this.getIsFormSelected();
    }

    public String getPath() {
        ToggleRouter toggleRouter;
        SlingBindings bindings;
        SlingHttpServletRequest slingRequest = this.getRequest();
        ResourceResolver resourceResolver = this.getResourceResolver();
        String path = this.mResource.getPath();
        if (resourceResolver != null && slingRequest != null && (bindings = (SlingBindings)slingRequest.getAttribute(SlingBindings.class.getName())) != null && bindings.getSling() != null && (toggleRouter = (ToggleRouter)bindings.getSling().getService(ToggleRouter.class)) != null && toggleRouter.isEnabled("FT_FORMS-13852")) {
            path = StringUtils.replace((String)resourceResolver.map(path), (String)"_jcr_content", (String)"jcr:content");
        }
        return path;
    }
}

