/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.AlphabetEncoding;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;

public class DefaultAlphabetEncoding
extends AlphabetEncoding {
    private static final int DCS = 0;
    public static final int EXTENDED_ESCAPE = 27;
    public static final int PAGE_BREAK = 10;
    private static final char[] CHAR_TABLE = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', ' ', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    private static final char[] EXT_CHAR_TABLE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '^', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '{', '}', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\\', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '[', '~', ']', '\u0000', '|', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u20ac', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final DefaultAlphabetEncoding INSTANCE = new DefaultAlphabetEncoding();

    public DefaultAlphabetEncoding() {
        super(0);
    }

    public static DefaultAlphabetEncoding getInstance() {
        return INSTANCE;
    }

    public String decodeString(byte[] b) {
        if (b == null) {
            return "";
        }
        char[] table = CHAR_TABLE;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int code = b[i] & 0xFF;
            if (code == 27) {
                table = EXT_CHAR_TABLE;
                continue;
            }
            buf.append(code >= table.length ? (char)'?' : table[code]);
            table = CHAR_TABLE;
        }
        return buf.toString();
    }

    public byte[] encodeString(String s) {
        if (s == null) {
            return new byte[0];
        }
        char[] c = s.toCharArray();
        ByteArrayOutputStream enc = new ByteArrayOutputStream(256);
        for (int loop = 0; loop < c.length; ++loop) {
            int search;
            for (search = 0; search < CHAR_TABLE.length; ++search) {
                if (search == 27) continue;
                if (c[loop] == CHAR_TABLE[search]) {
                    enc.write((byte)search);
                    break;
                }
                if (c[loop] != EXT_CHAR_TABLE[search]) continue;
                enc.write(27);
                enc.write((byte)search);
                break;
            }
            if (search != CHAR_TABLE.length) continue;
            enc.write(63);
        }
        return enc.toByteArray();
    }

    public int getEncodingLength() {
        return 7;
    }

    public byte[] pack(byte[] unpacked) {
        int packedLen = unpacked.length - unpacked.length / 8;
        byte[] packed = new byte[packedLen];
        int pos = 0;
        for (int i = 0; i < unpacked.length; i += 8) {
            int jmax = i + 7 > unpacked.length ? unpacked.length - i : 7;
            int mask = 1;
            for (int j = 0; j < jmax; ++j) {
                int b1 = unpacked[i + j] & 0xFF;
                int b2 = 0;
                try {
                    b2 = unpacked[i + j + 1] & mask;
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    // empty catch block
                }
                packed[pos++] = (byte)(b1 >>> j | b2 << 8 - (j + 1));
                mask = mask << 1 | 1;
            }
        }
        return packed;
    }

    public byte[] unpack(byte[] packed) {
        int unpackedLen = packed.length * 8 / 7;
        byte[] unpacked = new byte[unpackedLen];
        int pos = 0;
        for (int i = 0; i < packed.length; i += 7) {
            int mask = 127;
            int jmax = i + 8 > packed.length ? packed.length - i : 8;
            for (int j = 0; j < jmax; ++j) {
                int b1 = packed[i + j] & mask;
                int b2 = 0;
                try {
                    b2 = packed[i + j - 1] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    // empty catch block
                }
                unpacked[pos++] = (byte)(b1 << j | b2 >>> 8 - j);
                mask >>= 1;
            }
        }
        return unpacked;
    }

    public String toString() {
        String fmt = "{0,number,000}: {1}  ";
        Object[] args = new Object[2];
        StringBuffer b = new StringBuffer(256);
        b.append("Table size: ").append(CHAR_TABLE.length).append('\n');
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                int pos = i + 16 * j;
                args[0] = new Integer(pos);
                args[1] = CHAR_TABLE[pos] == '\r' ? "CR" : (CHAR_TABLE[pos] == '\n' ? "LF" : (CHAR_TABLE[pos] == ' ' ? "SP" : " " + CHAR_TABLE[pos]));
                b.append(MessageFormat.format("{0,number,000}: {1}  ", args));
            }
            b.append('\n');
        }
        return b.toString();
    }
}

