/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.SMPPRuntimeException;
import ie.omk.smpp.util.MessageEncoding;
import java.io.UnsupportedEncodingException;

public class AlphabetEncoding
extends MessageEncoding {
    private static final String BAD_IMPLEMENTATION = "Missing charset in implementation of AlphabetEncoding " + AlphabetEncoding.class.getName();
    private String charset;

    protected AlphabetEncoding(int dcs) {
        super(dcs);
    }

    protected void setCharset(String charset) throws UnsupportedEncodingException {
        new String("probe").getBytes(charset);
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public String decodeString(byte[] b) {
        if (this.charset == null) {
            throw new SMPPRuntimeException(BAD_IMPLEMENTATION);
        }
        try {
            if (b != null) {
                return new String(b, this.charset);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "";
    }

    public byte[] encodeString(String s) {
        if (this.charset == null) {
            throw new SMPPRuntimeException(BAD_IMPLEMENTATION);
        }
        try {
            if (s != null) {
                return s.getBytes(this.charset);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new byte[0];
    }
}

