/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.InvalidConfigurationException;
import ie.omk.smpp.util.PropertyNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class APIConfig
extends Properties {
    private static final String BAD_PROPERTY_VALUE = "Bad property value";
    static final long serialVersionUID = 3668742926704484281L;
    public static final String TCP_SOCKET_TIMEOUT = "smppapi.net.tcp.so_timeout";
    public static final String LAX_VERSIONS = "smppapi.lax_versions";
    public static final String LINK_BUFFERSIZE_IN = "smppapi.net.buffersize_in";
    public static final String LINK_BUFFERSIZE_OUT = "smppapi.net.buffersize_out";
    public static final String LINK_AUTO_FLUSH = "smppapi.net.autoflush";
    public static final String LINK_AUTOCLOSE_SNOOP = "smppapi.net.autoclose_snoop";
    public static final String LINK_TIMEOUT = "smppapi.net.link_timeout";
    public static final String TOO_MANY_IO_EXCEPTIONS = "smppapi.connection.rcv_daemon.ioex_count";
    public static final String EVENT_DISPATCHER_CLASS = "smppapi.event.dispatcher";
    public static final String EVENT_THREAD_POOL_SIZE = "smppapi.event.threaded_dispatcher.pool_size";
    public static final String EVENT_THREAD_FIFO_QUEUE_SIZE = "smppapi.event.threaded_dispatcher.queue_size";
    public static final String BIND_TIMEOUT = "smppapi.connection.bind_timeout";
    private static final Log LOGGER = LogFactory.getLog((Class)APIConfig.class);
    private static final String[] SEARCH_PATH = new String[]{"/", "/ie/", "/ie/omk/", "/ie/omk/smpp/", ""};
    private static final String PROPS_RESOURCE = "smppapi.properties";
    private static APIConfig instance;
    private URL propsURL;

    public APIConfig() {
        this.propsURL = this.getDefaultPropertiesResource();
    }

    public APIConfig(URL propertiesURL) {
        this.propsURL = propertiesURL;
    }

    public boolean reloadAPIConfig() {
        LOGGER.debug((Object)"Reloading API config properties.");
        try {
            this.loadAPIProperties();
        }
        catch (IOException x) {
            LOGGER.warn((Object)"Could not reload API properties.", (Throwable)x);
            return false;
        }
        return true;
    }

    public static APIConfig getInstance() {
        if (instance == null) {
            try {
                instance = new APIConfig();
                instance.loadAPIProperties();
            }
            catch (IOException x) {
                LOGGER.error((Object)"Could not load API properties from default resource", (Throwable)x);
            }
        }
        return instance;
    }

    public static void configure(URL properties) {
        try {
            if (instance == null) {
                instance = new APIConfig(properties);
            } else {
                APIConfig.instance.propsURL = properties;
            }
            instance.loadAPIProperties();
        }
        catch (IOException x) {
            LOGGER.error((Object)("Could not load API config from " + properties), (Throwable)x);
        }
    }

    public String getProperty(String property) throws PropertyNotFoundException {
        String val = super.getProperty(property);
        if (val == null) {
            throw new PropertyNotFoundException(property);
        }
        return val;
    }

    public String getProperty(String property, String defaultValue) {
        String val = super.getProperty(property);
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public short getShort(String property, short defaultValue) throws InvalidConfigurationException {
        short s;
        try {
            s = this.getShort(property);
        }
        catch (PropertyNotFoundException x) {
            s = defaultValue;
        }
        return s;
    }

    public short getShort(String property) throws InvalidConfigurationException, PropertyNotFoundException {
        int i = this.getInt(property);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new InvalidConfigurationException("Property value exceeds valid short range: " + i, property);
        }
        return (short)i;
    }

    public int getInt(String property, int defaultValue) throws InvalidConfigurationException {
        try {
            return this.getInt(property);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return defaultValue;
        }
    }

    public int getInt(String property) throws InvalidConfigurationException, PropertyNotFoundException {
        long l;
        try {
            String n = this.getProperty(property);
            l = this.convertToNumber(n);
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                throw new InvalidConfigurationException("Property value exceeds valid int range: " + l, property);
            }
        }
        catch (NumberFormatException x) {
            throw new InvalidConfigurationException(BAD_PROPERTY_VALUE, property);
        }
        return (int)l;
    }

    public long getLong(String property, long defaultValue) throws InvalidConfigurationException {
        long l;
        try {
            l = this.getLong(property);
        }
        catch (PropertyNotFoundException x) {
            l = defaultValue;
        }
        return l;
    }

    public long getLong(String property) throws InvalidConfigurationException, PropertyNotFoundException {
        long l;
        try {
            String n = this.getProperty(property);
            l = this.convertToNumber(n);
        }
        catch (NumberFormatException x) {
            throw new InvalidConfigurationException(BAD_PROPERTY_VALUE, property);
        }
        return l;
    }

    public boolean getBoolean(String property, boolean defaultValue) throws InvalidConfigurationException {
        try {
            return this.getBoolean(property);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String property) throws InvalidConfigurationException, PropertyNotFoundException {
        boolean b = false;
        String s = this.getProperty(property).toLowerCase();
        try {
            int n = Integer.parseInt(s);
            b = n > 0;
        }
        catch (NumberFormatException x) {
            if ("yes".equals(s) || "on".equals(s) || "true".equals(s) || "1".equals(s)) {
                b = true;
            }
            if ("no".equals(s) || "off".equals(s) || "false".equals(s) || "0".equals(s)) {
                b = false;
            }
            throw new InvalidConfigurationException(BAD_PROPERTY_VALUE, property, s);
        }
        return b;
    }

    private URL getDefaultPropertiesResource() {
        URL url = null;
        Class<?> c = this.getClass();
        for (int i = 0; i < SEARCH_PATH.length && url == null; ++i) {
            url = c.getResource(SEARCH_PATH[i] + PROPS_RESOURCE);
        }
        return url;
    }

    private void loadAPIProperties() throws IOException {
        if (this.propsURL != null) {
            this.load(this.propsURL.openStream());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Loaded API properties from " + this.propsURL));
                StringWriter w = new StringWriter();
                this.list(new PrintWriter(w));
                LOGGER.debug((Object)("\n" + w.toString()));
            }
        }
    }

    long convertToNumber(String num) throws NumberFormatException {
        String s;
        int base = 10;
        long multiplier = 1L;
        if (num.startsWith("0x") || num.startsWith("0X")) {
            base = 16;
            s = num.substring(2);
        } else if (num.endsWith("b")) {
            base = 2;
            s = num.substring(0, num.length() - 1);
        } else if (num.endsWith("k")) {
            multiplier = 1024L;
            s = num.substring(0, num.length() - 1);
        } else if (num.endsWith("m")) {
            multiplier = 0x100000L;
            s = num.substring(0, num.length() - 1);
        } else if (num.startsWith("0") && num.length() > 1) {
            base = 8;
            s = num.substring(1);
        } else {
            s = num;
        }
        return Long.parseLong(s, base) * multiplier;
    }
}

