/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.InvalidDateFormatException;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class ReplaceSM
extends SMPPRequest {
    public ReplaceSM() {
        super(7);
    }

    public ReplaceSM(int seqNum) {
        super(7, seqNum);
    }

    public int getBodyLength() {
        int len = (this.messageId != null ? this.messageId.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.deliveryTime != null ? this.deliveryTime.toString().length() : 0) + (this.expiryTime != null ? this.expiryTime.toString().length() : 0) + (this.message != null ? this.message.length : 0);
        return len + 3 + 3;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        int smLength = 0;
        if (this.message != null) {
            smLength = this.message.length;
        }
        SMPPIO.writeCString(this.getMessageId(), out);
        if (this.source != null) {
            this.source.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
        String dt = this.deliveryTime == null ? null : this.deliveryTime.toString();
        String et = this.expiryTime == null ? null : this.expiryTime.toString();
        SMPPIO.writeCString(dt, out);
        SMPPIO.writeCString(et, out);
        SMPPIO.writeInt(this.registered, 1, out);
        SMPPIO.writeInt(this.defaultMsg, 1, out);
        SMPPIO.writeInt(smLength, 1, out);
        if (this.message != null) {
            out.write(this.message);
        }
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        try {
            int smLength = 0;
            this.messageId = SMPPIO.readCString(body, offset);
            this.source = new Address();
            this.source.readFrom(body, offset += this.messageId.length() + 1);
            String delivery = SMPPIO.readCString(body, offset += this.source.getLength());
            offset += delivery.length() + 1;
            if (delivery.length() > 0) {
                this.deliveryTime = SMPPDate.parseSMPPDate(delivery);
            }
            String valid = SMPPIO.readCString(body, offset);
            offset += valid.length() + 1;
            if (valid.length() > 0) {
                this.expiryTime = SMPPDate.parseSMPPDate(valid);
            }
            this.registered = SMPPIO.bytesToInt(body, offset++, 1);
            this.defaultMsg = SMPPIO.bytesToInt(body, offset++, 1);
            if ((smLength = SMPPIO.bytesToInt(body, offset++, 1)) > 0) {
                this.message = new byte[smLength];
                System.arraycopy(body, offset, this.message, 0, smLength);
            }
        }
        catch (InvalidDateFormatException x) {
            throw new SMPPProtocolException("Unrecognized date format", x);
        }
    }

    public String toString() {
        return new String("replace_sm");
    }
}

