/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp;

import ie.omk.smpp.AlreadyBoundException;
import ie.omk.smpp.BadCommandIDException;
import ie.omk.smpp.InvalidOperationException;
import ie.omk.smpp.NotBoundException;
import ie.omk.smpp.SMPPException;
import ie.omk.smpp.SMPPRuntimeException;
import ie.omk.smpp.UnsupportedOperationException;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.EventDispatcher;
import ie.omk.smpp.event.ReceiverExceptionEvent;
import ie.omk.smpp.event.ReceiverExitEvent;
import ie.omk.smpp.event.ReceiverStartEvent;
import ie.omk.smpp.event.SimpleEventDispatcher;
import ie.omk.smpp.message.Bind;
import ie.omk.smpp.message.BindResp;
import ie.omk.smpp.message.DeliverSM;
import ie.omk.smpp.message.DeliverSMResp;
import ie.omk.smpp.message.EnquireLink;
import ie.omk.smpp.message.EnquireLinkResp;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.message.Unbind;
import ie.omk.smpp.message.UnbindResp;
import ie.omk.smpp.message.tlv.Tag;
import ie.omk.smpp.net.SmscLink;
import ie.omk.smpp.net.TcpLink;
import ie.omk.smpp.util.APIConfig;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.DefaultSequenceScheme;
import ie.omk.smpp.util.PacketFactory;
import ie.omk.smpp.util.PropertyNotFoundException;
import ie.omk.smpp.util.SMPPIO;
import ie.omk.smpp.util.SequenceNumberScheme;
import ie.omk.smpp.version.SMPPVersion;
import ie.omk.smpp.version.VersionException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Connection
implements Runnable {
    public static final int TRANSMITTER = 1;
    public static final int RECEIVER = 2;
    public static final int TRANSCEIVER = 3;
    public static final int UNBOUND = 0;
    public static final int BINDING = 1;
    public static final int BOUND = 2;
    public static final int UNBINDING = 3;
    private static final Log LOGGER = LogFactory.getLog((Class)Connection.class);
    private int connectionType;
    private Thread rcvThread;
    private List packetQueue;
    private EventDispatcher eventDispatcher;
    private byte[] buf = new byte[300];
    private SequenceNumberScheme seqNumScheme = new DefaultSequenceScheme();
    private SmscLink link;
    protected SMPPVersion interfaceVersion = SMPPVersion.getDefaultVersion();
    protected boolean supportOptionalParams = true;
    private transient int state = 0;
    protected boolean ackQryLinks = true;
    protected boolean ackDeliverSm;
    protected boolean asyncComms;
    protected AlphabetEncoding defaultAlphabet;

    public Connection(String host, int port) throws UnknownHostException {
        this(new TcpLink(host, port), false);
    }

    public Connection(String host, int port, boolean async) throws UnknownHostException {
        this(new TcpLink(host, port), async);
    }

    public Connection(SmscLink link) {
        this(link, false);
    }

    public Connection(SmscLink link, boolean async) {
        this.link = link;
        this.asyncComms = async;
        if (this.asyncComms) {
            this.initAsyncComms();
        } else {
            this.initSyncComms();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAsyncComms() {
        String className = "";
        try {
            className = APIConfig.getInstance().getProperty("smppapi.event.dispatcher");
            if (className != null && !"".equals(className)) {
                Class<?> cl = Class.forName(className);
                Constructor<?> ctr = cl.getConstructor(new Class[0]);
                this.eventDispatcher = (EventDispatcher)ctr.newInstance(new Object[0]);
            } else {
                LOGGER.info((Object)"EventDispatcher property value is empty.");
            }
        }
        catch (PropertyNotFoundException x) {
            LOGGER.debug((Object)"No event dispatcher specified in properties. Using default.");
        }
        catch (ClassNotFoundException x) {
            LOGGER.error((Object)("Cannot locate event dispatcher class " + className), (Throwable)x);
        }
        catch (ClassCastException x) {
            LOGGER.error((Object)(className + " does not implement the EventDispatcher interface."), (Throwable)x);
        }
        catch (NoSuchMethodException x) {
            LOGGER.error((Object)(className + " does not have a no-argument constructor."));
        }
        catch (IllegalAccessException x) {
            LOGGER.error((Object)(className + " constructor is not visible."), (Throwable)x);
        }
        catch (IllegalArgumentException x) {
            LOGGER.error((Object)"Internal error in the SMPPAPI. Please inform the maintainer.", (Throwable)x);
        }
        catch (InstantiationException x) {
            LOGGER.error((Object)("Could not instantiate an instance of " + className), (Throwable)x);
        }
        catch (InvocationTargetException x) {
            LOGGER.error((Object)(className + " constructor threw an exception."), (Throwable)x);
        }
        finally {
            if (this.eventDispatcher == null) {
                this.eventDispatcher = new SimpleEventDispatcher();
            }
        }
        LOGGER.info((Object)("Using event dispatcher " + this.eventDispatcher.getClass().getName()));
        this.eventDispatcher.init();
        this.createRecvThread();
    }

    private void initSyncComms() {
        this.packetQueue = new ArrayList();
    }

    private void createRecvThread() {
        LOGGER.info((Object)"Creating receiver thread");
        this.rcvThread = new Thread((Runnable)this, "ReceiverDaemon");
        this.rcvThread.setDaemon(true);
    }

    public void setDefaultAlphabet(AlphabetEncoding alphabet) {
        this.defaultAlphabet = alphabet;
    }

    public AlphabetEncoding getDefaultAlphabet() {
        return this.defaultAlphabet;
    }

    private void setState(int state) {
        LOGGER.info((Object)("Setting state " + state));
        this.state = state;
    }

    public void setVersion(SMPPVersion version) throws VersionException {
        if (this.getState() != 0) {
            throw new VersionException("Cannot set SMPP version after binding");
        }
        this.interfaceVersion = version == null ? SMPPVersion.getDefaultVersion() : version;
    }

    public SMPPVersion getVersion() {
        return this.interfaceVersion;
    }

    public int getState() {
        return this.state;
    }

    protected void openLink() throws IOException {
        if (!this.link.isConnected()) {
            LOGGER.info((Object)"Opening network link.");
            this.link.open();
        } else {
            LOGGER.debug((Object)"openLink called, link already open");
        }
    }

    public void closeLink() throws IOException {
        if (this.getState() != 0) {
            throw new IllegalStateException("Cannot close the link while bound to the SMSC");
        }
        if (this.link.isConnected()) {
            LOGGER.info((Object)"Shutting down the network link");
            this.link.close();
        } else {
            LOGGER.debug((Object)"closeLink called on an unopen connection");
        }
    }

    public SMPPVersion getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public void setInterfaceVersion(SMPPVersion interfaceVersion) {
        LOGGER.info((Object)("setInterfaceVersion " + interfaceVersion));
        this.interfaceVersion = interfaceVersion;
        this.supportOptionalParams = interfaceVersion.isSupportOptionalParams();
    }

    public void autoAckLink(boolean b) {
        if (this.asyncComms) {
            this.ackQryLinks = b;
        }
    }

    public void autoAckMessages(boolean b) {
        if (this.asyncComms) {
            this.ackDeliverSm = b;
        }
    }

    public boolean isAckingLinks() {
        return this.ackQryLinks;
    }

    public boolean isAckingMessages() {
        return this.ackDeliverSm;
    }

    public void ackDeliverSm(DeliverSM rq) throws IOException {
        DeliverSMResp rsp = new DeliverSMResp(rq);
        this.sendResponse(rsp);
        LOGGER.info((Object)"deliver_sm_resp sent.");
    }

    public SMPPResponse sendRequest(SMPPRequest request) throws SocketTimeoutException, IOException, AlreadyBoundException, VersionException, SMPPProtocolException, UnsupportedOperationException {
        int id = request.getCommandId();
        if (this.state != 2) {
            throw new NotBoundException("Must be bound to the SMSC before sending packets");
        }
        if (id == 1 || id == 9 || id == 2 || id == 6) {
            throw new UnsupportedOperationException("You must use the bind and unbind methods to send those requests");
        }
        if (this.connectionType == 2 && id != 21) {
            throw new UnsupportedOperationException("Operation not permitted over receiver connection");
        }
        return this.sendRequestInternal(request);
    }

    protected SMPPResponse sendRequestInternal(SMPPRequest r) throws SocketTimeoutException, IOException, AlreadyBoundException, VersionException, SMPPProtocolException {
        SMPPResponse resp = null;
        if (this.link == null) {
            throw new IOException("No SMSC connection.");
        }
        this.processOutboundPacket(r);
        this.link.write(r, this.supportOptionalParams);
        if (!this.asyncComms) {
            resp = this.waitForResponsePacket(r);
        }
        return resp;
    }

    protected SMPPResponse waitForResponsePacket(SMPPPacket req) throws SocketTimeoutException, IOException, SMPPProtocolException {
        try {
            SMPPPacket resp = null;
            int expectedSeq = req.getSequenceNum();
            while ((resp = this.readNextPacketInternal()).isRequest() || resp.getSequenceNum() != expectedSeq) {
                LOGGER.info((Object)"Queuing unexpected sequence numbered packet.");
                if (LOGGER.isDebugEnabled()) {
                    StringBuffer err = new StringBuffer("Expected:").append(expectedSeq).append(" but got ").append(resp.getSequenceNum()).append(" type: 0x").append(Integer.toHexString(resp.getCommandId()));
                    LOGGER.debug((Object)err.toString());
                }
                this.packetQueue.add(resp);
            }
            return (SMPPResponse)resp;
        }
        catch (SocketTimeoutException x) {
            LOGGER.error((Object)"Received a socket timeout exception", (Throwable)x);
            throw x;
        }
    }

    public int packetAvailable() {
        int ret = 0;
        if (!this.asyncComms) {
            if (this.packetQueue.size() > 0) {
                ret = 2;
            } else if (this.link.available() > 0) {
                ret = 1;
            }
        }
        return ret;
    }

    public void sendResponse(SMPPResponse resp) throws IOException {
        if (this.link == null) {
            throw new IOException("Connection to SMSC is not valid.");
        }
        try {
            this.link.write(resp, this.supportOptionalParams);
        }
        catch (SocketTimeoutException x) {
            LOGGER.warn((Object)"Got a socket timeout exception", (Throwable)x);
            this.setState(0);
            throw x;
        }
        this.processOutboundPacket(resp);
    }

    public BindResp bind(int type, String systemID, String password, String systemType) throws IOException, InvalidParameterValueException, IllegalArgumentException, AlreadyBoundException, VersionException, SMPPProtocolException {
        return this.bind(type, systemID, password, systemType, 0, 0, null);
    }

    public BindResp bind(int type, String systemID, String password, String systemType, int typeOfNum, int numberPlan, String addrRange) throws IOException, InvalidParameterValueException, IllegalArgumentException, AlreadyBoundException, VersionException, SMPPProtocolException {
        Bind bindReq = null;
        if (this.seqNumScheme != null) {
            this.seqNumScheme.reset();
        }
        if (!this.asyncComms) {
            this.ackQryLinks = false;
            this.ackDeliverSm = false;
        }
        try {
            switch (type) {
                case 1: {
                    bindReq = (Bind)this.newInstance(2);
                    break;
                }
                case 2: {
                    bindReq = (Bind)this.newInstance(1);
                    break;
                }
                case 3: {
                    if (this.interfaceVersion.isOlder(SMPPVersion.V34)) {
                        throw new VersionException("Cannot bind as transceiver in " + this.interfaceVersion.toString());
                    }
                    bindReq = (Bind)this.newInstance(9);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No such connection type.");
                }
            }
        }
        catch (BadCommandIDException x) {
            LOGGER.error((Object)"Internal error in the smppapi. Please inform the maintainer.", (Throwable)x);
        }
        this.connectionType = type;
        LOGGER.info((Object)("Binding to the SMSC as type " + type));
        bindReq.setVersion(this.interfaceVersion);
        bindReq.setSystemId(systemID);
        bindReq.setPassword(password);
        bindReq.setSystemType(systemType);
        bindReq.setAddressTon(typeOfNum);
        bindReq.setAddressNpi(numberPlan);
        bindReq.setAddressRange(addrRange);
        return (BindResp)this.sendRequestInternal(bindReq);
    }

    public UnbindResp unbind() throws IOException, NotBoundException, SMPPProtocolException {
        if (this.state != 2 || !this.link.isConnected()) {
            throw new NotBoundException();
        }
        try {
            LOGGER.info((Object)"Unbinding from the SMSC");
            Unbind u = (Unbind)this.newInstance(6);
            return (UnbindResp)this.sendRequestInternal(u);
        }
        catch (BadCommandIDException x) {
            throw new SMPPRuntimeException("Internal smppapi error");
        }
    }

    public void unbind(UnbindResp ubr) throws IOException, SMPPException {
        if (this.state != 3) {
            throw new NotBoundException("Link is not connected.");
        }
        if (!this.link.isConnected()) {
            throw new AlreadyBoundException("No unbind request received.");
        }
        this.sendResponse(ubr);
    }

    public void force_unbind() {
        LOGGER.warn((Object)"Attempting to force SMPP connection down.");
        try {
            this.setState(0);
            Thread.yield();
            if (this.rcvThread != null && this.rcvThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException x) {
                    LOGGER.debug((Object)"Interrupted exception waiting on receiver to die", (Throwable)x);
                }
                if (this.rcvThread != null) {
                    LOGGER.error((Object)"Listener thread has not died.");
                }
                this.rcvThread = null;
            }
            this.link.close();
        }
        catch (Throwable t) {
            LOGGER.warn((Object)"Exception when trying to force unbind", t);
        }
    }

    public void ackEnquireLink(EnquireLink rq) throws IOException {
        EnquireLinkResp resp = new EnquireLinkResp(rq);
        this.sendResponse(resp);
        LOGGER.info((Object)"enquire_link_resp sent.");
    }

    public EnquireLinkResp enquireLink() throws IOException, SMPPProtocolException {
        try {
            EnquireLink s = (EnquireLink)this.newInstance(21);
            SMPPResponse resp = this.sendRequest(s);
            LOGGER.debug((Object)"enquire_link request sent.");
            if (resp != null) {
                LOGGER.debug((Object)"enquire_link_response received.");
            }
            return (EnquireLinkResp)resp;
        }
        catch (BadCommandIDException x) {
            throw new SMPPRuntimeException("Internal smppapi error");
        }
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public boolean isBound() {
        return this.state == 2;
    }

    public void reset() throws AlreadyBoundException {
        if (this.state == 2) {
            LOGGER.warn((Object)"Attempt to reset sequence numbering on a bound connection");
            throw new AlreadyBoundException("Cannot reset connection while bound");
        }
        if (this.seqNumScheme != null) {
            this.seqNumScheme.reset();
        }
        LOGGER.info((Object)"Sequence numbering reset.");
    }

    public void setSeqNumScheme(SequenceNumberScheme scheme) {
        this.seqNumScheme = scheme;
    }

    public SequenceNumberScheme getSeqNumScheme() {
        return this.seqNumScheme;
    }

    public SMPPPacket readNextPacket() throws IOException, InvalidOperationException, SMPPProtocolException {
        if (this.asyncComms) {
            throw new InvalidOperationException("Asynchronous comms in use.");
        }
        if (this.packetQueue.size() > 0) {
            return (SMPPPacket)this.packetQueue.remove(0);
        }
        return this.readNextPacketInternal();
    }

    private SMPPPacket readNextPacketInternal() throws IOException, SMPPProtocolException {
        try {
            SMPPPacket pak = null;
            int id = -1;
            this.buf = this.link.read(this.buf);
            id = SMPPIO.bytesToInt(this.buf, 4, 4);
            pak = PacketFactory.newInstance(id);
            if (pak != null) {
                pak.readFrom(this.buf, 0);
                if (LOGGER.isDebugEnabled()) {
                    StringBuffer b = new StringBuffer("Packet Received: ");
                    int l = pak.getLength();
                    int s = pak.getCommandStatus();
                    int n = pak.getSequenceNum();
                    b.append("id:").append(Integer.toHexString(id)).append(" len:").append(Integer.toString(l)).append(" st:").append(Integer.toString(s)).append(" sq:").append(Integer.toString(n));
                    LOGGER.debug((Object)b.toString());
                }
                this.processInboundPacket(pak);
            }
            return pak;
        }
        catch (BadCommandIDException x) {
            throw new SMPPProtocolException("Unrecognised command received", x);
        }
    }

    private void processOutboundPacket(SMPPPacket packet) throws IOException {
        int id = packet.getCommandId();
        if (!this.interfaceVersion.isSupported(id)) {
            StringBuffer err = new StringBuffer(120).append(this.interfaceVersion.toString()).append(" does not support command ID 0x").append(Integer.toHexString(id));
            throw new VersionException(err.toString());
        }
        switch (id) {
            case 1: 
            case 2: 
            case 9: {
                this.processOutboundBind((Bind)packet);
                break;
            }
            case 6: {
                this.processOutboundUnbind((Unbind)packet);
                break;
            }
            case -2147483642: {
                this.processOutboundUnbindResp((UnbindResp)packet);
            }
        }
    }

    private void processOutboundBind(Bind bindRequest) throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException("Cannot bind while in state " + this.state);
        }
        try {
            int bindTimeout = APIConfig.getInstance().getInt("smppapi.connection.bind_timeout", 0);
            if (bindTimeout > 0) {
                this.link.setTimeout(bindTimeout);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Set bind timeout to " + bindTimeout));
                }
            }
        }
        catch (UnsupportedOperationException x) {
            LOGGER.warn((Object)"Link does not support read timeouts - bind timeout will not work");
        }
        catch (java.lang.UnsupportedOperationException x) {
            LOGGER.warn((Object)"Link does not support read timeouts - bind timeout will not work");
        }
        this.openLink();
        this.setState(1);
        if (this.asyncComms) {
            if (this.rcvThread == null) {
                this.createRecvThread();
            }
            if (!this.rcvThread.isAlive()) {
                this.rcvThread.start();
            }
        }
    }

    private void processOutboundUnbind(Unbind unbind) {
        if (!this.asyncComms && this.packetQueue.size() > 0) {
            throw new IllegalStateException("Cannot unbind while there are incoming packets awaiting responses");
        }
        if (this.state != 2) {
            throw new IllegalStateException("Not currently bound");
        }
        this.setState(3);
    }

    private void processOutboundUnbindResp(UnbindResp unbindResp) {
        if (unbindResp.getCommandStatus() == 0) {
            this.setState(0);
        }
    }

    private void processInboundPacket(SMPPPacket packet) throws IOException {
        switch (packet.getCommandId()) {
            case -2147483647: 
            case -2147483646: 
            case -2147483639: {
                this.processInboundBindResp((BindResp)packet);
                break;
            }
            case -2147483642: {
                this.processInboundUnbindResp((UnbindResp)packet);
                break;
            }
            case 6: {
                this.processInboundUnbind((Unbind)packet);
                break;
            }
            case 5: {
                if (!this.ackDeliverSm) break;
                this.ackDeliverSm((DeliverSM)packet);
                break;
            }
            case 21: {
                if (!this.ackQryLinks) break;
                this.ackEnquireLink((EnquireLink)packet);
            }
        }
        if (packet.getCommandStatus() == 0 && this.defaultAlphabet != null && packet.getDataCoding() == 0) {
            packet.setAlphabet(this.defaultAlphabet);
        }
    }

    private void processInboundBindResp(BindResp resp) {
        int st = resp.getCommandStatus();
        if (this.state != 1) {
            throw new IllegalStateException("A bind response was received in bound state " + this.state);
        }
        if (st != 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Bind failed. Setting state to unbound.");
            }
            try {
                this.setState(0);
                this.link.close();
            }
            catch (IOException x) {
                LOGGER.warn((Object)"I/O Exception shutting down link after failed bind.", (Throwable)x);
            }
            return;
        }
        this.setState(2);
        Number n = (Number)resp.getOptionalParameter(Tag.SC_INTERFACE_VERSION);
        if (n != null) {
            SMPPVersion smscVersion = SMPPVersion.getVersion(n.intValue());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("SMSC reports its supported SMPP version as " + smscVersion.toString()));
            }
            if (smscVersion.isOlder(this.interfaceVersion)) {
                LOGGER.info((Object)("Downgrading this connection's SMPP version to " + smscVersion.toString()));
                this.setInterfaceVersion(smscVersion);
            }
        } else {
            this.supportOptionalParams = false;
            LOGGER.warn((Object)"Disabling optional parameter support as no sc_interface_version parameter was received");
        }
        try {
            int linkTimeout = APIConfig.getInstance().getInt("smppapi.net.link_timeout");
            this.link.setTimeout(linkTimeout);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Set the link timeout to " + linkTimeout));
            }
        }
        catch (PropertyNotFoundException x) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"No link timeout specified in configuration");
            }
        }
        catch (java.lang.UnsupportedOperationException x) {
            LOGGER.warn((Object)"Configuration specified a link timeout but the link implementation does not support it");
        }
    }

    private void processInboundUnbind(Unbind req) {
        LOGGER.info((Object)"SMSC requested unbind");
        this.setState(3);
    }

    private void processInboundUnbindResp(UnbindResp resp) {
        if (this.state == 3 && resp.getCommandStatus() == 0) {
            LOGGER.info((Object)"Successfully unbound");
            this.setState(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        if (eventDispatcher == null) {
            throw new NullPointerException("Event dispatcher cannot be null");
        }
        eventDispatcher.init();
        EventDispatcher eventDispatcher2 = this.eventDispatcher;
        synchronized (eventDispatcher2) {
            Iterator iter = this.eventDispatcher.observerIterator();
            while (iter.hasNext()) {
                eventDispatcher.addObserver((ConnectionObserver)iter.next());
            }
        }
        EventDispatcher old = this.eventDispatcher;
        this.eventDispatcher = eventDispatcher;
        old.destroy();
    }

    public void addObserver(ConnectionObserver ob) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addObserver(ob);
        }
    }

    public void removeObserver(ConnectionObserver ob) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeObserver(ob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SMPPPacket pak = null;
        int smppEx = 0;
        ReceiverExitEvent exitEvent = null;
        int tooManyIOEx = 5;
        LOGGER.info((Object)"Receiver thread started");
        APIConfig cfg = APIConfig.getInstance();
        try {
            tooManyIOEx = cfg.getInt("smppapi.connection.rcv_daemon.ioex_count");
        }
        catch (PropertyNotFoundException x) {
            LOGGER.debug((Object)("Didn't find I/O exception config. Using default of " + tooManyIOEx));
        }
        this.eventDispatcher.notifyObservers(this, new ReceiverStartEvent(this));
        try {
            while (this.state != 0) {
                try {
                    pak = this.readNextPacketInternal();
                    if (pak == null) {
                        LOGGER.warn((Object)"Received an unidentified packet from the SMSC");
                        continue;
                    }
                }
                catch (SocketTimeoutException x) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Caught a socket timeout exception: " + x.getMessage()));
                    }
                    if (this.state == 1) {
                        LOGGER.debug((Object)"Bind timeout.");
                        exitEvent = new ReceiverExitEvent(this, null, this.state);
                        exitEvent.setReason(1);
                        this.setState(0);
                        continue;
                    }
                    this.eventDispatcher.notifyObservers(this, new ReceiverExceptionEvent(this, x));
                    continue;
                }
                catch (IOException x) {
                    LOGGER.warn((Object)"I/O Exception caught", (Throwable)x);
                    ReceiverExceptionEvent ev = new ReceiverExceptionEvent(this, x, this.state);
                    this.eventDispatcher.notifyObservers(this, ev);
                    if (++smppEx <= tooManyIOEx) continue;
                    LOGGER.warn((Object)"Too many IOExceptions in receiver thread", (Throwable)x);
                    throw x;
                }
                smppEx = 0;
                LOGGER.info((Object)"Notifying observers of packet received");
                this.eventDispatcher.notifyObservers(this, pak);
            }
            if (exitEvent == null) {
                exitEvent = new ReceiverExitEvent(this, null, this.state);
            }
        }
        catch (Exception x) {
            LOGGER.debug((Object)("Fatal exception in receiver thread: " + x.getMessage()), (Throwable)x);
            exitEvent = new ReceiverExitEvent(this, x, this.state);
            this.setState(0);
        }
        finally {
            this.rcvThread = null;
        }
        if (exitEvent != null) {
            this.eventDispatcher.notifyObservers(this, exitEvent);
        }
        this.eventDispatcher.destroy();
    }

    public void ackLinkQuery(EnquireLink el) throws IOException {
        this.ackEnquireLink(el);
    }

    public SMPPPacket newInstance(int commandId) throws BadCommandIDException, VersionException {
        if (!this.interfaceVersion.isSupported(commandId)) {
            throw new VersionException("Command is not supported in this SMPP version");
        }
        SMPPPacket response = PacketFactory.newInstance(commandId);
        response.setVersion(this.interfaceVersion);
        if (this.seqNumScheme != null) {
            response.setSequenceNum(this.seqNumScheme.nextNumber());
        }
        if (this.defaultAlphabet != null) {
            response.setAlphabet(this.defaultAlphabet, 0);
        }
        return response;
    }
}

