/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript.params;

import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ftinc.canvasscript.params.CanvasParams;

public class PictureParams
implements CanvasParams {
    private final Picture picture;
    @Nullable
    private final Rect dest;
    @Nullable
    private final RectF destF;

    public PictureParams(@NonNull Picture picture) {
        this.picture = picture;
        this.dest = null;
        this.destF = null;
    }

    public PictureParams(@NonNull Picture picture, @NonNull Rect dest) {
        this.picture = picture;
        this.dest = dest;
        this.destF = null;
    }

    public PictureParams(@NonNull Picture picture, @NonNull RectF destF) {
        this.picture = picture;
        this.destF = destF;
        this.dest = null;
    }

    @Override
    public int draw(Canvas canvas) {
        if (this.destF != null) {
            canvas.drawPicture(this.picture, this.destF);
        } else if (this.dest != null) {
            canvas.drawPicture(this.picture, this.dest);
        } else {
            canvas.drawPicture(this.picture);
        }
        return -1;
    }
}

