/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.canvasscript.params;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ftinc.canvasscript.params.CanvasParams;

public class BitmapParams
implements CanvasParams {
    private final Bitmap bitmap;
    private final float left;
    private final float top;
    @Nullable
    private final Rect src;
    @Nullable
    private final Rect dest;
    @Nullable
    private final RectF destF;
    @Nullable
    private final Matrix matrix;
    @Nullable
    private final Paint paint;

    public BitmapParams(@NonNull Bitmap bitmap, float left, float top, @Nullable Paint paint) {
        this.bitmap = bitmap;
        this.left = left;
        this.top = top;
        this.paint = paint;
        this.src = null;
        this.dest = null;
        this.destF = null;
        this.matrix = null;
    }

    public BitmapParams(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull Rect dest, @Nullable Paint paint) {
        this.bitmap = bitmap;
        this.src = src;
        this.dest = dest;
        this.paint = paint;
        this.left = -1.0f;
        this.top = -1.0f;
        this.destF = null;
        this.matrix = null;
    }

    public BitmapParams(@NonNull Bitmap bitmap, @Nullable Rect src, @NonNull RectF dest, @Nullable Paint paint) {
        this.bitmap = bitmap;
        this.src = src;
        this.destF = dest;
        this.paint = paint;
        this.dest = null;
        this.matrix = null;
        this.left = -1.0f;
        this.top = -1.0f;
    }

    public BitmapParams(@NonNull Bitmap bitmap, @NonNull Matrix matrix, @Nullable Paint paint) {
        this.bitmap = bitmap;
        this.matrix = matrix;
        this.paint = paint;
        this.left = -1.0f;
        this.top = -1.0f;
        this.src = null;
        this.dest = null;
        this.destF = null;
    }

    @Override
    public int draw(Canvas canvas) {
        if (this.matrix != null) {
            canvas.drawBitmap(this.bitmap, this.matrix, this.paint);
        } else if (this.destF != null) {
            canvas.drawBitmap(this.bitmap, this.src, this.destF, this.paint);
        } else if (this.dest != null) {
            canvas.drawBitmap(this.bitmap, this.src, this.dest, this.paint);
        } else {
            canvas.drawBitmap(this.bitmap, this.left, this.top, this.paint);
        }
        return -1;
    }
}

