/*
 * Decompiled with CFR 0.152.
 */
package com.andrefilgs.fileman.workmanager.workers;

import androidx.work.Data;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkRequest;
import com.andrefilgs.fileman.auxiliar.ExtensionsKt;
import com.andrefilgs.fileman.workmanager.FilemanManager;
import com.andrefilgs.fileman.workmanager.workers.CoroutineFilemanWorker;
import com.andrefilgs.fileman.workmanager.workers.FinalWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/andrefilgs/fileman/workmanager/workers/WorkRequestFactory;", "", "()V", "Companion", "fileman_release"})
public final class WorkRequestFactory {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jk\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014J0\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\b\u00a8\u0006\u001b"}, d2={"Lcom/andrefilgs/fileman/workmanager/workers/WorkRequestFactory$Companion;", "", "()V", "buildFilemanWorkerRequest", "Landroidx/work/OneTimeWorkRequest;", "command", "", "now", "", "filemanUniqueId", "tag", "fileContent", "drive", "", "folder", "filename", "append", "", "withTimeout", "timeout", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;ZJ)Landroidx/work/OneTimeWorkRequest;", "buildFinalWorker", "cmd", "fileFullPath", "generateFilemanUniqueId", "filenameFullPath", "timestamp", "fileman_release"})
    public static final class Companion {
        @NotNull
        public final String generateFilemanUniqueId(@NotNull String filenameFullPath, long timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)filenameFullPath, (String)"filenameFullPath");
            return filenameFullPath + "_" + String.valueOf(timestamp);
        }

        @NotNull
        public final OneTimeWorkRequest buildFinalWorker(long now, @NotNull String cmd, @NotNull String filemanUniqueId, @NotNull String fileFullPath, @Nullable String fileContent) {
            Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
            Intrinsics.checkParameterIsNotNull((Object)filemanUniqueId, (String)"filemanUniqueId");
            Intrinsics.checkParameterIsNotNull((Object)fileFullPath, (String)"fileFullPath");
            Data.Builder inputData = new Data.Builder();
            ExtensionsKt.putInitTime(inputData, now);
            ExtensionsKt.putFilemanCommand(inputData, cmd);
            ExtensionsKt.putFilemanUniqueID(inputData, filemanUniqueId);
            ExtensionsKt.putFileFullPath(inputData, fileFullPath);
            FilemanManager.Companion.putFileContent$fileman_release(filemanUniqueId, fileContent);
            WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(FinalWorker.class).addTag(filemanUniqueId + "WORK_TAG_FINAL")).setInputData(inputData.build())).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"OneTimeWorkRequest.Build\u2026build())\n        .build()");
            return (OneTimeWorkRequest)workRequest;
        }

        @NotNull
        public final OneTimeWorkRequest buildFilemanWorkerRequest(@NotNull String command, long now, @NotNull String filemanUniqueId, @Nullable String tag, @Nullable String fileContent, int drive, @NotNull String folder, @NotNull String filename, @Nullable Boolean append, boolean withTimeout, long timeout) {
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            Intrinsics.checkParameterIsNotNull((Object)filemanUniqueId, (String)"filemanUniqueId");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            Data.Builder inputData = new Data.Builder();
            ExtensionsKt.putFilemanCommand(inputData, command);
            ExtensionsKt.putInitTime(inputData, now);
            ExtensionsKt.putFilemanUniqueID(inputData, filemanUniqueId);
            ExtensionsKt.putDrive(inputData, drive);
            ExtensionsKt.putFolder(inputData, folder);
            ExtensionsKt.putFilename(inputData, filename);
            ExtensionsKt.putAppend(inputData, append);
            ExtensionsKt.putWithTimeout(inputData, withTimeout);
            ExtensionsKt.putTimeout(inputData, timeout);
            FilemanManager.Companion.putFileContent$fileman_release(filemanUniqueId, fileContent);
            OneTimeWorkRequest.Builder builder = new OneTimeWorkRequest.Builder(CoroutineFilemanWorker.class);
            String string = tag;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)builder.addTag(string)).setInputData(inputData.build())).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"OneTimeWorkRequest.Build\u2026build())\n        .build()");
            return (OneTimeWorkRequest)workRequest;
        }

        public static /* synthetic */ OneTimeWorkRequest buildFilemanWorkerRequest$default(Companion companion, String string, long l, String string2, String string3, String string4, int n, String string5, String string6, Boolean bl, boolean bl2, long l2, int n2, Object object) {
            if ((n2 & 8) != 0) {
                string3 = "WORK_TAG_WRITE";
            }
            return companion.buildFilemanWorkerRequest(string, l, string2, string3, string4, n, string5, string6, bl, bl2, l2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

