/*
 * Decompiled with CFR 0.152.
 */
package com.andrefilgs.fileman.workmanager.workers;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.andrefilgs.fileman.auxiliar.ExtensionsKt;
import com.andrefilgs.fileman.auxiliar.FilemanLogger;
import com.andrefilgs.fileman.workmanager.FilemanManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/andrefilgs/fileman/workmanager/workers/FinalWorker;", "Landroidx/work/Worker;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "onStopped", "", "fileman_release"})
public final class FinalWorker
extends Worker {
    @NotNull
    public ListenableWorker.Result doWork() {
        ListenableWorker.Result result;
        try {
            long initTime = ExtensionsKt.getInitTime((ListenableWorker)this);
            String filemanUniqueId = ExtensionsKt.getFilemanUniqueId((ListenableWorker)this);
            String fileFullPath = ExtensionsKt.getFileFullPath((ListenableWorker)this);
            String string = FilemanManager.Companion.getFileContent$fileman_release(filemanUniqueId);
            if (string == null) {
                string = "";
            }
            String fileContent = string;
            String filemanCommand = ExtensionsKt.getFilemanCommand((ListenableWorker)this);
            long deltaTime = System.currentTimeMillis() - initTime;
            Data data = ExtensionsKt.putFileFullPath(ExtensionsKt.putFilemanUniqueID(ExtensionsKt.putEllapsedTime(ExtensionsKt.putFilemanCommand(ExtensionsKt.putIsFinalWorker(new Data.Builder(), true), filemanCommand), deltaTime), filemanUniqueId), fileFullPath).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"Data.Builder()\n        .\u2026ager DTO\n        .build()");
            Data outputData = data;
            String string2 = filemanUniqueId;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            FilemanManager.Companion.putFileContent$fileman_release(string2, fileContent);
            ListenableWorker.Result result2 = ListenableWorker.Result.success((Data)outputData);
            Intrinsics.checkExpressionValueIsNotNull((Object)result2, (String)"Result.success(outputData)");
            result = result2;
        }
        catch (InterruptedException e) {
            FilemanLogger.dbc$fileman_release$default(FilemanLogger.INSTANCE, "<init>" + " - " + e.getMessage(), null, 2, null);
            ListenableWorker.Result result3 = ListenableWorker.Result.retry();
            Intrinsics.checkExpressionValueIsNotNull((Object)result3, (String)"Result.retry()");
            result = result3;
        }
        return result;
    }

    public void onStopped() {
        super.onStopped();
        FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "<init>" + " stopped", null, 2, null);
    }

    public FinalWorker(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
    }
}

