/*
 * Decompiled with CFR 0.152.
 */
package co.unruly.matchers;

import java.time.Period;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class TimeMatchers {
    public static <T extends Comparable<T> & Temporal> Matcher<T> after(final T time) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T actual) {
                return actual.compareTo((Comparable)time) > 0;
            }

            public void describeTo(Description description) {
                description.appendText("after ").appendValue((Object)time);
            }
        };
    }

    public static <T extends Comparable<T> & Temporal> Matcher<T> before(final T time) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T actual) {
                return actual.compareTo((Comparable)time) < 0;
            }

            public void describeTo(Description description) {
                description.appendText("before ").appendValue((Object)time);
            }
        };
    }

    public static <T extends Comparable<T>> Matcher<T> between(final T earlierOrEqual, final T laterOrEqual) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T actual) {
                return actual.compareTo((Comparable)earlierOrEqual) >= 0 && actual.compareTo((Comparable)laterOrEqual) <= 0;
            }

            public void describeTo(Description description) {
                description.appendText("between ").appendValue((Object)earlierOrEqual).appendText(" and ").appendValue((Object)laterOrEqual).appendText(" inclusive");
            }
        };
    }

    public static <T extends Comparable<T> & TemporalAmount> Matcher<T> longerThan(final T amount) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T actual) {
                return actual.compareTo((Comparable)amount) > 0;
            }

            public void describeTo(Description description) {
                description.appendText("longer than ").appendValue((Object)amount);
            }
        };
    }

    public static <T extends Comparable<T> & TemporalAmount> Matcher<T> shorterThan(final T amount) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T actual) {
                return actual.compareTo((Comparable)amount) < 0;
            }

            public void describeTo(Description description) {
                description.appendText("shorter than ").appendValue((Object)amount);
            }
        };
    }

    public static Matcher<Period> matches(final Matcher<Integer> yearsMatcher, final Matcher<Integer> monthsMatcher, final Matcher<Integer> daysMatcher) {
        return new TypeSafeMatcher<Period>(){

            protected boolean matchesSafely(Period item) {
                return yearsMatcher.matches((Object)item.getYears()) && monthsMatcher.matches((Object)item.getMonths()) && daysMatcher.matches((Object)item.getDays());
            }

            public void describeTo(Description description) {
                description.appendText("a Period with years matching ").appendValue((Object)yearsMatcher).appendText(" months matching ").appendValue((Object)yearsMatcher).appendText(" and days matching ").appendValue((Object)daysMatcher);
            }
        };
    }
}

