/*
 * Decompiled with CFR 0.152.
 */
package co.unruly.matchers;

import co.unruly.matchers.function.DescribableFunction;
import co.unruly.matchers.function.DescribablePredicate;
import co.unruly.matchers.internal.DescriptionUtils;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class Java8Matchers {
    public static <I, O> Matcher<I> whereNot(DescribablePredicate<? super I> booleanProperty) {
        return Java8Matchers.whereNot(booleanProperty.getResultDescription(), booleanProperty);
    }

    public static <I, O> Matcher<I> whereNot(String propertyDescription, DescribablePredicate<? super I> booleanProperty) {
        String entityDescription = booleanProperty.getArgumentDescription();
        return Java8Matchers.where(entityDescription, propertyDescription, booleanProperty::test, CoreMatchers.is((Object)false));
    }

    public static <I, O> Matcher<I> where(DescribablePredicate<? super I> booleanProperty) {
        return Java8Matchers.where(booleanProperty.getResultDescription(), booleanProperty);
    }

    public static <I, O> Matcher<I> where(String propertyDescription, DescribablePredicate<? super I> booleanProperty) {
        String entityDescription = booleanProperty.getArgumentDescription();
        return Java8Matchers.where(entityDescription, propertyDescription, booleanProperty::test, CoreMatchers.is((Object)true));
    }

    public static <I, O> Matcher<I> where(DescribableFunction<? super I, O> property, Matcher<? super O> matcher) {
        String propertyDescription = property.getResultDescription();
        return Java8Matchers.where(propertyDescription, property, matcher);
    }

    public static <I, O> Matcher<I> where(String propertyDescription, DescribableFunction<? super I, O> property, Matcher<? super O> matcher) {
        String entityDescription = property.getArgumentDescription();
        return Java8Matchers.where(entityDescription, propertyDescription, property, matcher);
    }

    public static <I, O> Matcher<I> where(final String entityDescription, final String propertyDescription, final Function<? super I, O> property, final Matcher<? super O> matcher) {
        return new TypeSafeDiagnosingMatcher<I>(){

            public void describeTo(Description description) {
                description.appendText(entityDescription).appendText(" with ").appendText(DescriptionUtils.withPrefixedArticle(propertyDescription)).appendText(" which ").appendDescriptionOf((SelfDescribing)matcher);
            }

            protected boolean matchesSafely(I objectToMatch, Description mismatch) {
                Object actual = property.apply(objectToMatch);
                boolean match = matcher.matches(actual);
                if (!match) {
                    mismatch.appendText("had the ").appendText(propertyDescription).appendText(" ").appendValue(actual);
                }
                return match;
            }
        };
    }

    private Java8Matchers() {
    }
}

