/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.stmt.query;

import co.touchlab.squeaky.dao.Dao;
import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.stmt.JoinAlias;
import co.touchlab.squeaky.stmt.query.Clause;
import co.touchlab.squeaky.stmt.query.Not;
import co.touchlab.squeaky.stmt.query.QueryFactory;
import co.touchlab.squeaky.stmt.query.Queryable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ManyClause<T>
implements Clause,
Queryable<T> {
    public static final String AND_OPERATION = "AND";
    public static final String OR_OPERATION = "OR";
    private final List<Clause> clauses;
    private final String operation;
    private final QueryFactory queryFactory;
    private final Queryable<T> parent;
    private final JoinAlias joinAlias;

    public ManyClause(Queryable<T> parent, QueryFactory queryFactory, String operation, JoinAlias joinAlias) {
        this.parent = parent;
        this.joinAlias = joinAlias;
        this.clauses = new ArrayList<Clause>(2);
        this.operation = operation;
        this.queryFactory = queryFactory;
    }

    @Override
    public String getWhereStatement(boolean joinsAllowed) throws SQLException {
        return this.parent.getWhereStatement(joinsAllowed);
    }

    @Override
    public Dao.QueryModifiers<T> query() throws SQLException {
        return this.parent.query();
    }

    @Override
    public Queryable<T> reset() {
        return this.parent.reset();
    }

    @Override
    public ManyClause<T> eq(String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.eq(this.joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> eq(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.eq(joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> gt(String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.gt(this.joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> gt(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.gt(joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> ge(String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.ge(this.joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> ge(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.ge(joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> lt(String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.lt(this.joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> lt(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.lt(joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> le(String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.le(this.joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> le(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.le(joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> like(String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.like(this.joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> like(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.like(joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> ne(String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.ne(this.joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> ne(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.clauses.add(this.queryFactory.ne(joinAlias, columnFieldName, value));
        return this;
    }

    @Override
    public ManyClause<T> in(String columnFieldName, Iterable<?> objects) throws SQLException {
        this.clauses.add(this.queryFactory.in(this.joinAlias, columnFieldName, objects));
        return this;
    }

    @Override
    public ManyClause<T> in(JoinAlias joinAlias, String columnFieldName, Iterable<?> objects) throws SQLException {
        this.clauses.add(this.queryFactory.in(joinAlias, columnFieldName, objects));
        return this;
    }

    @Override
    public ManyClause<T> notIn(String columnFieldName, Iterable<?> objects) throws SQLException {
        this.clauses.add(this.queryFactory.notIn(this.joinAlias, columnFieldName, objects));
        return this;
    }

    @Override
    public ManyClause<T> notIn(JoinAlias joinAlias, String columnFieldName, Iterable<?> objects) throws SQLException {
        this.clauses.add(this.queryFactory.notIn(joinAlias, columnFieldName, objects));
        return this;
    }

    @Override
    public ManyClause<T> in(String columnFieldName, Object ... objects) throws SQLException {
        this.clauses.add(this.queryFactory.in(this.joinAlias, columnFieldName, objects));
        return this;
    }

    @Override
    public ManyClause<T> in(JoinAlias joinAlias, String columnFieldName, Object ... objects) throws SQLException {
        this.clauses.add(this.queryFactory.in(joinAlias, columnFieldName, objects));
        return this;
    }

    @Override
    public ManyClause<T> notIn(String columnFieldName, Object ... objects) throws SQLException {
        this.clauses.add(this.queryFactory.notIn(this.joinAlias, columnFieldName, objects));
        return this;
    }

    @Override
    public ManyClause<T> notIn(JoinAlias joinAlias, String columnFieldName, Object ... objects) throws SQLException {
        this.clauses.add(this.queryFactory.notIn(joinAlias, columnFieldName, objects));
        return this;
    }

    @Override
    public ManyClause<T> between(String columnFieldName, Object low, Object high) throws SQLException {
        this.clauses.add(this.queryFactory.between(this.joinAlias, columnFieldName, low, high));
        return this;
    }

    @Override
    public ManyClause<T> between(JoinAlias joinAlias, String columnFieldName, Object low, Object high) throws SQLException {
        this.clauses.add(this.queryFactory.between(joinAlias, columnFieldName, low, high));
        return this;
    }

    @Override
    public ManyClause<T> isNull(String columnFieldName) throws SQLException {
        this.clauses.add(this.queryFactory.isNull(this.joinAlias, columnFieldName));
        return this;
    }

    @Override
    public ManyClause<T> isNull(JoinAlias joinAlias, String columnFieldName) throws SQLException {
        this.clauses.add(this.queryFactory.isNull(joinAlias, columnFieldName));
        return this;
    }

    @Override
    public ManyClause<T> isNotNull(String columnFieldName) throws SQLException {
        this.clauses.add(this.queryFactory.isNotNull(this.joinAlias, columnFieldName));
        return this;
    }

    @Override
    public ManyClause<T> isNotNull(JoinAlias joinAlias, String columnFieldName) throws SQLException {
        this.clauses.add(this.queryFactory.isNotNull(joinAlias, columnFieldName));
        return this;
    }

    @Override
    public ManyClause<T> and() {
        ManyClause<T> manyClause = new ManyClause<T>(this, this.queryFactory, AND_OPERATION, this.joinAlias);
        this.clauses.add(manyClause);
        return manyClause;
    }

    @Override
    public ManyClause<T> or() {
        ManyClause<T> manyClause = new ManyClause<T>(this, this.queryFactory, OR_OPERATION, this.joinAlias);
        this.clauses.add(manyClause);
        return manyClause;
    }

    public Not not() throws SQLException {
        Not not = new Not(this, this.queryFactory, this.joinAlias);
        this.clauses.add(not);
        return not;
    }

    @Override
    public Queryable<T> end() throws SQLException {
        return this.parent;
    }

    @Override
    public void appendSql(SqueakyContext squeakyContext, StringBuilder sb, boolean joinsAllowed) throws SQLException {
        if (this.clauses.size() == 0) {
            throw new SQLException("Clause list can't be empty for " + this.operation);
        }
        boolean first = true;
        for (Clause clause : this.clauses) {
            if (first) {
                first = false;
                sb.append("(");
            } else {
                sb.append(' ');
                sb.append(this.operation);
                sb.append(' ');
            }
            clause.appendSql(squeakyContext, sb, joinsAllowed);
        }
        sb.append(") ");
    }

    @Override
    public void appendValue(SqueakyContext squeakyContext, List<String> params) throws SQLException {
        for (Clause clause : this.clauses) {
            clause.appendValue(squeakyContext, params);
        }
    }
}

