/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.stmt;

import co.touchlab.squeaky.dao.Dao;
import co.touchlab.squeaky.dao.ModelDao;
import co.touchlab.squeaky.dao.Query;
import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.stmt.JoinAlias;
import co.touchlab.squeaky.stmt.query.Clause;
import co.touchlab.squeaky.stmt.query.ManyClause;
import co.touchlab.squeaky.stmt.query.Not;
import co.touchlab.squeaky.stmt.query.QueryFactory;
import co.touchlab.squeaky.stmt.query.Queryable;
import co.touchlab.squeaky.table.GeneratedTableMapper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Where<T>
implements Queryable<T>,
Query {
    private static final int CLAUSE_STACK_START_SIZE = 4;
    private final ModelDao<T> modelDao;
    private final SqueakyContext openHelperHelper;
    private final GeneratedTableMapper<T> generatedTableMapper;
    private final FieldType idFieldType;
    private final String idColumnName;
    private final QueryFactory queryFactory;
    private int joinTableCount = 0;
    private final List<JoinAlias> joins = new ArrayList<JoinAlias>();
    private final JoinAlias defaultJoinAlias;
    private Clause clause;

    public Where(Dao d) throws SQLException {
        if (!(d instanceof ModelDao)) {
            throw new SQLException("Dao must be a ModelDao instance");
        }
        this.modelDao = (ModelDao)d;
        this.openHelperHelper = this.modelDao.getOpenHelper();
        this.generatedTableMapper = this.modelDao.getGeneratedTableMapper();
        this.idFieldType = this.generatedTableMapper.getTableConfig().idField;
        this.queryFactory = new QueryFactory(this.openHelperHelper, this.modelDao.getDataClass());
        this.idColumnName = this.idFieldType == null ? null : this.idFieldType.getColumnName();
        this.defaultJoinAlias = new JoinAlias(this, "t", this.modelDao.getDataClass(), "t", null);
    }

    @Override
    public Where<T> eq(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.eq(this.defaultJoinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> eq(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.eq(joinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> gt(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.gt(this.defaultJoinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> gt(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.gt(joinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> ge(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.ge(this.defaultJoinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> ge(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.ge(joinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> lt(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.lt(this.defaultJoinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> lt(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.lt(joinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> le(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.le(this.defaultJoinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> le(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.le(joinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> like(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.like(this.defaultJoinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> like(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.like(joinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> ne(String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.ne(this.defaultJoinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> ne(JoinAlias joinAlias, String columnFieldName, Object value) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.ne(joinAlias, columnFieldName, value);
        return this;
    }

    @Override
    public Where<T> in(String columnFieldName, Iterable<?> objects) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.in(this.defaultJoinAlias, columnFieldName, objects);
        return this;
    }

    @Override
    public Where<T> in(JoinAlias joinAlias, String columnFieldName, Iterable<?> objects) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.in(joinAlias, columnFieldName, objects);
        return this;
    }

    @Override
    public Where<T> notIn(String columnFieldName, Iterable<?> objects) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.notIn(this.defaultJoinAlias, columnFieldName, objects);
        return this;
    }

    @Override
    public Where<T> notIn(JoinAlias joinAlias, String columnFieldName, Iterable<?> objects) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.notIn(joinAlias, columnFieldName, objects);
        return this;
    }

    @Override
    public Where<T> in(String columnFieldName, Object ... objects) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.in(this.defaultJoinAlias, columnFieldName, objects);
        return this;
    }

    @Override
    public Where<T> in(JoinAlias joinAlias, String columnFieldName, Object ... objects) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.in(joinAlias, columnFieldName, objects);
        return this;
    }

    @Override
    public Where<T> notIn(String columnFieldName, Object ... objects) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.notIn(this.defaultJoinAlias, columnFieldName, objects);
        return this;
    }

    @Override
    public Where<T> notIn(JoinAlias joinAlias, String columnFieldName, Object ... objects) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.notIn(joinAlias, columnFieldName, objects);
        return this;
    }

    @Override
    public Where<T> between(String columnFieldName, Object low, Object high) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.between(this.defaultJoinAlias, columnFieldName, low, high);
        return this;
    }

    @Override
    public Where<T> between(JoinAlias joinAlias, String columnFieldName, Object low, Object high) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.between(joinAlias, columnFieldName, low, high);
        return this;
    }

    @Override
    public Where<T> isNull(String columnFieldName) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.isNull(this.defaultJoinAlias, columnFieldName);
        return this;
    }

    @Override
    public Where<T> isNull(JoinAlias joinAlias, String columnFieldName) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.isNull(joinAlias, columnFieldName);
        return this;
    }

    @Override
    public Where<T> isNotNull(String columnFieldName) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.isNotNull(this.defaultJoinAlias, columnFieldName);
        return this;
    }

    @Override
    public Where<T> isNotNull(JoinAlias joinAlias, String columnFieldName) throws SQLException {
        this.checkClause();
        this.clause = this.queryFactory.isNotNull(joinAlias, columnFieldName);
        return this;
    }

    public ManyClause and() throws SQLException {
        ManyClause manyClause;
        this.checkClause();
        this.clause = manyClause = new ManyClause(this, this.queryFactory, "AND", this.defaultJoinAlias);
        return manyClause;
    }

    public ManyClause or() throws SQLException {
        ManyClause manyClause;
        this.checkClause();
        this.clause = manyClause = new ManyClause(this, this.queryFactory, "OR", this.defaultJoinAlias);
        return manyClause;
    }

    public Not not() throws SQLException {
        Not not;
        this.checkClause();
        this.clause = not = new Not(this, this.queryFactory, this.defaultJoinAlias);
        return not;
    }

    @Override
    public Queryable<T> end() throws SQLException {
        throw new SQLException("Where is not a child and can't be ended");
    }

    public JoinAlias join(String field) throws SQLException {
        return this.makeJoin(this.defaultJoinAlias.tablePrefix, field, this.modelDao.getDataClass());
    }

    public JoinAlias join(JoinAlias parent, String field) throws SQLException {
        return this.makeJoin(parent.tablePrefix, field, parent.tableType);
    }

    private JoinAlias makeJoin(String parentPrefix, String field, Class<T> dataClass) throws SQLException {
        FieldType fieldType = this.openHelperHelper.findFieldType(dataClass, field);
        if (fieldType.isForeign()) {
            JoinAlias joinAlias = new JoinAlias(this, parentPrefix, fieldType.getFieldType(), "t" + this.joinTableCount++, fieldType);
            this.joins.add(joinAlias);
            return joinAlias;
        }
        return null;
    }

    public String getFromStatement(boolean joinsAllowed) throws SQLException {
        if (!joinsAllowed && this.joins.size() > 0) {
            throw new SQLException("Joins not allowed for this operation");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatedTableMapper.getTableConfig().getTableName());
        sb.append(' ');
        if (joinsAllowed) {
            sb.append(this.defaultJoinAlias.tablePrefix);
        }
        for (JoinAlias join : this.joins) {
            sb.append(" join ");
            GeneratedTableMapper joinMapper = this.openHelperHelper.getGeneratedTableMapper(join.fieldType.getFieldType());
            sb.append(joinMapper.getTableConfig().getTableName());
            sb.append(' ');
            sb.append(join.tablePrefix);
            sb.append(" on ");
            sb.append(join.parentPrefix).append('.').append(join.fieldType.getColumnName());
            sb.append(" = ");
            sb.append(join.tablePrefix).append('.').append(joinMapper.getTableConfig().idField.getColumnName());
        }
        return sb.toString();
    }

    private void checkClause() throws SQLException {
        if (this.clause != null) {
            throw new SQLException("Clause already defined. Must use and/or for multiple conditions");
        }
    }

    public QueryFactory createQueryFactory() {
        return new QueryFactory(this.openHelperHelper, this.modelDao.getDataClass());
    }

    @Override
    public Where<T> reset() {
        this.clause = null;
        return this;
    }

    @Override
    public String getWhereStatement(boolean joinsAllowed) throws SQLException {
        StringBuilder sb = new StringBuilder();
        this.appendSql(sb, joinsAllowed);
        return sb.toString();
    }

    public String[] getParameters() throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        this.clause.appendValue(this.openHelperHelper, params);
        return params.toArray(new String[params.size()]);
    }

    @Override
    public Dao.QueryModifiers<T> query() throws SQLException {
        return this.modelDao.query(this.getWhereStatement(true), this.getParameters());
    }

    void appendSql(StringBuilder sb, boolean joinsAllowed) throws SQLException {
        this.clause.appendSql(this.openHelperHelper, sb, joinsAllowed);
    }

    public String toString() {
        return "where clause: " + this.clause;
    }
}

