package co.ronash.pushe.analytics.dagger

import android.content.Context
import co.ronash.pushe.analytics.AppLifecycleListener
import co.ronash.pushe.analytics.PusheAnalytics
import co.ronash.pushe.analytics.goal.GoalProcessManager
import co.ronash.pushe.analytics.messages.MessageDispatcher
import co.ronash.pushe.analytics.tasks.SessionEndDetectorTask
import co.ronash.pushe.dagger.CoreComponent
import co.ronash.pushe.internal.PusheComponent
import co.ronash.pushe.internal.PusheMoshi
import dagger.Component

@AnalyticsScope
@Component(dependencies = [(CoreComponent::class)])
interface AnalyticsComponent : PusheComponent {
    fun context(): Context
    fun goalProcessManager(): GoalProcessManager
    fun appLifeCycleListener(): AppLifecycleListener
    fun messageDispatcher(): MessageDispatcher
    fun api(): PusheAnalytics
    fun moshi(): PusheMoshi

    fun inject(sessionEndDetectorTask: SessionEndDetectorTask)
}
