/*
 * Decompiled with CFR 0.152.
 */
package co.libly.resourceloader;

import co.libly.resourceloader.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;

public class FileLoader
extends ResourceLoader {
    private FileLoader() {
    }

    public static FileLoader get() {
        return SingletonHelper.INSTANCE;
    }

    public File load(String relativePath, Class outsideClass) throws IOException, URISyntaxException {
        return this.load(relativePath, new HashSet<PosixFilePermission>(), outsideClass);
    }

    public File load(String relativePath, Set<PosixFilePermission> permissions, Class outsideClass) throws IOException, URISyntaxException {
        return this.loadFromRelativePath(relativePath, permissions, outsideClass);
    }

    private File loadFromRelativePath(String relativePath, Set<PosixFilePermission> filePermissions, Class outsideClass) throws IOException, URISyntaxException {
        File file = this.copyToTempDirectory(relativePath, outsideClass);
        this.setPermissions(file, filePermissions);
        return file;
    }

    private static class SingletonHelper {
        private static final FileLoader INSTANCE = new FileLoader();

        private SingletonHelper() {
        }
    }
}

