/*
 * Decompiled with CFR 0.152.
 */
package co.libly.resourceloader;

import co.libly.resourceloader.ResourceLoader;
import co.libly.resourceloader.ResourceLoaderException;
import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SharedLibraryLoader
extends ResourceLoader {
    private final Object lock = new Object();

    private SharedLibraryLoader() {
    }

    public static SharedLibraryLoader get() {
        return SingletonHelper.INSTANCE;
    }

    public void loadSystemLibrary(String libraryName, Class clzz) {
        this.loadSystemLibrary(libraryName, Collections.singletonList(clzz));
    }

    public void loadSystemLibrary(String libraryName, List<Class> classes) {
        this.registerLibraryWithClasses(libraryName, classes);
    }

    public File load(String relativePath, Class clzz) {
        return this.load(relativePath, Collections.singletonList(clzz));
    }

    public File load(String relativePath, List<Class> classes) {
        Object object = this.lock;
        synchronized (object) {
            try {
                File library = this.copyToTempDirectory(relativePath, classes.get(0));
                this.setPermissions(library);
                if (library.isDirectory()) {
                    throw new IOException("Please supply a relative path to a file and not a directory.");
                }
                this.registerLibraryWithClasses(library.getAbsolutePath(), classes);
                this.requestDeletion(library);
                return library;
            }
            catch (IOException e) {
                String message = String.format("Failed to load the bundled library from resources by relative path (%s)", relativePath);
                throw new ResourceLoaderException(message, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLibraryWithClasses(String absolutePath, List<Class> classes) {
        Objects.requireNonNull(absolutePath, "Please supply an absolute path.");
        Object object = this.lock;
        synchronized (object) {
            for (Class clzz : classes) {
                Native.register((Class)clzz, (String)absolutePath);
            }
        }
    }

    private static class SingletonHelper {
        private static final SharedLibraryLoader INSTANCE = new SharedLibraryLoader();

        private SingletonHelper() {
        }
    }
}

