/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.gradle.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.io.IOUtils;

public class ExtractCompressedTar {
    public static InputStream uncompressedInputStream(Path archive) throws IOException {
        BufferedInputStream imageStream = new BufferedInputStream(Files.newInputStream(archive, StandardOpenOption.READ));
        byte[] magicBytes = new byte[4];
        ((InputStream)imageStream).mark(4);
        if (((InputStream)imageStream).read(magicBytes) != 4) {
            throw new IOException("Failed to read magic bytes");
        }
        ((InputStream)imageStream).reset();
        int magicNumber = ByteBuffer.wrap(magicBytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        BufferedInputStream result = magicNumber == -47205080 ? new ZstdCompressorInputStream((InputStream)imageStream) : imageStream;
        return result;
    }

    public static void extract(Path archive, Path destination) throws IOException {
        TarArchiveEntry entry;
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        TarArchiveInputStream tarStream = new TarArchiveInputStream(ExtractCompressedTar.uncompressedInputStream(archive));
        while ((entry = tarStream.getNextTarEntry()) != null) {
            Path entryPath = destination.resolve(entry.getName());
            if (entry.isDirectory()) {
                Files.createDirectories(entryPath, new FileAttribute[0]);
                continue;
            }
            if (entryPath.getParent() != null) {
                Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
            }
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(entryPath, new OpenOption[0]));){
                IOUtils.copy((InputStream)tarStream, (OutputStream)out);
            }
        }
    }
}

