/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.gradle.cli.base;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;

public abstract class ExtractAndSetExecutableTransform
implements TransformAction<TransformParameters.None> {
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs outputs) {
        try {
            this.doTransform(outputs);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void doTransform(TransformOutputs outputs) throws IOException {
        File inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        String executableName = inputFile.getName().split("\\.transform")[0].replace(".tar.xz", "");
        if (inputFile.getName().contains("tar.xz")) {
            try (TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)new XZCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(inputFile))));){
                TarArchiveEntry entry;
                while ((entry = archive.getNextTarEntry()) != null) {
                    if (entry.isFile() && !List.of("README.txt", "LICENSE.txt").contains(entry.getName())) {
                        File outputFile = outputs.file((Object)executableName);
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
                        try {
                            ((OutputStream)out).write(IOUtils.toByteArray((InputStream)archive, (long)entry.getSize()));
                            this.setExecutableBit(outputFile);
                            continue;
                        }
                        finally {
                            ((OutputStream)out).close();
                            continue;
                        }
                    }
                    IOUtils.skip((InputStream)archive, (long)entry.getSize());
                }
            }
        }
        if (inputFile.getName().contains("manifest-tool") && !inputFile.getName().contains("v1")) {
            try (TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(inputFile))));){
                TarArchiveEntry entry;
                while ((entry = archive.getNextTarEntry()) != null) {
                    File outputFile = outputs.file((Object)entry.getName());
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));){
                        ((OutputStream)out).write(IOUtils.toByteArray((InputStream)archive, (long)entry.getSize()));
                    }
                    this.setExecutableBit(outputFile);
                }
            }
        }
        File outputFile = outputs.file((Object)executableName);
        Files.copy(inputFile.toPath(), outputFile.toPath(), new CopyOption[0]);
        this.setExecutableBit(outputFile);
    }

    private void setExecutableBit(File outputFile) {
        if (!outputFile.setExecutable(true)) {
            throw new GradleException("Failed to set execute bit on " + outputFile);
        }
    }
}

