/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.search.KnnQueryProfileBreakdown;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KnnQueryProfileResult
implements JsonpSerializable {
    private final String type;
    private final String description;
    @Nullable
    private final Time time;
    private final long timeInNanos;
    private final KnnQueryProfileBreakdown breakdown;
    private final Map<String, JsonData> debug;
    private final List<KnnQueryProfileResult> children;
    public static final JsonpDeserializer<KnnQueryProfileResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnQueryProfileResult::setupKnnQueryProfileResultDeserializer);

    private KnnQueryProfileResult(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.time = builder.time;
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, (Object)this, "timeInNanos", 0L);
        this.breakdown = ApiTypeHelper.requireNonNull(builder.breakdown, this, "breakdown");
        this.debug = ApiTypeHelper.unmodifiable(builder.debug);
        this.children = ApiTypeHelper.unmodifiable(builder.children);
    }

    public static KnnQueryProfileResult of(Function<Builder, ObjectBuilder<KnnQueryProfileResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String type() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    public final KnnQueryProfileBreakdown breakdown() {
        return this.breakdown;
    }

    public final Map<String, JsonData> debug() {
        return this.debug;
    }

    public final List<KnnQueryProfileResult> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("description");
        generator.write(this.description);
        if (this.time != null) {
            generator.writeKey("time");
            this.time.serialize(generator, mapper);
        }
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        generator.writeKey("breakdown");
        this.breakdown.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.debug)) {
            generator.writeKey("debug");
            generator.writeStartObject();
            for (Map.Entry entry : this.debug.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (KnnQueryProfileResult knnQueryProfileResult : this.children) {
                knnQueryProfileResult.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupKnnQueryProfileResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::time, Time._DESERIALIZER, "time");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
        op.add(Builder::breakdown, KnnQueryProfileBreakdown._DESERIALIZER, "breakdown");
        op.add(Builder::debug, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "debug");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<KnnQueryProfileResult> {
        private String type;
        private String description;
        @Nullable
        private Time time;
        private Long timeInNanos;
        private KnnQueryProfileBreakdown breakdown;
        @Nullable
        private Map<String, JsonData> debug;
        @Nullable
        private List<KnnQueryProfileResult> children;

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public final Builder breakdown(KnnQueryProfileBreakdown value) {
            this.breakdown = value;
            return this;
        }

        public final Builder breakdown(Function<KnnQueryProfileBreakdown.Builder, ObjectBuilder<KnnQueryProfileBreakdown>> fn) {
            return this.breakdown(fn.apply(new KnnQueryProfileBreakdown.Builder()).build());
        }

        public final Builder debug(Map<String, JsonData> map) {
            this.debug = Builder._mapPutAll(this.debug, map);
            return this;
        }

        public final Builder debug(String key, JsonData value) {
            this.debug = Builder._mapPut(this.debug, key, value);
            return this;
        }

        public final Builder children(List<KnnQueryProfileResult> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        public final Builder children(KnnQueryProfileResult value, KnnQueryProfileResult ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        public final Builder children(Function<Builder, ObjectBuilder<KnnQueryProfileResult>> fn) {
            return this.children(fn.apply(new Builder()).build(), new KnnQueryProfileResult[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnQueryProfileResult build() {
            this._checkSingleUse();
            return new KnnQueryProfileResult(this);
        }
    }
}

