/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.Validation;
import co.elastic.clients.elasticsearch.connector.ValidationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class LessThanValidation
implements ValidationVariant,
JsonpSerializable {
    private final double constraint;
    public static final JsonpDeserializer<LessThanValidation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LessThanValidation::setupLessThanValidationDeserializer);

    private LessThanValidation(Builder builder) {
        this.constraint = ApiTypeHelper.requireNonNull(builder.constraint, (Object)this, "constraint", 0.0);
    }

    public static LessThanValidation of(Function<Builder, ObjectBuilder<LessThanValidation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Validation.Kind _validationKind() {
        return Validation.Kind.LessThan;
    }

    public final double constraint() {
        return this.constraint;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "less_than");
        generator.writeKey("constraint");
        generator.write(this.constraint);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupLessThanValidationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::constraint, JsonpDeserializer.doubleDeserializer(), "constraint");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LessThanValidation> {
        private Double constraint;

        public final Builder constraint(double value) {
            this.constraint = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LessThanValidation build() {
            this._checkSingleUse();
            return new LessThanValidation(this);
        }
    }
}

