/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.UpdateNativeResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdateNativeRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final boolean isNative;
    public static final JsonpDeserializer<UpdateNativeRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateNativeRequest::setupUpdateNativeRequestDeserializer);
    public static final Endpoint<UpdateNativeRequest, UpdateNativeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateNativeRequest, UpdateNativeResponse>("es/connector.update_native", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_native");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateNativeResponse._DESERIALIZER);

    private UpdateNativeRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.isNative = ApiTypeHelper.requireNonNull(builder.isNative, this, "isNative");
    }

    public static UpdateNativeRequest of(Function<Builder, ObjectBuilder<UpdateNativeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final boolean isNative() {
        return this.isNative;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("is_native");
        generator.write(this.isNative);
    }

    protected static void setupUpdateNativeRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::isNative, JsonpDeserializer.booleanDeserializer(), "is_native");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateNativeRequest> {
        private String connectorId;
        private Boolean isNative;

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder isNative(boolean value) {
            this.isNative = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateNativeRequest build() {
            this._checkSingleUse();
            return new UpdateNativeRequest(this);
        }
    }
}

