/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Invocation
implements JsonpSerializable {
    private final String snapshotName;
    private final String time;
    public static final JsonpDeserializer<Invocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Invocation::setupInvocationDeserializer);

    private Invocation(Builder builder) {
        this.snapshotName = ApiTypeHelper.requireNonNull(builder.snapshotName, this, "snapshotName");
        this.time = ApiTypeHelper.requireNonNull(builder.time, this, "time");
    }

    public static Invocation of(Function<Builder, ObjectBuilder<Invocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final String time() {
        return this.time;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshot_name");
        generator.write(this.snapshotName);
        generator.writeKey("time");
        generator.write(this.time);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInvocationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::snapshotName, JsonpDeserializer.stringDeserializer(), "snapshot_name");
        op.add(Builder::time, JsonpDeserializer.stringDeserializer(), "time");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Invocation> {
        private String snapshotName;
        private String time;

        public final Builder snapshotName(String value) {
            this.snapshotName = value;
            return this;
        }

        public final Builder time(String value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Invocation build() {
            this._checkSingleUse();
            return new Invocation(this);
        }
    }
}

