/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.SharedPreferences;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.ThreadUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

class Settings {
    private static final String LOGTAG = Settings.class.getSimpleName();
    private static final String PREFS_NAME = "AmazonMobileAds";
    private static Settings instance = new Settings();
    public static final String SETTING_ENABLE_WEBVIEW_PAUSE_LOGIC = "shouldPauseWebViewTimersInWebViewRelatedActivities";
    protected static final String SETTING_TESTING_ENABLED = "testingEnabled";
    protected static final String SETTING_TLS_ENABLED = "tlsEnabled";
    private LinkedBlockingQueue<SettingsListener> listeners;
    private final ReentrantLock writeToSharedPreferencesLock;
    private final ConcurrentHashMap<String, Value> cache;
    private SharedPreferences sharedPreferences;
    private final CountDownLatch settingsLoadedLatch;
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    private DebugProperties debugProperties;
    private JSONUtils.JSONUtilities jsonUtilities;

    public Settings() {
        this(new JSONUtils.JSONUtilities(), DebugProperties.getInstance());
    }

    Settings(JSONUtils.JSONUtilities jsonUtilities, DebugProperties debugProperties) {
        this.listeners = new LinkedBlockingQueue();
        this.writeToSharedPreferencesLock = new ReentrantLock();
        this.settingsLoadedLatch = new CountDownLatch(1);
        this.cache = new ConcurrentHashMap();
        this.jsonUtilities = jsonUtilities;
        this.debugProperties = debugProperties;
    }

    public static Settings getInstance() {
        return instance;
    }

    void contextReceived(Context context) {
        if (context == null) {
            return;
        }
        this.beginFetch(context);
    }

    void beginFetch(final Context context) {
        ThreadUtils.scheduleRunnable(new Runnable(){

            @Override
            public void run() {
                Settings.this.fetchSharedPreferences(context);
            }
        });
    }

    public boolean isSettingsLoaded() {
        return this.sharedPreferences != null;
    }

    public void listenForSettings(SettingsListener listener) {
        if (this.isSettingsLoaded()) {
            listener.settingsLoaded();
        } else {
            try {
                this.listeners.put(listener);
            }
            catch (InterruptedException e) {
                this.logger.e("Interrupted exception while adding listener: %s", e.getMessage());
            }
        }
    }

    SharedPreferences getSharedPreferencesFromContext(Context context) {
        return context.getSharedPreferences(PREFS_NAME, 0);
    }

    SharedPreferences getSharedPreferences() {
        return this.sharedPreferences;
    }

    ConcurrentHashMap<String, Value> getCache() {
        return this.cache;
    }

    private void putSetting(String key, Value value) {
        if (value.value == null) {
            this.logger.w("Could not set null value for setting: %s", key);
            return;
        }
        this.putSettingWithNoFlush(key, value);
        if (!value.isTransientData && this.isSettingsLoaded()) {
            this.flush();
        }
    }

    private void putSettingWithNoFlush(String key, Value value) {
        if (value.value == null) {
            this.logger.w("Could not set null value for setting: %s", key);
            return;
        }
        this.cache.put(key, value);
    }

    void readSharedPreferencesIntoCache(SharedPreferences sharedPreferences) {
        Map entries = sharedPreferences.getAll();
        this.cacheAdditionalEntries(entries);
    }

    void cacheAdditionalEntries(Map<String, ?> entries) {
        for (Map.Entry<String, ?> entry : entries.entrySet()) {
            String key = entry.getKey();
            if (key == null || this.cache.containsKey(key)) continue;
            Object value = entry.getValue();
            if (value != null) {
                this.cache.put(key, new Value(value.getClass(), value));
                continue;
            }
            this.logger.w("Could not cache null value for SharedPreferences setting: %s", key);
        }
    }

    private void writeCacheToSharedPreferences() {
        this.writeCacheToSharedPreferences(this.sharedPreferences);
    }

    void writeCacheToSharedPreferences(final SharedPreferences sharedPreferences) {
        ThreadUtils.scheduleRunnable(new Runnable(){

            @Override
            public void run() {
                Settings.this.writeToSharedPreferencesLock.lock();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.clear();
                for (Map.Entry entry : Settings.this.cache.entrySet()) {
                    Value value = (Value)entry.getValue();
                    if (value.isTransientData) continue;
                    if (value.clazz == String.class) {
                        editor.putString((String)entry.getKey(), (String)value.value);
                        continue;
                    }
                    if (value.clazz == Long.class) {
                        editor.putLong((String)entry.getKey(), ((Long)value.value).longValue());
                        continue;
                    }
                    if (value.clazz == Integer.class) {
                        editor.putInt((String)entry.getKey(), ((Integer)value.value).intValue());
                        continue;
                    }
                    if (value.clazz != Boolean.class) continue;
                    editor.putBoolean((String)entry.getKey(), ((Boolean)value.value).booleanValue());
                }
                Settings.this.commit(editor);
                Settings.this.writeToSharedPreferencesLock.unlock();
            }
        });
    }

    void flush() {
        this.writeCacheToSharedPreferences();
    }

    public boolean containsKey(String key) {
        return this.cache.containsKey(key);
    }

    public JSONObject getJSONObject(String key, JSONObject defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        JSONObject json = this.jsonUtilities.getJSONObjectFromString((String)value.value);
        if (json != null) {
            return json;
        }
        return defaultValue;
    }

    public void putJSONObject(String key, JSONObject value) {
        this.putSetting(key, new Value(String.class, value.toString()));
    }

    public void putJSONObjectWithNoFlush(String key, JSONObject value) {
        this.putSettingWithNoFlush(key, new Value(String.class, value.toString()));
    }

    public void putTransientJSONObject(String key, JSONObject value) {
        this.putSettingWithNoFlush(key, new TransientValue(String.class, value.toString()));
    }

    public JSONObject getWrittenJSONObject(String key, JSONObject defaultValue) {
        if (this.isSettingsLoaded()) {
            String jsonString = this.sharedPreferences.getString(key, defaultValue.toString());
            return this.jsonUtilities.getJSONObjectFromString(jsonString);
        }
        return defaultValue;
    }

    public String getString(String key, String defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value.value;
    }

    void putString(String key, String value) {
        this.putSetting(key, new Value(String.class, value));
    }

    void putStringWithNoFlush(String key, String value) {
        this.putSettingWithNoFlush(key, new Value(String.class, value));
    }

    void putTransientString(String key, String value) {
        this.putSettingWithNoFlush(key, new TransientValue(String.class, value));
    }

    public String getWrittenString(String key, String defaultValue) {
        if (this.isSettingsLoaded()) {
            return this.sharedPreferences.getString(key, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value.value;
    }

    void putInt(String key, int value) {
        this.putSetting(key, new Value(Integer.class, value));
    }

    void putIntWithNoFlush(String key, int value) {
        this.putSettingWithNoFlush(key, new Value(Integer.class, value));
    }

    void putTransientInt(String key, int value) {
        this.putSettingWithNoFlush(key, new TransientValue(Integer.class, value));
    }

    public int getWrittenInt(String key, int defaultValue) {
        if (this.isSettingsLoaded()) {
            return this.sharedPreferences.getInt(key, defaultValue);
        }
        return defaultValue;
    }

    public long getLong(String key, long defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Long)value.value;
    }

    void putLong(String key, long value) {
        this.putSetting(key, new Value(Long.class, value));
    }

    void putLongWithNoFlush(String key, long value) {
        this.putSettingWithNoFlush(key, new Value(Long.class, value));
    }

    void putTransientLong(String key, long value) {
        this.putSettingWithNoFlush(key, new TransientValue(Long.class, value));
    }

    public long getWrittenLong(String key, long defaultValue) {
        if (this.isSettingsLoaded()) {
            return this.sharedPreferences.getLong(key, defaultValue);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean value = this.getBoolean(key, null);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Value value = this.cache.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value.value;
    }

    void putBoolean(String key, boolean value) {
        this.putSetting(key, new Value(Boolean.class, value));
    }

    void putBooleanWithNoFlush(String key, boolean value) {
        this.putSettingWithNoFlush(key, new Value(Boolean.class, value));
    }

    void putTransientBoolean(String key, boolean value) {
        this.putSettingWithNoFlush(key, new TransientValue(Boolean.class, value));
    }

    public boolean getWrittenBoolean(String key, boolean defaultValue) {
        if (this.isSettingsLoaded()) {
            return this.sharedPreferences.getBoolean(key, defaultValue);
        }
        return defaultValue;
    }

    public void putTransientObject(String key, Object value) {
        this.putSettingWithNoFlush(key, new TransientValue(value.getClass(), value));
    }

    public <T> T getObject(String key, T defaultValue, Class<T> clazz) {
        Value value = this.cache.get(key);
        if (value != null && clazz.isInstance(value.value)) {
            return (T)value.value;
        }
        return defaultValue;
    }

    void remove(String key) {
        Value value = this.cache.remove(key);
        if (value != null && !value.isTransientData && this.isSettingsLoaded()) {
            this.flush();
        }
    }

    void removeWithNoFlush(String key) {
        this.cache.remove(key);
    }

    private void commit(SharedPreferences.Editor editor) {
        editor.apply();
    }

    void notifySettingsListeners() {
        SettingsListener listener = null;
        while ((listener = this.listeners.poll()) != null) {
            listener.settingsLoaded();
        }
    }

    void fetchSharedPreferences(Context context) {
        if (!this.isSettingsLoaded()) {
            SharedPreferences sharedPreferences = this.getSharedPreferencesFromContext(context);
            this.readSharedPreferencesIntoCache(sharedPreferences);
            this.sharedPreferences = sharedPreferences;
            this.writeCacheToSharedPreferences(sharedPreferences);
        }
        this.settingsLoadedLatch.countDown();
        this.notifySettingsListeners();
    }

    static final class SettingsStatics {
        static final String IU_SERVICE_LAST_CHECKIN = "amzn-ad-iu-last-checkin";
        static final String IU_SERVICE_LAST_CHECKIN_USING_SESSIONID = "amzn-ad-iu-last-checkin-using-sessionid";
        static final String VIEWABLE_JS_SETTINGS_NAME = "viewableJSSettingsNameAmazonAdSDK";
        static final String VIEWABLE_JS_VERSION_STORED = "viewableJSVersionStored";

        SettingsStatics() {
        }
    }

    public static interface SettingsListener {
        public void settingsLoaded();
    }

    class TransientValue
    extends Value {
        public TransientValue(Class<?> clazz, Object value) {
            super(clazz, value);
            this.isTransientData = true;
        }
    }

    class Value {
        public Class<?> clazz;
        public Object value;
        public boolean isTransientData;

        public Value(Class<?> clazz, Object value) {
            this.clazz = clazz;
            this.value = value;
        }
    }
}

