/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.Version;
import com.amazon.device.ads.WebViewFactory;

class UserAgentManager {
    private final ThreadUtils.ThreadRunner threadRunner;
    private final WebViewFactory webViewFactory;
    private String userAgentStringWithSDKVersion;
    private String userAgentStringWithoutSDKVersion;

    public UserAgentManager() {
        this(new ThreadUtils.ThreadRunner(), WebViewFactory.getInstance());
    }

    UserAgentManager(ThreadUtils.ThreadRunner threadRunner, WebViewFactory webViewFactory) {
        this.threadRunner = threadRunner;
        this.webViewFactory = webViewFactory;
    }

    public String getUserAgentString() {
        return this.userAgentStringWithSDKVersion;
    }

    public void setUserAgentString(String newUserAgent) {
        if (newUserAgent != null && !newUserAgent.equals(this.userAgentStringWithoutSDKVersion) && !newUserAgent.equals(this.userAgentStringWithSDKVersion)) {
            this.userAgentStringWithoutSDKVersion = newUserAgent;
            this.userAgentStringWithSDKVersion = newUserAgent + " " + Version.getUserAgentSDKVersion();
        }
    }

    public void populateUserAgentString(final Context context) {
        this.threadRunner.execute(new Runnable(){

            @Override
            public void run() {
                UserAgentManager.this.setUserAgentString(UserAgentManager.this.webViewFactory.createWebView(context).getSettings().getUserAgentString());
            }
        }, ThreadUtils.ExecutionStyle.RUN_ASAP, ThreadUtils.ExecutionThread.MAIN_THREAD);
    }
}

