/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.AppInfo;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.SISRegistration;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.UserAgentManager;
import java.io.File;

class MobileAdsInfoStore {
    private AppInfo appInfo;
    private DeviceInfo deviceInfo;
    private RegistrationInfo registrationInfo;
    private SISRegistration sisRegistration;
    private boolean contextReceived;
    private boolean isRegistered;
    private int noRetryTtlMillis;
    private long noRetryTtlExpiresMillis;
    private boolean isAppDisabled = false;
    private File filesDirectory;
    protected Context applicationContext;
    private final Settings settings;
    private final DebugProperties debugProperties;
    private static MobileAdsInfoStore instance = new MobileAdsInfoStore(Settings.getInstance(), DebugProperties.getInstance());

    protected MobileAdsInfoStore(Settings settings, DebugProperties debugProperties) {
        this.settings = settings;
        this.debugProperties = debugProperties;
        this.registrationInfo = new RegistrationInfo();
    }

    public static MobileAdsInfoStore getInstance() {
        return instance;
    }

    static void setMobileAdsInfoStore(MobileAdsInfoStore infoStore) {
        instance = infoStore;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public RegistrationInfo getRegistrationInfo() {
        return this.registrationInfo;
    }

    public synchronized void contextReceived(Context context) {
        if (!this.contextReceived) {
            this.contextReceived = true;
            this.setApplicationContextFromContext(context);
            this.setFilesDirectory(context);
            this.settings.contextReceived(context);
            this.createAppInfo(context);
            this.deviceInfo = this.createDeviceInfo(context);
            this.createSISRegistration();
        }
    }

    public boolean isContextReceived() {
        return this.contextReceived;
    }

    protected void setFilesDirectory(Context context) {
        this.filesDirectory = context.getFilesDir();
    }

    protected void createAppInfo(Context context) {
        this.appInfo = new AppInfo(context);
    }

    protected DeviceInfo createDeviceInfo(Context context) {
        return new DeviceInfo(context, new UserAgentManager());
    }

    public void register() {
        this.getSISRegistration().registerApp();
        this.isRegistered = true;
    }

    protected void createSISRegistration() {
        this.sisRegistration = new SISRegistration();
    }

    public SISRegistration getSISRegistration() {
        return this.sisRegistration;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public int getNoRetryTtlRemainingMillis() {
        if (this.noRetryTtlMillis == 0 || this.noRetryTtlExpiresMillis == 0L) {
            return 0;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.noRetryTtlExpiresMillis) {
            this.noRetryTtlMillis = 0;
            this.noRetryTtlExpiresMillis = 0L;
            return 0;
        }
        long timeRemaining = this.noRetryTtlExpiresMillis - currentTime;
        return (int)timeRemaining;
    }

    public void setNoRetryTtl(int noRetryTtlSeconds) {
        int maxNoRetryTtlSeconds = this.debugProperties.getDebugPropertyAsInteger("debug.noRetryTTLMax", 300000);
        if (maxNoRetryTtlSeconds < noRetryTtlSeconds) {
            noRetryTtlSeconds = maxNoRetryTtlSeconds;
        }
        if (noRetryTtlSeconds == 0) {
            this.noRetryTtlMillis = 0;
            this.noRetryTtlExpiresMillis = 0L;
        } else {
            this.noRetryTtlMillis = noRetryTtlSeconds * 1000;
            this.noRetryTtlExpiresMillis = System.currentTimeMillis() + (long)this.noRetryTtlMillis;
        }
    }

    public boolean getIsAppDisabled() {
        return this.isAppDisabled;
    }

    public void setIsAppDisabled(boolean isAppDisabled) {
        this.isAppDisabled = isAppDisabled;
    }

    public File getFilesDir() {
        return this.filesDirectory;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    protected void setApplicationContextFromContext(Context context) {
        this.applicationContext = context.getApplicationContext();
    }
}

