/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdParameter;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.UserIdParameter;
import com.amazon.device.ads.WebRequest;

class WebRequestUserId {
    private final Settings settings;
    private UserIdParameter userIdParam;
    private final AdvertisingIdParameter adIdParam;

    public WebRequestUserId() {
        this(Settings.getInstance(), new AdvertisingIdParameter());
    }

    WebRequestUserId(Settings settings, AdvertisingIdParameter adIdParam) {
        this.settings = settings;
        this.adIdParam = adIdParam;
    }

    private void setupUserIdParam() {
        if (this.userIdParam == null) {
            this.userIdParam = this.settings.getObject("userIdParam", this.adIdParam, UserIdParameter.class);
        }
    }

    public boolean populateWebRequestUserId(WebRequest webRequest) {
        this.setupUserIdParam();
        boolean paramPopulated = this.userIdParam.evaluate(webRequest);
        if (!paramPopulated && this.userIdParam != this.adIdParam) {
            paramPopulated = this.adIdParam.evaluate(webRequest);
        }
        return paramPopulated;
    }
}

