/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StringUtils {
    private static final String LOGTAG = StringUtils.class.getSimpleName();
    private static final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    private StringUtils() {
    }

    public static boolean containsRegEx(String regex, String input) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.find();
    }

    public static String getFirstMatch(String regex, String input) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    public static final boolean isNullOrEmpty(String s) {
        return s == null || s.equals("");
    }

    public static final boolean isNullOrWhiteSpace(String s) {
        return StringUtils.isNullOrEmpty(s) || s.trim().equals("");
    }

    protected static boolean doesExceptionContainLockedDatabaseMessage(Exception e) {
        String lockedDatabaseMessage = "database is locked";
        return e == null || e.getMessage() == null ? false : e.getMessage().contains("database is locked");
    }

    public static String sha1(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i] | 0x100).substring(1));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        try {
            int i;
            while ((i = inputStream.read(b)) != -1) {
                out.append(new String(b, 0, i));
            }
        }
        catch (IOException e) {
            logger.e("Unable to read the stream.");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.e("IOException while trying to close the stream.");
            }
        }
        return out.toString();
    }
}

