/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.Logger;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.Version;
import java.util.ArrayList;

class MobileAdsLogger
implements Logger {
    static final String LOGGING_ENABLED = "loggingEnabled";
    private static final String DEFAULT_LOGTAG_PREFIX = "AmazonMobileAds";
    private static final int DEFAULT_MAX_LENGTH = 1000;
    private int maxLength = 1000;
    private final Logger logger;
    private final DebugProperties debugProperties;
    private final Settings settings;

    public MobileAdsLogger(Logger logger) {
        this(logger, DebugProperties.getInstance(), Settings.getInstance());
    }

    MobileAdsLogger(Logger logger, DebugProperties debugProperties, Settings settings) {
        this.logger = logger.withLogTag(DEFAULT_LOGTAG_PREFIX);
        this.debugProperties = debugProperties;
        this.settings = settings;
    }

    public MobileAdsLogger withMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Override
    public MobileAdsLogger withLogTag(String logTag) {
        this.logger.withLogTag("AmazonMobileAds " + logTag);
        return this;
    }

    public void enableLogging(boolean enabled) {
        this.settings.putTransientBoolean(LOGGING_ENABLED, enabled);
    }

    public boolean canLog() {
        if (this.logger == null || this.debugProperties == null) {
            return false;
        }
        return this.debugProperties.getDebugPropertyAsBoolean("debug.logging", this.settings.getBoolean(LOGGING_ENABLED, false));
    }

    public final void enableLoggingWithSetterNotification(boolean enable) {
        if (!enable) {
            this.logSetterNotification("Debug logging", enable);
        }
        this.enableLogging(enable);
        if (enable) {
            this.logSetterNotification("Debug logging", enable);
            this.d("Amazon Mobile Ads API Version: %s", Version.getRawSDKVersion());
        }
    }

    public void logSetterNotification(String capitalizedSingularPropertyName, Object value) {
        if (!this.canLog()) {
            return;
        }
        if (value instanceof Boolean) {
            this.d("%s has been %s.", capitalizedSingularPropertyName, (Boolean)value != false ? "enabled" : "disabled");
        } else {
            this.d("%s has been set: %s", capitalizedSingularPropertyName, String.valueOf(value));
        }
    }

    public void i(String message, Object ... params) {
        this.log(Level.INFO, message, params);
    }

    public void v(String message, Object ... params) {
        this.log(Level.VERBOSE, message, params);
    }

    public void d(String message, Object ... params) {
        this.log(Level.DEBUG, message, params);
    }

    public void w(String message, Object ... params) {
        this.log(Level.WARN, message, params);
    }

    public void e(String message, Object ... params) {
        this.log(Level.ERROR, message, params);
    }

    @Override
    public void i(String message) {
        this.i(message, null);
    }

    @Override
    public void v(String message) {
        this.v(message, null);
    }

    @Override
    public void d(String message) {
        this.d(message, null);
    }

    @Override
    public void w(String message) {
        this.w(message, null);
    }

    @Override
    public void e(String message) {
        this.e(message, null);
    }

    public void log(Level level, String message, Object ... params) {
        this.doLog(false, level, message, params);
    }

    public void forceLog(Level level, String message, Object ... params) {
        this.doLog(true, level, message, params);
    }

    private void doLog(boolean force, Level level, String message, Object ... params) {
        if (this.canLog() || force) {
            for (String data : this.formatAndSplit(message, params)) {
                switch (level) {
                    case DEBUG: {
                        this.logger.d(data);
                        break;
                    }
                    case ERROR: {
                        this.logger.e(data);
                        break;
                    }
                    case INFO: {
                        this.logger.i(data);
                        break;
                    }
                    case VERBOSE: {
                        this.logger.v(data);
                        break;
                    }
                    case WARN: {
                        this.logger.w(data);
                    }
                }
            }
        }
    }

    private Iterable<String> formatAndSplit(String msg, Object ... params) {
        if (params != null && params.length > 0) {
            msg = String.format(msg, params);
        }
        return this.split(msg, this.maxLength);
    }

    private Iterable<String> split(String input, int maxLength) {
        ArrayList<String> output = new ArrayList<String>();
        if (input == null || input.length() == 0) {
            return output;
        }
        for (int i = 0; i < input.length(); i += maxLength) {
            output.add(input.substring(i, Math.min(input.length(), i + maxLength)));
        }
        return output;
    }

    public static enum Level {
        DEBUG,
        ERROR,
        INFO,
        VERBOSE,
        WARN;

    }
}

