/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.WebRequest;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;

class WebUtils {
    private static final String LOGTAG = WebUtils.class.getSimpleName();
    private static final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    WebUtils() {
    }

    public static boolean launchActivityForIntentLink(String url, Context context) {
        if (url == null || url.equals("")) {
            url = "about:blank";
        }
        logger.d("Launch Intent: " + url);
        Intent actionIntent = new Intent();
        if (url.startsWith("intent:")) {
            try {
                actionIntent = Intent.parseUri((String)url, (int)1);
            }
            catch (URISyntaxException e) {
                return false;
            }
        } else {
            actionIntent.setData(Uri.parse((String)url));
        }
        actionIntent.setAction("android.intent.action.VIEW");
        actionIntent.setFlags(0x10000000);
        try {
            context.startActivity(actionIntent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            String action = actionIntent.getAction();
            logger.w("Could not handle " + (action.startsWith("market://") ? "market" : "intent") + " action: " + action);
            return false;
        }
    }

    public static final String getURLEncodedString(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            logger.d("getURLEncodedString threw: %s", e);
            return s;
        }
        catch (IllegalCharsetNameException e) {
            logger.d("getURLEncodedString threw: %s", e);
            return s;
        }
    }

    public static final String getURLDecodedString(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.d("getURLDecodedString threw: %s", e);
            return s;
        }
    }

    public static final String getScheme(String url) {
        Uri uri = Uri.parse((String)url);
        String scheme = uri.getScheme();
        if (scheme != null) {
            scheme = scheme.toLowerCase(Locale.US);
        }
        return scheme;
    }

    public static final String encloseHtml(String html, boolean isHTML5) {
        if (html != null) {
            if (html.indexOf("<html>") == -1) {
                html = "<html>" + html + "</html>";
            }
            if (isHTML5 && html.indexOf("<!DOCTYPE html>") == -1) {
                html = "<!DOCTYPE html>" + html;
            }
        }
        return html;
    }

    public static final void executeWebRequestInThread(final String url, final boolean disconnectEnabled) {
        ThreadUtils.scheduleRunnable(new Runnable(){

            @Override
            public void run() {
                WebRequest request = new WebRequest.WebRequestFactory().createWebRequest();
                request.enableLog(true);
                request.setUrlString(url);
                request.setDisconnectEnabled(disconnectEnabled);
                try {
                    request.makeCall();
                }
                catch (WebRequest.WebRequestException webRequestException) {
                    // empty catch block
                }
            }
        });
    }
}

