/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AndroidBuildInfo;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AdTargetingOptions {
    private static final String LOGTAG = AdTargetingOptions.class.getSimpleName();
    private static final long DEFAULT_FLOOR_PRICE = 0L;
    private static final boolean DEFAULT_GEOTARGETING_ENABLED = false;
    private static final boolean DEFAULT_DISPLAY_ENABLED = true;
    private final Map<String, String> advanced;
    private final boolean videoEnabledSettable;
    private final HashSet<String> internalPublisherKeywords;
    private long floorPrice = 0L;
    private boolean enableGeoTargeting = false;
    private boolean displayEnabled = true;
    private boolean videoEnabled;
    private final MobileAdsLogger logger;

    public AdTargetingOptions() {
        this(new AndroidBuildInfo(), new MobileAdsLoggerFactory());
    }

    AdTargetingOptions(AndroidBuildInfo androidBuildInfo, MobileAdsLoggerFactory loggerFactory) {
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.advanced = new HashMap<String, String>();
        this.videoEnabled = this.videoEnabledSettable = AdTargetingOptions.isVideoEnabledSettable(androidBuildInfo);
        this.internalPublisherKeywords = new HashSet();
    }

    AdTargetingOptions copy() {
        AdTargetingOptions copy = new AdTargetingOptions().enableGeoLocation(this.enableGeoTargeting).setFloorPrice(this.floorPrice).enableDisplayAds(this.displayEnabled);
        if (this.videoEnabledSettable) {
            copy.enableVideoAds(this.videoEnabled);
        }
        copy.advanced.putAll(this.advanced);
        copy.internalPublisherKeywords.addAll(this.internalPublisherKeywords);
        return copy;
    }

    HashMap<String, String> getCopyOfAdvancedOptions() {
        HashMap<String, String> ret = new HashMap<String, String>(this.advanced);
        return ret;
    }

    private static boolean isVideoEnabledSettable(AndroidBuildInfo androidBuildInfo) {
        return AndroidTargetUtils.isAtLeastAndroidAPI(androidBuildInfo, 14);
    }

    public AdTargetingOptions setFloorPrice(long floorPrice) {
        this.floorPrice = floorPrice;
        return this;
    }

    public long getFloorPrice() {
        return this.floorPrice;
    }

    boolean hasFloorPrice() {
        return this.floorPrice > 0L;
    }

    public boolean containsAdvancedOption(String key) {
        return this.advanced.containsKey(key);
    }

    public String getAdvancedOption(String key) {
        return this.advanced.get(key);
    }

    public AdTargetingOptions setAdvancedOption(String key, String value) {
        if (StringUtils.isNullOrWhiteSpace(key)) {
            throw new IllegalArgumentException("Option Key must not be null or empty string");
        }
        if (value != null) {
            this.advanced.put(key, value);
        } else {
            this.advanced.remove(key);
        }
        return this;
    }

    AdTargetingOptions addInternalPublisherKeyword(String publisherKey) {
        if (!StringUtils.isNullOrWhiteSpace(publisherKey)) {
            this.internalPublisherKeywords.add(publisherKey);
        }
        return this;
    }

    HashSet<String> getInternalPublisherKeywords() {
        return this.internalPublisherKeywords;
    }

    public AdTargetingOptions enableGeoLocation(boolean enable) {
        this.enableGeoTargeting = enable;
        return this;
    }

    public boolean isGeoLocationEnabled() {
        return this.enableGeoTargeting;
    }

    AdTargetingOptions enableDisplayAds(boolean enable) {
        this.displayEnabled = enable;
        return this;
    }

    boolean isDisplayAdsEnabled() {
        return this.displayEnabled;
    }

    AdTargetingOptions enableVideoAds(boolean enable) {
        if (!this.videoEnabledSettable) {
            this.logger.w("Video is not allowed to be changed as this device does not support video.");
        } else {
            this.videoEnabled = enable;
        }
        return this;
    }

    boolean isVideoAdsEnabled() {
        return this.videoEnabled;
    }

    boolean isVideoEnabledSettable() {
        return this.videoEnabledSettable;
    }

    public AdTargetingOptions setAge(int age) {
        this.logger.d("setAge API has been deprecated.");
        return this;
    }

    public int getAge() {
        this.logger.d("getAge API has been deprecated.");
        return Integer.MIN_VALUE;
    }
}

