/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;

class AdLocation {
    private static final String LOGTAG = AdLocation.class.getSimpleName();
    private static final float MAX_DISTANCE_IN_KILOMETERS = 3.0f;
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    private static final int ARCMINUTE_PRECISION = 6;
    private final Configuration configuration;
    private final Context context;

    public AdLocation(Context context) {
        this(context, Configuration.getInstance());
    }

    AdLocation(Context context, Configuration configuration) {
        this.context = context;
        this.configuration = configuration;
    }

    private static double roundToArcminutes(double coordinate) {
        return (double)Math.round(coordinate * 60.0) / 60.0;
    }

    private LocationAwareness getLocationAwareness() {
        if (this.configuration.getBoolean(Configuration.ConfigOption.TRUNCATE_LAT_LON)) {
            return LocationAwareness.LOCATION_AWARENESS_TRUNCATED;
        }
        return LocationAwareness.LOCATION_AWARENESS_NORMAL;
    }

    public Location getLocation() {
        Location result = null;
        LocationAwareness locationAwareness = this.getLocationAwareness();
        if (LocationAwareness.LOCATION_AWARENESS_DISABLED.equals((Object)locationAwareness)) {
            return null;
        }
        LocationManager lm = (LocationManager)this.context.getSystemService("location");
        Location gpsLocation = null;
        try {
            gpsLocation = lm.getLastKnownLocation("gps");
        }
        catch (SecurityException e) {
            this.logger.d("Failed to retrieve GPS location: No permissions to access GPS");
        }
        catch (IllegalArgumentException e) {
            this.logger.d("Failed to retrieve GPS location: No GPS found");
        }
        Location networkLocation = null;
        try {
            networkLocation = lm.getLastKnownLocation("network");
        }
        catch (SecurityException e) {
            this.logger.d("Failed to retrieve network location: No permissions to access network location");
        }
        catch (IllegalArgumentException e) {
            this.logger.d("Failed to retrieve network location: No network provider found");
        }
        if (gpsLocation == null && networkLocation == null) {
            return null;
        }
        if (gpsLocation != null && networkLocation != null) {
            float distanceInMeters = gpsLocation.distanceTo(networkLocation);
            float distanceInKilometers = distanceInMeters / 1000.0f;
            if (distanceInKilometers <= 3.0f) {
                float networkLocationAccuracy;
                float gpsLocationAccuracy = gpsLocation.hasAccuracy() ? gpsLocation.getAccuracy() : Float.MAX_VALUE;
                float f = networkLocationAccuracy = networkLocation.hasAccuracy() ? networkLocation.getAccuracy() : Float.MAX_VALUE;
                if (gpsLocationAccuracy < networkLocationAccuracy) {
                    this.logger.d("Setting lat/long using GPS determined by distance");
                    result = gpsLocation;
                } else {
                    this.logger.d("Setting lat/long using network determined by distance");
                    result = networkLocation;
                }
            } else if (gpsLocation.getTime() > networkLocation.getTime()) {
                this.logger.d("Setting lat/long using GPS");
                result = gpsLocation;
            } else {
                this.logger.d("Setting lat/long using network");
                result = networkLocation;
            }
        } else if (gpsLocation != null) {
            this.logger.d("Setting lat/long using GPS, not network");
            result = gpsLocation;
        } else {
            this.logger.d("Setting lat/long using network location, not GPS");
            result = networkLocation;
        }
        if (LocationAwareness.LOCATION_AWARENESS_TRUNCATED.equals((Object)locationAwareness)) {
            double lat = AdLocation.roundToArcminutes(result.getLatitude());
            double truncatedLat = (double)Math.round(Math.pow(10.0, 6.0) * lat) / Math.pow(10.0, 6.0);
            result.setLatitude(truncatedLat);
            double lon = AdLocation.roundToArcminutes(result.getLongitude());
            double truncatedLon = (double)Math.round(Math.pow(10.0, 6.0) * lon) / Math.pow(10.0, 6.0);
            result.setLongitude(truncatedLon);
        }
        return result;
    }

    private static enum LocationAwareness {
        LOCATION_AWARENESS_NORMAL,
        LOCATION_AWARENESS_TRUNCATED,
        LOCATION_AWARENESS_DISABLED;

    }
}

