/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.recycler;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import cn.yhq.adapter.recycler.IItemViewProvider;
import cn.yhq.adapter.recycler.IItemViewProviderKeyPolicy;
import cn.yhq.adapter.recycler.ItemViewProvider1;
import cn.yhq.adapter.recycler.ItemViewProvider2;
import cn.yhq.adapter.recycler.ItemViewProviderFactory;
import cn.yhq.adapter.recycler.RecyclerAdapter;
import cn.yhq.adapter.recycler.ViewHolder;

public abstract class RecyclerBaseAdapter<L, I>
extends RecyclerAdapter<ViewHolder> {
    private ItemViewProviderFactory<I> mItemViewProviderFactory;
    private Context mContext;
    protected L mListData;

    public RecyclerBaseAdapter(Context context) {
        this(context, null);
    }

    public RecyclerBaseAdapter(Context context, L listData) {
        this.mContext = context;
        this.mListData = listData == null ? this.newInstance() : listData;
        this.mItemViewProviderFactory = new ItemViewProviderFactory(context, this);
    }

    public final void onBindViewHolder(ViewHolder holder, int position) {
        this.mItemViewProviderFactory.onBindViewHolder(holder, position, this.getItem(position));
    }

    public final IItemViewProvider<I> register(ItemViewProvider2<I> itemViewProvider) {
        return (IItemViewProvider)this.mItemViewProviderFactory.register(itemViewProvider);
    }

    public final IItemViewProvider<I> register(Class<? extends ItemViewProvider2<I>> itemViewProviderClass) {
        return (IItemViewProvider)this.mItemViewProviderFactory.register(itemViewProviderClass);
    }

    public final IItemViewProvider<I> register(int key, ItemViewProvider1<I> itemViewProvider) {
        return (IItemViewProvider)this.mItemViewProviderFactory.register(key, itemViewProvider);
    }

    public final IItemViewProvider<I> register(int key, Class<? extends ItemViewProvider1<I>> itemViewProviderClass) {
        return (IItemViewProvider)this.mItemViewProviderFactory.register(key, itemViewProviderClass);
    }

    public final void setItemViewProviderKeyPolicy(IItemViewProviderKeyPolicy<I> itemViewProviderKeyPolicy) {
        this.mItemViewProviderFactory.setItemViewProviderKeyPolicy(itemViewProviderKeyPolicy);
    }

    public abstract I getItem(int var1);

    protected abstract L newInstance();

    public final L getListData() {
        return this.mListData;
    }

    public final void setListData(L dataList) {
        this.mListData = dataList;
    }

    @Override
    public final View onCreateView(ViewGroup parent, int viewType) {
        View itemView = this.mItemViewProviderFactory.onCreateItemView(parent, viewType);
        return itemView;
    }

    public final int getItemViewType(int position) {
        return this.mItemViewProviderFactory.getItemViewType(position, this.getItem(position));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public abstract void clearAllItem();

    public abstract void addAllItem(L var1);

    public abstract void addItem(I var1);

    public abstract void removeItem(I var1);

    public abstract void removeItem(int var1);
}

