/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.recycler;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import cn.yhq.adapter.core.IItemViewKeyPolicy;
import cn.yhq.adapter.core.IItemViewSelector;
import cn.yhq.adapter.core.ItemViewFactory;
import cn.yhq.adapter.recycler.IItemViewProvider;
import cn.yhq.adapter.recycler.IItemViewProviderKeyPolicy;
import cn.yhq.adapter.recycler.IItemViewProviderSelector;
import cn.yhq.adapter.recycler.ItemViewProvider1;
import cn.yhq.adapter.recycler.ViewHolder;

public final class ItemViewProviderFactory<T>
extends ItemViewFactory<RecyclerView.Adapter<ViewHolder>, ItemViewProvider1<T>> {
    private IItemViewProviderKeyPolicy<T> mItemViewProviderKeyPolicy;

    public ItemViewProviderFactory(Context context, RecyclerView.Adapter<ViewHolder> adapter) {
        super(context, adapter);
    }

    private ItemViewProvider1<T> obtainItemViewProvider(final int position, final T entity) {
        return (ItemViewProvider1)this.obtainItemView(new IItemViewKeyPolicy(){

            public int getItemViewKey() {
                if (ItemViewProviderFactory.this.mItemViewProviderKeyPolicy != null) {
                    return ItemViewProviderFactory.this.mItemViewProviderKeyPolicy.getItemViewProviderKey(position, entity);
                }
                return -1;
            }
        }, new IItemViewSelector<ItemViewProvider1<T>>(){

            public boolean isForItemView(ItemViewProvider1<T> itemView) {
                if (itemView instanceof IItemViewProviderSelector) {
                    return ((IItemViewProviderSelector)((Object)itemView)).isForProvider(position, entity);
                }
                return false;
            }
        });
    }

    public void setItemViewProviderKeyPolicy(IItemViewProviderKeyPolicy<T> itemViewProviderKeyPolicy) {
        this.mItemViewProviderKeyPolicy = itemViewProviderKeyPolicy;
    }

    public int getItemViewType(int position, T entity) {
        return this.obtainItemViewProvider(position, entity).getType();
    }

    public void onBindViewHolder(ViewHolder holder, int position, T entity) {
        ItemViewProvider1<T> itemViewProvider = this.obtainItemViewProvider(position, entity);
        itemViewProvider.onBindViewHolder(holder, position, entity);
    }

    public View onCreateItemView(ViewGroup parent, int viewType) {
        IItemViewProvider itemViewProvider = (IItemViewProvider)this.getItemViewByType(viewType);
        int layoutId = itemViewProvider.getItemViewLayoutId();
        return LayoutInflater.from((Context)this.mContext).inflate(layoutId, parent, false);
    }
}

