/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.recycler;

import android.content.Context;
import cn.yhq.adapter.recycler.RecyclerBaseAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerListAdapter<T>
extends RecyclerBaseAdapter<List<T>, T> {
    public RecyclerListAdapter(Context context) {
        super(context);
    }

    public RecyclerListAdapter(Context context, List<T> listData) {
        super(context, listData);
    }

    @Override
    public T getItem(int position) {
        return (T)((List)this.getListData()).get(position);
    }

    @Override
    protected List<T> newInstance() {
        return new ArrayList();
    }

    public int getItemCount() {
        return ((List)this.getListData()).size();
    }

    @Override
    public void clearAllItem() {
        ((List)this.getListData()).clear();
        this.notifyDataSetChanged();
    }

    @Override
    public void addAllItem(List<T> items) {
        ((List)this.getListData()).addAll(items);
        this.notifyItemRangeChanged(((List)this.getListData()).size() - items.size() - 1, items.size());
    }

    @Override
    public void addItem(T item) {
        ((List)this.getListData()).add(item);
        this.notifyItemChanged(((List)this.getListData()).size());
    }

    @Override
    public void removeItem(T item) {
        int position = ((List)this.getListData()).indexOf(item);
        ((List)this.getListData()).remove(item);
        this.notifyItemRemoved(position);
    }

    @Override
    public void removeItem(int position) {
        ((List)this.getListData()).remove(position);
        this.notifyItemRemoved(position);
    }
}

