/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.expand;

import android.content.Context;
import cn.yhq.adapter.core.ViewHolder;
import cn.yhq.adapter.expand.BaseExpandableListAdapter;
import cn.yhq.adapter.expand.ChildItemViewProvider2;
import cn.yhq.adapter.expand.GroupItemViewProvider2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleExpandableListAdapter<G, C>
extends BaseExpandableListAdapter<G, C> {
    private final IItemViewSetup<G, C> itemViewSetup;

    @Override
    public C getChild(G group, int childPosition) {
        return this.itemViewSetup.getChild(group, childPosition);
    }

    @Override
    public int getChildrenCount(G group) {
        return this.itemViewSetup.getChildrenCount(group);
    }

    SimpleExpandableListAdapter(Context context, List<G> listData, final int groupItemViewLayoutId, final int childItemViewLayoutId, final IItemViewSetup<G, C> itemViewSetup) {
        super(context, listData);
        this.itemViewSetup = itemViewSetup;
        this.register(new GroupItemViewProvider2<G>(){

            @Override
            public void setupView(ViewHolder viewHolder, int position, G entity, boolean isExpanded) {
                itemViewSetup.setupGroupView(viewHolder, position, entity, isExpanded);
            }

            @Override
            public int getItemViewLayoutId() {
                return groupItemViewLayoutId;
            }

            @Override
            public boolean isForProvider(int position, G entity) {
                return true;
            }
        });
        this.register(new ChildItemViewProvider2<G, C>(){

            @Override
            public int getItemViewLayoutId() {
                return childItemViewLayoutId;
            }

            @Override
            public void setupView(ViewHolder viewHolder, int groupPosition, G groupEntity, int childPosition, C childEntity) {
                itemViewSetup.setupChildView(viewHolder, groupPosition, groupEntity, childPosition, childEntity);
            }

            @Override
            public boolean isForProvider(int groupPosition, G groupEntity, int childPosition, C childEntity) {
                return true;
            }
        });
    }

    public static <G, C> SimpleExpandableListAdapter<G, C> create(Context context, List<G> items, int groupItemViewLayoutId, int childItemViewLayoutId, IItemViewSetup itemViewSetup) {
        return new SimpleExpandableListAdapter<G, C>(context, items, groupItemViewLayoutId, childItemViewLayoutId, itemViewSetup);
    }

    public static <G, C> SimpleExpandableListAdapter<G, C> create(Context context, G[] items, int groupItemViewLayoutId, int childItemViewLayoutId, IItemViewSetup itemViewSetup) {
        return new SimpleExpandableListAdapter<G, C>(context, Arrays.asList(items), groupItemViewLayoutId, childItemViewLayoutId, itemViewSetup);
    }

    public static <G, C> SimpleExpandableListAdapter<G, C> create(Context context, int groupItemViewLayoutId, int childItemViewLayoutId, IItemViewSetup itemViewSetup) {
        return new SimpleExpandableListAdapter(context, new ArrayList(), groupItemViewLayoutId, childItemViewLayoutId, itemViewSetup);
    }

    public static interface IItemViewSetup<G, C> {
        public void setupGroupView(ViewHolder var1, int var2, G var3, boolean var4);

        public void setupChildView(ViewHolder var1, int var2, G var3, int var4, C var5);

        public C getChild(G var1, int var2);

        public int getChildrenCount(G var1);
    }
}

