/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.core;

import android.content.Context;
import cn.yhq.adapter.core.IItemViewKeyPolicy;
import cn.yhq.adapter.core.IItemViewSelector;
import cn.yhq.adapter.core.ItemView;
import cn.yhq.adapter.core.ItemViewContainer;
import java.util.ArrayList;
import java.util.List;

public abstract class ItemViewFactory<Adapter, T extends ItemView<Adapter>> {
    protected ItemViewContainer<Adapter> mItemViewContainer;
    protected Context mContext;

    public ItemViewFactory(Context context, Adapter adapter) {
        this.mContext = context;
        this.mItemViewContainer = new ItemViewContainer<Adapter>(context, adapter);
    }

    protected final T obtainItemView(IItemViewKeyPolicy keyPolicy, IItemViewSelector<T> selector) {
        T itemView = this.getItemViewByKeyPolicy(keyPolicy);
        if (itemView == null) {
            itemView = this.getItemViewBySelector(selector);
        }
        return itemView;
    }

    public final T register(T itemView) {
        return (T)this.mItemViewContainer.put((ItemView<Adapter>)itemView);
    }

    public final T register(Class<? extends T> itemViewClass) {
        return (T)this.mItemViewContainer.put(itemViewClass);
    }

    public final T register(int key, T itemView) {
        return (T)this.mItemViewContainer.put(key, (ItemView<Adapter>)itemView);
    }

    public final T register(int key, Class<? extends T> itemViewClass) {
        return (T)this.mItemViewContainer.put(key, itemViewClass);
    }

    protected final T getItemViewByKey(int key) {
        return (T)this.mItemViewContainer.getByKey(key);
    }

    protected final T getItemViewByType(int type) {
        return (T)this.mItemViewContainer.getByType(type);
    }

    protected final T getItemViewBySelector(IItemViewSelector<T> selector) {
        if (selector == null) {
            return null;
        }
        for (ItemView itemView : this.getAllItemView()) {
            if (!selector.isForItemView(itemView)) continue;
            return (T)itemView;
        }
        return null;
    }

    protected final T getItemViewByKeyPolicy(IItemViewKeyPolicy keyPolicy) {
        if (keyPolicy == null) {
            return null;
        }
        int key = keyPolicy.getItemViewKey();
        return this.getItemViewByKey(key);
    }

    protected final int getItemViewSize() {
        return this.mItemViewContainer.getSize();
    }

    protected final List<T> getAllItemView() {
        List<ItemView<Adapter>> itemViewTypes = this.mItemViewContainer.getAll();
        ArrayList<ItemView<Adapter>> list = new ArrayList<ItemView<Adapter>>();
        for (int i = 0; i < itemViewTypes.size(); ++i) {
            list.add(itemViewTypes.get(i));
        }
        return list;
    }
}

