/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.TextView;
import cn.yhq.adapter.core.ImageLoader;
import java.io.File;

public final class ViewHolder {
    private Context mContext;
    private View mConvertView;
    private int currentResId;
    private int mPosition;
    private boolean isRecycler;
    private SparseArray<View> views = new SparseArray();
    private static ImageLoader mImageLoader;

    public static void setImageLoader(ImageLoader imageLoader) {
        mImageLoader = imageLoader;
    }

    ViewHolder(Context context, ViewGroup parent, int layoutId, int position) {
        this(context, LayoutInflater.from((Context)context).inflate(layoutId, parent, false), position);
    }

    ViewHolder(Context context, View convertView, int position) {
        this.mContext = context;
        this.mPosition = position;
        this.mConvertView = convertView;
        this.mConvertView.setTag((Object)this);
    }

    public static ViewHolder get(Context context, View convertView, int position) {
        return new ViewHolder(context, convertView, position);
    }

    public static ViewHolder get(View convertView, int position) {
        ViewHolder viewHolder = (ViewHolder)convertView.getTag();
        viewHolder.setPosition(position);
        viewHolder.setRecycler(true);
        return viewHolder;
    }

    public static ViewHolder get(Context context, View convertView, ViewGroup parent, int layoutId, int position) {
        if (convertView == null) {
            if (layoutId == 0) {
                return new ViewHolder(context, new View(context), position);
            }
            return new ViewHolder(context, parent, layoutId, position);
        }
        ViewHolder viewHolder = (ViewHolder)convertView.getTag();
        viewHolder.setPosition(position);
        viewHolder.setRecycler(true);
        return viewHolder;
    }

    void setRecycler(boolean isRecycler) {
        this.isRecycler = isRecycler;
    }

    public boolean isRecycler() {
        return this.isRecycler;
    }

    public View getConvertView() {
        return this.mConvertView;
    }

    public int getPosition() {
        return this.mPosition;
    }

    void setPosition(int position) {
        this.mPosition = position;
    }

    public <T extends View> T getView(int id) {
        View view = (View)this.views.get(id);
        if (view == null && (view = this.mConvertView.findViewById(id)) != null) {
            this.views.put(view.getId(), (Object)view);
        }
        this.bindResId(id);
        return (T)view;
    }

    public ViewHolder bindResId(int resId) {
        this.currentResId = resId;
        return this;
    }

    public ViewHolder setImage(int resId, String url) {
        if (mImageLoader != null) {
            mImageLoader.setImage((View)this.getView(resId), url);
        }
        return this;
    }

    public ViewHolder setImage(int resId, File file) {
        if (mImageLoader != null) {
            mImageLoader.setImage((View)this.getView(resId), file);
        }
        return this;
    }

    public ViewHolder setVisibility(int resId, int visibility) {
        Object view = this.getView(resId);
        view.setVisibility(visibility);
        return this;
    }

    public ViewHolder setText(CharSequence text) {
        this.setText(this.currentResId, text);
        return this;
    }

    public ViewHolder setText(int text) {
        this.setText(this.currentResId, text);
        return this;
    }

    public ViewHolder setChecked(boolean checked) {
        this.setChecked(this.currentResId, checked);
        return this;
    }

    public ViewHolder setImage(String url) {
        this.setImage(this.currentResId, url);
        return this;
    }

    public ViewHolder setImage(Bitmap bitmap) {
        this.setImage(this.currentResId, bitmap);
        return this;
    }

    public ViewHolder setImage(Drawable drawable) {
        this.setImage(this.currentResId, drawable);
        return this;
    }

    public ViewHolder setImage(File file) {
        this.setImage(this.currentResId, file);
        return this;
    }

    public ViewHolder setImage(int image) {
        this.setImage(this.currentResId, image);
        return this;
    }

    public ViewHolder setVisibility(int visibility) {
        this.setVisibility(this.currentResId, visibility);
        return this;
    }

    public ViewHolder setOnItemLongClickListener(int resId, AdapterView.OnItemLongClickListener onItemLongClickListener) {
        AdapterView adapterView = (AdapterView)this.getView(resId);
        adapterView.setOnItemLongClickListener(onItemLongClickListener);
        return this;
    }

    public ViewHolder setOnItemLongClickListener(AdapterView.OnItemLongClickListener onItemLongClickListener) {
        this.setOnItemLongClickListener(this.currentResId, onItemLongClickListener);
        return this;
    }

    public ViewHolder setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.setOnLongClickListener(this.currentResId, onLongClickListener);
        return this;
    }

    public ViewHolder setOnClickListener(View.OnClickListener onClickListener) {
        this.setOnClickListener(this.currentResId, onClickListener);
        return this;
    }

    public ViewHolder setText(int viewId, CharSequence text) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setText(text);
        return this;
    }

    public ViewHolder setText(int viewId, int resId) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setText(resId);
        return this;
    }

    public ViewHolder setImage(int viewId, int resId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(resId);
        return this;
    }

    public ViewHolder setImage(int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public ViewHolder setImage(int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    public ViewHolder setBackgroundColor(int viewId, int color) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    public ViewHolder setBackgroundRes(int viewId, int backgroundRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public ViewHolder setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public ViewHolder setTextColorRes(int viewId, int textColorRes) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(textColorRes));
        return this;
    }

    public ViewHolder setVisible(int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public ViewHolder linkify(int viewId) {
        TextView view = (TextView)this.getView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public ViewHolder setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setProgress(progress);
        return this;
    }

    public ViewHolder setBackgroundColor(int color) {
        this.setBackgroundColor(this.currentResId, color);
        return this;
    }

    public ViewHolder setBackgroundRes(int backgroundRes) {
        this.setBackgroundRes(this.currentResId, backgroundRes);
        return this;
    }

    public ViewHolder setTextColor(int textColor) {
        this.setTextColor(this.currentResId, textColor);
        return this;
    }

    public ViewHolder setTextColorRes(int textColorRes) {
        this.setTextColorRes(this.currentResId, textColorRes);
        return this;
    }

    public ViewHolder setVisible(boolean visible) {
        this.setVisible(this.currentResId, visible);
        return this;
    }

    public ViewHolder linkify() {
        this.linkify(this.currentResId);
        return this;
    }

    public ViewHolder setProgress(int progress) {
        this.setProgress(this.currentResId, progress);
        return this;
    }

    public ViewHolder setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        return this;
    }

    public ViewHolder setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setRating(rating);
        return this;
    }

    public ViewHolder setMax(int max) {
        this.setMax(this.currentResId, max);
        return this;
    }

    public ViewHolder setRating(float rating) {
        this.setRating(this.currentResId, rating);
        return this;
    }

    public ViewHolder setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public ViewHolder setTag(int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    public ViewHolder setKeyTag(int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public ViewHolder setRating(float rating, int max) {
        this.setRating(this.currentResId, rating, max);
        return this;
    }

    public ViewHolder setTag(Object tag) {
        this.setTag(this.currentResId, tag);
        return this;
    }

    public ViewHolder setKeyTag(int key, Object tag) {
        this.setKeyTag(this.currentResId, key, tag);
        return this;
    }

    public ViewHolder setChecked(int viewId, boolean checked) {
        Checkable view = (Checkable)this.getView(viewId);
        view.setChecked(checked);
        return this;
    }

    public ViewHolder setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    public ViewHolder setOnTouchListener(int viewId, View.OnTouchListener listener) {
        Object view = this.getView(viewId);
        view.setOnTouchListener(listener);
        return this;
    }

    public ViewHolder setOnTouchListener(View.OnTouchListener listener) {
        this.setOnTouchListener(this.currentResId, listener);
        return this;
    }

    public ViewHolder setOnLongClickListener(int viewId, View.OnLongClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnLongClickListener(listener);
        return this;
    }

    public ViewHolder setOnCheckedChangeListener(int viewId, CompoundButton.OnCheckedChangeListener listener) {
        CompoundButton view = (CompoundButton)this.getView(viewId);
        view.setOnCheckedChangeListener(listener);
        return this;
    }

    public ViewHolder setOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener listener) {
        this.setOnCheckedChangeListener(this.currentResId, listener);
        return this;
    }

    public ViewHolder setOnCheckedChangeListener(int viewId, RadioGroup.OnCheckedChangeListener listener) {
        RadioGroup view = (RadioGroup)this.getView(viewId);
        view.setOnCheckedChangeListener(listener);
        return this;
    }

    public ViewHolder setOnCheckedChangeListener(RadioGroup.OnCheckedChangeListener listener) {
        this.setOnCheckedChangeListener(this.currentResId, listener);
        return this;
    }
}

