/*
 * Decompiled with CFR 0.152.
 */
package cn.yhq.adapter.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import cn.yhq.view.binding.ViewBinder;
import java.io.File;

public final class ViewHolder {
    private Context mContext;
    private View mConvertView;
    private SparseArray<View> mViews = new SparseArray();
    private int currentResId;
    private int mPosition;
    private boolean isRecycler;

    ViewHolder(Context context, ViewGroup parent, int layoutId, int position) {
        this(context, LayoutInflater.from((Context)context).inflate(layoutId, parent, false), position);
    }

    ViewHolder(Context context, View convertView, int position) {
        this.mContext = context;
        this.mPosition = position;
        this.mConvertView = convertView;
        this.mConvertView.setTag((Object)this);
    }

    public static ViewHolder get(Context context, View convertView, int position) {
        return new ViewHolder(context, convertView, position);
    }

    public static ViewHolder get(View convertView, int position) {
        ViewHolder viewHolder = (ViewHolder)convertView.getTag();
        viewHolder.setPosition(position);
        viewHolder.setRecycler(true);
        return viewHolder;
    }

    public static ViewHolder get(Context context, View convertView, ViewGroup parent, int layoutId, int position) {
        if (convertView == null) {
            if (layoutId == 0) {
                return new ViewHolder(context, new View(context), position);
            }
            return new ViewHolder(context, parent, layoutId, position);
        }
        ViewHolder viewHolder = (ViewHolder)convertView.getTag();
        viewHolder.setPosition(position);
        viewHolder.setRecycler(true);
        return viewHolder;
    }

    void setRecycler(boolean isRecycler) {
        this.isRecycler = isRecycler;
    }

    public boolean isRecycler() {
        return this.isRecycler;
    }

    public View getConvertView() {
        return this.mConvertView;
    }

    public int getPosition() {
        return this.mPosition;
    }

    void setPosition(int position) {
        this.mPosition = position;
    }

    public <T extends View> T findViewById(int id) {
        this.bindResId(id);
        return (T)ViewBinder.findViewById((View)this.mConvertView, (int)id);
    }

    public <T extends View> T getView(int key) {
        Object v = (View)this.mViews.get(key);
        if (v == null) {
            v = this.findViewById(key);
            this.mViews.put(key, v);
        }
        this.bindResId(key);
        return (T)v;
    }

    public ViewHolder bindResId(int resId) {
        this.currentResId = resId;
        return this;
    }

    public ViewHolder bindTextData(int resId, CharSequence text) {
        Object v = this.getView(resId);
        ViewBinder.bindTextData(v, (CharSequence)text);
        return this;
    }

    public ViewHolder bindTextData(int resId, int text) {
        Object v = this.getView(resId);
        ViewBinder.bindTextData(v, (int)text);
        return this;
    }

    public ViewHolder bindCheckData(int resId, boolean checked) {
        Object v = this.getView(resId);
        ViewBinder.bindCheckData(v, (boolean)checked);
        return this;
    }

    public ViewHolder bindImageData(int resId, String url) {
        Object v = this.getView(resId);
        ViewBinder.bindImageData(v, (String)url);
        return this;
    }

    public ViewHolder bindImageData(int resId, Bitmap bitmap) {
        Object v = this.getView(resId);
        ViewBinder.bindImageData(v, (Bitmap)bitmap);
        return this;
    }

    public ViewHolder bindImageData(int resId, Drawable drawable) {
        Object v = this.getView(resId);
        ViewBinder.bindImageData(v, (Drawable)drawable);
        return this;
    }

    public ViewHolder bindImageData(int resId, File file) {
        Object v = this.getView(resId);
        ViewBinder.bindImageData(v, (File)file);
        return this;
    }

    public ViewHolder bindImageData(int resId, int image) {
        Object v = this.getView(resId);
        ViewBinder.bindImageData(v, (int)image);
        return this;
    }

    public ViewHolder setVisibility(int resId, int visibility) {
        Object v = this.getView(resId);
        ViewBinder.setVisibility(v, (int)visibility);
        return this;
    }

    public ViewHolder bindTextData(CharSequence text) {
        Object v = this.getView(this.currentResId);
        ViewBinder.bindTextData(v, (CharSequence)text);
        return this;
    }

    public ViewHolder bindTextData(int text) {
        Object v = this.getView(this.currentResId);
        ViewBinder.bindTextData(v, (int)text);
        return this;
    }

    public ViewHolder bindCheckData(boolean checked) {
        Object v = this.getView(this.currentResId);
        ViewBinder.bindCheckData(v, (boolean)checked);
        return this;
    }

    public ViewHolder bindImageData(String url) {
        Object v = this.getView(this.currentResId);
        ViewBinder.bindImageData(v, (String)url);
        return this;
    }

    public ViewHolder bindImageData(Bitmap bitmap) {
        Object v = this.getView(this.currentResId);
        ViewBinder.bindImageData(v, (Bitmap)bitmap);
        return this;
    }

    public ViewHolder bindImageData(Drawable drawable) {
        Object v = this.getView(this.currentResId);
        ViewBinder.bindImageData(v, (Drawable)drawable);
        return this;
    }

    public ViewHolder bindImageData(File file) {
        Object v = this.getView(this.currentResId);
        ViewBinder.bindImageData(v, (File)file);
        return this;
    }

    public ViewHolder bindImageData(int image) {
        Object v = this.getView(this.currentResId);
        ViewBinder.bindImageData(v, (int)image);
        return this;
    }

    public ViewHolder setVisibility(int visibility) {
        Object v = this.getView(this.currentResId);
        ViewBinder.setVisibility(v, (int)visibility);
        return this;
    }

    public ViewHolder setOnItemLongClickListener(int resId, AdapterView.OnItemLongClickListener onItemLongClickListener) {
        AdapterView v = (AdapterView)this.getView(resId);
        v.setOnItemLongClickListener(onItemLongClickListener);
        return this;
    }

    public ViewHolder setOnItemLongClickListener(AdapterView.OnItemLongClickListener onItemLongClickListener) {
        AdapterView v = (AdapterView)this.getView(this.currentResId);
        v.setOnItemLongClickListener(onItemLongClickListener);
        return this;
    }

    public ViewHolder setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        Object v = this.getView(this.currentResId);
        v.setOnLongClickListener(onLongClickListener);
        return this;
    }

    public ViewHolder setOnLongClickListener(int resId, View.OnLongClickListener onLongClickListener) {
        Object v = this.getView(resId);
        v.setOnLongClickListener(onLongClickListener);
        return this;
    }

    public ViewHolder setOnClickListener(View.OnClickListener onClickListener) {
        Object v = this.getView(this.currentResId);
        v.setOnClickListener(onClickListener);
        return this;
    }

    public ViewHolder setOnClickListener(int resId, View.OnClickListener onClickListener) {
        Object v = this.getView(resId);
        v.setOnClickListener(onClickListener);
        return this;
    }

    public ViewHolder setTag(int resId, Object tag) {
        Object v = this.getView(resId);
        v.setTag(tag);
        return this;
    }

    public ViewHolder setTag(Object tag) {
        Object v = this.getView(this.currentResId);
        v.setTag(tag);
        return this;
    }

    public ViewHolder setKeyTag(int resId, int key, Object tag) {
        Object v = this.getView(resId);
        v.setTag(key, tag);
        return this;
    }

    public ViewHolder setKeyTag(int key, Object tag) {
        Object v = this.getView(this.currentResId);
        v.setTag(key, tag);
        return this;
    }
}

