/*
 * Decompiled with CFR 0.152.
 */
package cn.ycbjie.ycstatusbarlib.bar;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.Toolbar;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import cn.ycbjie.ycstatusbarlib.StatusBarUtils;
import cn.ycbjie.ycstatusbarlib.bar.BarStatusKitKat;
import cn.ycbjie.ycstatusbarlib.bar.BarStatusLollipop;
import cn.ycbjie.ycstatusbarlib.utils.StatusBarColorUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class StateAppBar {
    public static void setStatusBarColor(Activity activity, @ColorInt int statusColor) {
        StatusBarUtils.checkNull(activity);
        if (Build.VERSION.SDK_INT >= 21) {
            BarStatusLollipop.setStatusBarColor(activity, statusColor);
        } else if (Build.VERSION.SDK_INT >= 19) {
            BarStatusKitKat.setStatusBarColor(activity, statusColor);
        }
    }

    public static void translucentStatusBar(Activity activity) {
        StatusBarUtils.checkNull(activity);
        StateAppBar.translucentStatusBar(activity, false);
    }

    public static void translucentStatusBar(Activity activity, boolean hideStatusBarBackground) {
        StatusBarUtils.checkNull(activity);
        if (Build.VERSION.SDK_INT >= 21) {
            BarStatusLollipop.translucentStatusBar(activity, hideStatusBarBackground);
        } else if (Build.VERSION.SDK_INT >= 19) {
            BarStatusKitKat.translucentStatusBar(activity);
        }
    }

    public static void setStatusBarColorForCollapsingToolbar(@NonNull Activity activity, AppBarLayout appBarLayout, CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, @ColorInt int statusColor) {
        StatusBarUtils.checkNull(activity);
        if (Build.VERSION.SDK_INT >= 21) {
            BarStatusLollipop.setStatusBarColorForCollapsingToolbar(activity, appBarLayout, collapsingToolbarLayout, toolbar, statusColor);
        } else if (Build.VERSION.SDK_INT >= 19) {
            BarStatusKitKat.setStatusBarColorForCollapsingToolbar(activity, appBarLayout, collapsingToolbarLayout, toolbar, statusColor);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void setStatusBarLightMode(Activity activity, @ColorInt int color2) {
        StatusBarUtils.checkNull(activity);
        if (Build.VERSION.SDK_INT >= 19) {
            if (StateAppBar.setStatusBarLightMode(activity, true) || StateAppBar.FlymeSetStatusBarLightMode(activity, true)) {
                if (Build.VERSION.SDK_INT >= 21) {
                    activity.getWindow().setStatusBarColor(color2);
                } else if (Build.VERSION.SDK_INT >= 19) {
                    StateAppBar.setStatusBarColor(activity, color2);
                }
            } else if (Build.VERSION.SDK_INT >= 23) {
                activity.getWindow().setBackgroundDrawableResource(17170445);
                activity.getWindow().getDecorView().setSystemUiVisibility(9216);
                activity.getWindow().setStatusBarColor(color2);
                ViewGroup mContentView = (ViewGroup)activity.getWindow().findViewById(0x1020002);
                View mChildView = mContentView.getChildAt(0);
                if (mChildView != null) {
                    mChildView.setFitsSystemWindows(true);
                    ViewCompat.requestApplyInsets((View)mChildView);
                }
            }
        }
    }

    public static void setStatusBarLightForCollapsingToolbar(Activity activity, AppBarLayout appBarLayout, CollapsingToolbarLayout collapsingToolbarLayout, Toolbar toolbar, @ColorInt int statusBarColor) {
        StatusBarUtils.checkNull(activity);
        if (Build.VERSION.SDK_INT >= 21) {
            BarStatusLollipop.setStatusBarWhiteForCollapsingToolbar(activity, appBarLayout, collapsingToolbarLayout, toolbar, statusBarColor);
        } else if (Build.VERSION.SDK_INT >= 19) {
            BarStatusKitKat.setStatusBarWhiteForCollapsingToolbar(activity, appBarLayout, collapsingToolbarLayout, toolbar, statusBarColor);
        }
    }

    public static boolean setStatusBarLightMode(Activity activity, boolean darkmode) {
        StatusBarUtils.checkNull(activity);
        try {
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            if (Build.VERSION.SDK_INT >= 23) {
                window.getDecorView().setSystemUiVisibility(8192);
            }
            Class<?> clazz = activity.getWindow().getClass();
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)activity.getWindow(), darkmode ? darkModeFlag : 0, darkModeFlag);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean FlymeSetStatusBarLightMode(Activity activity, boolean darkmode) {
        StatusBarUtils.checkNull(activity);
        return StatusBarColorUtils.setStatusBarDarkIcon(activity, darkmode);
    }

    static void setContentTopPadding(Activity activity, int padding) {
        StatusBarUtils.checkNull(activity);
        ViewGroup mContentView = (ViewGroup)activity.getWindow().findViewById(0x1020002);
        mContentView.setPadding(0, padding, 0, 0);
    }

    static int getPxFromDp(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

