/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.ycprogresslib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.ns.yc.ycprogresslib.ProgressBarUtils;
import com.ns.yc.ycprogresslib.R;

public class RingProgressBar
extends View {
    private int percent;
    private int progressMax;
    private int dotColor;
    private int dotBgColor;
    private int showMode;
    private float percentTextSize;
    private int percentTextColor;
    private int percentThinPadding;
    private String unitText;
    private float unitTextSize;
    private int unitTextColor;
    private int unitTextAlignMode;
    public static final int UNIT_TEXT_ALIGN_MODE_DEFAULT = 0;
    public static final int UNIT_TEXT_ALIGN_MODE_CN = 1;
    public static final int UNIT_TEXT_ALIGN_MODE_EN = 2;
    private Paint mPaint;
    private float mSin_1;
    private Typeface mPercentTypeface;
    private float mCenterX;
    private float mCenterY;
    private Canvas mCanvas;
    private Bitmap mBitmap;
    private Xfermode mClearCanvasXfermode;
    private Xfermode mPercentThinXfermode;

    public RingProgressBar(Context context) {
        this(context, null);
    }

    public RingProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RingProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
        this.mSin_1 = (float)Math.sin(Math.toRadians(1.0));
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPercentTypeface = Typeface.DEFAULT;
        this.mClearCanvasXfermode = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
        if (this.percentThinPadding != 0) {
            this.mPercentThinXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
        }
    }

    private void initialize(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RingProgressBar);
        this.progressMax = ta.getInteger(R.styleable.RingProgressBar_progressMax, 100);
        this.dotColor = ta.getColor(R.styleable.RingProgressBar_dotColor, -1);
        this.dotBgColor = ta.getColor(R.styleable.RingProgressBar_dotBgColor, -7829368);
        this.showMode = ta.getInt(R.styleable.RingProgressBar_showMode, 1);
        if (this.showMode != 0) {
            this.percentTextSize = ta.getDimension(R.styleable.RingProgressBar_percentTextSize, ProgressBarUtils.dp2px(context, 30.0f));
            this.percentTextColor = ta.getInt(R.styleable.RingProgressBar_percentTextColor, -1);
            this.percentThinPadding = ta.getInt(R.styleable.RingProgressBar_percentThinPadding, 0);
            this.unitText = ta.getString(R.styleable.RingProgressBar_unitText);
            this.unitTextSize = ta.getDimension(R.styleable.RingProgressBar_unitTextSize, this.percentTextSize);
            this.unitTextColor = ta.getInt(R.styleable.RingProgressBar_unitTextColor, -16777216);
            this.unitTextAlignMode = ta.getInt(R.styleable.RingProgressBar_unitTextAlignMode, 0);
            if (this.unitText == null) {
                this.unitText = "%";
            }
        }
        ta.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.mBitmap);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawCircleDot(this.mCanvas);
        if (this.showMode != 0) {
            this.drawPercentUnit(this.mCanvas);
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
    }

    private void drawCircleDot(Canvas canvas) {
        this.mPaint.setXfermode(this.mClearCanvasXfermode);
        this.mCanvas.drawPaint(this.mPaint);
        this.mPaint.setXfermode(null);
        float outerRadius = (float)(this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight()) / 2.0f;
        this.mCenterX = (float)this.getWidth() / 2.0f;
        this.mCenterY = (float)this.getHeight() / 2.0f;
        float dotRadius = this.mSin_1 * outerRadius / (1.0f + this.mSin_1);
        this.mPaint.setColor(this.dotColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        int count = 0;
        while (count++ < this.percent) {
            this.mCanvas.drawCircle(this.mCenterX, this.mCenterY - outerRadius + dotRadius, dotRadius, this.mPaint);
            this.mCanvas.rotate(3.6f, this.mCenterX, this.mCenterY);
        }
        this.mPaint.setColor(this.dotBgColor);
        while (true) {
            int n = --count;
            ++count;
            if (n >= 100) break;
            this.mCanvas.drawCircle(this.mCenterX, this.mCenterY - outerRadius + dotRadius, dotRadius, this.mPaint);
            this.mCanvas.rotate(3.6f, this.mCenterX, this.mCenterY);
        }
    }

    private void drawPercentUnit(Canvas canvas) {
        this.mPaint.setTypeface(this.mPercentTypeface);
        this.mPaint.setTextSize(this.percentTextSize);
        float percentTextWidth = this.mPaint.measureText(this.percent + "");
        this.mPaint.setTypeface(Typeface.DEFAULT);
        this.mPaint.setTextSize(this.unitTextSize);
        float unitTextWidth = this.mPaint.measureText(this.unitText);
        Paint.FontMetrics fm_unit = this.mPaint.getFontMetrics();
        float textWidth = percentTextWidth + unitTextWidth;
        float baseline = 0.0f;
        if (this.showMode == 1) {
            float textHeight = this.percentTextSize > this.unitTextSize ? this.percentTextSize : this.unitTextSize;
            this.mPaint.setTextSize(textHeight);
            Paint.FontMetrics fm = this.mPaint.getFontMetrics();
            baseline = this.mCenterY + (fm.descent - fm.ascent) / 2.0f - fm.descent;
        }
        this.mPaint.setTypeface(this.mPercentTypeface);
        this.mPaint.setTextSize(this.percentTextSize);
        this.mPaint.setColor(this.percentTextColor);
        canvas.drawText(this.percent + "", this.mCenterX - textWidth / 2.0f, baseline, this.mPaint);
        if (this.percentThinPadding != 0) {
            this.mPaint.setXfermode(this.mPercentThinXfermode);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)this.percentThinPadding);
            canvas.drawText(this.percent + "", this.mCenterX - textWidth / 2.0f, baseline, this.mPaint);
            this.mPaint.setXfermode(null);
            this.mPaint.setStyle(Paint.Style.FILL);
        }
        this.mPaint.setTypeface(Typeface.DEFAULT);
        this.mPaint.setTextSize(this.unitTextSize);
        this.mPaint.setColor(this.unitTextColor);
        switch (this.unitTextAlignMode) {
            case 1: {
                baseline -= fm_unit.descent / 4.0f;
                break;
            }
            case 2: {
                baseline -= fm_unit.descent * 2.0f / 3.0f;
                break;
            }
        }
        canvas.drawText(this.unitText, this.mCenterX - textWidth / 2.0f + percentTextWidth, baseline, this.mPaint);
    }

    public synchronized void setProgressMax(int progressMax) {
        if (progressMax < 0 || progressMax > 100) {
            throw new IllegalArgumentException("progressMax mustn't smaller than 0 or 100");
        }
        this.progressMax = progressMax;
    }

    public synchronized void setProgress(int progress) {
        if (progress < 0 || progress > this.progressMax) {
            throw new IllegalArgumentException(String.format(this.getResources().getString(R.string.progress_out_of_range), this.progressMax));
        }
        this.percent = progress * 100 / this.progressMax;
        this.postInvalidate();
    }

    public void setDotColor(@ColorInt int dotColor) {
        this.dotColor = dotColor;
        this.invalidate();
    }

    public void setDotBgColor(@ColorInt int dotBgColor) {
        this.dotBgColor = dotBgColor;
        this.invalidate();
    }

    public void setShowMode(@ProgressBarUtils.RingShowModeType int showMode) {
        this.showMode = showMode;
    }

    public void setPercentTextSize(float percentTextSize) {
        this.percentTextSize = percentTextSize;
        this.invalidate();
    }

    public void setPercentTextColor(@ColorInt int percentTextColor) {
        this.percentTextColor = percentTextColor;
        this.invalidate();
    }

    public void setPercentThinPadding(int percentThinPadding) {
        this.percentThinPadding = percentThinPadding;
        this.invalidate();
    }

    public void setUnitText(@NonNull String unitText) {
        this.unitText = unitText;
        this.invalidate();
    }

    public void setUnitTextSize(float unitTextSize) {
        this.unitTextSize = unitTextSize;
        this.invalidate();
    }

    public void setUnitTextColor(@ColorInt int unitTextColor) {
        this.unitTextColor = unitTextColor;
        this.invalidate();
    }
}

